/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>



int main(int argc, char *argv[])
/*******************************************************************
*                                                                 
* Program : Bufr_decode
*                                                              
*                                                             
* Author: Milan Dragosavac    ECMWF    July 1996
*  
* Purpose: Decode bufr message
* 
*
*
* Usage:
* 
*
*
* References:
*  
*
*
*
* File formats:
* 
*
*
* Restrictions:
*  
* 
* Error handling:
* 
*
*
* Notes:
* 
*
*
*******************************************************************/
{
#define KVALS 4096000
#define KELEM 160000

  FILE *fp; 
  char bufr_message[512000];
  char filename[256];
  long int length=512000;
  long int status = 0;
  int  Nbpw;

  unsigned long int *kbuff;
  long int ksup[9];
  long int ksec0[3];
  long int ksec1[40];
  long int ksec2[4096];
  long int ksec3[4]; 
  long int ksec4[2];
  long int key[46];
  long int kerr;


 
  int i;
  long kelem = KELEM,kvals = KVALS;

  static char cnames[KELEM][64],cunits[KELEM][24];
  

  char cvals[KVALS][80];

  double values[KVALS],vals[KVALS];
  long icode = 0;
  long ktdlst[KELEM],ktdexp[KELEM],ktdlen,ktdexl;

 if(sizeof(long) == 4) Nbpw=32;
  else if(sizeof(long) == 8) Nbpw=64;
  else{
    printf("Abort.....\n");
  }

  printf("%d\n",Nbpw);

/*     Get input and output file name.  */
/*     -------------------------------  */  

  if(argc != 3) {
    printf("Usage: bufr_decode -i infile \n");
    printf("Please try again. \n");
    exit(1);
  }

  printf("%c",argc);

  if(!strcmp(argv[1],"-i")) strcpy(filename,argv[2]);
  else {
    printf("Usage: bufr_decode -i infile \n");
    exit(1);
  }

/*     Open input file       */
/*     ---------------       */  

  if((fp = fopen(filename,"r")) == NULL) {
    printf("cannot open file\n");
    exit(1);
  }
  
/*     Read in bufr messages */
/*     --------------------- */  

  while(status >= 0){
      long current_ss;
     status = readbufr( fp,&bufr_message,&length);

     if(     status == -1 ) printf("End of file.\n");
     else if(status == -2 ) printf("Error in file handling\n");
     else if(status == -3 ) printf("Too small input array.\n");
     else if(status == -4 ) printf("Too small input array.\n");
     else {
       printf("It is OK.\n");
       printf("message read ");
       printf("%d\n",length);
       printf("%s\n",&bufr_message[0]);
     }
     status=-1;

/*    Expand bufr message calling fortran program */
       kbuff = (unsigned long *) bufr_message;
      length /= 4;

      bus012_(&length, kbuff , ksup, ksec0, ksec1, ksec2,  &kerr) ;
      buprs0_(ksec0);
      buprs1_(ksec1);

      if (ksup[5] > 1)
        kelem = kvals/ksup[5];
      else
        kelem = KELEM;

      if ( kelem > KELEM ) kelem = KELEM;
      kerr = 0;
      bufrex_(&length,(long *)kbuff,ksup,ksec0,ksec1,ksec2,ksec3,ksec4,
              &kelem,(char **)cnames,(char **)cunits,&kvals,
              values,(char **)cvals,&kerr);
      if ( kerr )
        {
          kerr = 0;
        }

      buukey_(ksec1,ksec2,key,ksup,&kerr);

      busel_(&ktdlen,ktdlst,&ktdexl,ktdexp,&kerr);
      buprs3_(ksec3,&ktdlen,ktdlst,&ktdexl,ktdexp,&kelem,(char **)cnames);

      icode = 0;
      current_ss = 1;
      buprt_(&icode,&current_ss,&current_ss,&kelem,(char **)cnames,
                         (char **)cunits,(char **)cvals,
                         &kvals,values,ksup,ksec1,&kerr);

      
  }

  return kerr;

}

