C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

	subroutine gribin(kunit,karray,kinlen,koutlen,keof,kret)
C---->
C
C	This subroutine mimics the behaviour of the original GRIBIN 
C	but makes a call to PBGRIB to retrieve GRIB products.  Because 
C	MAGICS calls GRIBIN with an invalid buffer size, this mimic 
C	version has to call PBGRIB with a phoney buffer size - dumlen,
C	currently 1000000.  In effect this subverts the check that the 
C	buffer is big enough for the retrieved product!!!
C
C----<
	integer icalls
	integer dumlen
	save icalls, dumlen
	data icalls/0/
	data dumlen/1000000/
C
C First time through, print a warning message
	if (icalls .eq. 0) then
	  icalls = icalls + 1
	  write(*,*) ' *********************************************'
	  write(*,*) ' *********************************************'
	  write(*,*) ' You are using an obsolete subroutine (GRIBIN)'
	  write(*,*) ' for retrieving GRIB products.'
	  write(*,*) ' There is NO check your buffer is big enough.'
	  write(*,*) ' Please change to using PBGRIB.'
	  write(*,*) ' *********************************************'
	  write(*,*) ' *********************************************'
	endif
C
C Note the use of dumlen (not kinlen) in the following call ...
	call pbgrib(kunit,karray,DUMLEN,koutlen,kret)
	if ( kret .eq. -3) then
	  write(*,*) ' Buffer not big enough for GRIB product'
	  kret = -5
	endif
C
	return
	end
