C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      COMPLEX FUNCTION CSUM (KN, UVEC, KNCX)                         
C                                                                       
C---->
C**** *CSUM* - ROUTINE WHICH IMPLEMENTS THE BLAS ROUTINE OF THE         
C              SAME NAME                                                
C                                                                       
C     PURPOSE.                                                          
C     --------                                                          
C                                                                       
C     SIMPLE REPLACEMENT FOR IBM                                        
C                                                                       
C**   INTERFACE.                                                        
C     ----------                                                        
C                                                                       
C     * CV = CSUM (KN, UVEC, KNCX) *                                    
C                                                                       
C                                                                       
C     METHOD.                                                           
C     -------                                                           
C                                                                       
C     CREATE COMPLEX SUM OF COMPLEX VECTOR                              
C                                                                       
C     EXTERNALS.                                                        
C     ----------                                                        
C                                                                       
C     NONE                                                              
C                                                                       
C     REFERENCE.                                                        
C     ----------                                                        
C                                                                       
C     NONE                                                              
C                                                                       
C     AUTHOR.                                                           
C     -------                                                           
C                                                                       
C     K. FIELDING         * ECMWF *     FEB 1992.                       
C                                                                       
C     MODIFICATIONS.                                                    
C     --------------                                                    
C                                                                       
C     NONE                                                              
C                                                                       
C     COMMON BLOCKS USED                                                
C     -------------------                                               
C                                                                       
C     NONE                                                              
C                                                                       
C----<
      INTEGER KN, KNCX                                                  
      COMPLEX UVEC (*)                                               
C                                                                       
      INTEGER IP                                                        
      COMPLEX CHOLD                                                  
C                                                                       
C     1.    MAIN LOOP OF CODE                                           
C           ----------------------------------------------              
C                                                                       
  100 CONTINUE                                                          
#ifndef CRAY
      CHOLD = (0.0D0, 0.0D0)                                            
#else
      CHOLD = (0.0, 0.0)                                            
#endif
C                                                                       
      DO 110 IP = 0, KN - 1                                             
         CHOLD = CHOLD + UVEC (1 + IP * KNCX)                           
  110 CONTINUE                                                          
C                                                                       
      CSUM = CHOLD                                                      
C                                                                       
C     END OF ROUTINE                                                    
C                                                                       
      RETURN                                                            
      END                                                               
