/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

/*
	readgrib.c
*/
#include "bufrgrib.h"
#include "fortint.h"

#include "fileRead.h"

#include "sizeRoutines.h"


fortint readgrib(FILE * file, char * buffer, fortint * grib_prod_len)
/*

    file          =  file pointer returned from PBOPEN

    buffer        = buffer big enough to hold the GRIB product

    grib_prod_len = size of the buffer on input, becomes size in BYTES of 
                    the GRIB product read.  If the end-of-file is hit, the
                    value is returned unchanged (ie. when the function return
                    code is -1).

    Function returns:

        0  if a GRIB product has been successfully read

       -1  if end-of-file is hit before a GRIB product is read

       -2  if there is an error in the file-handling 
	   (eg. if the file contains a truncated GRIB product)

       -3  if the size of buffer is not sufficient for the GRIB product

*/
{

/* Read the GRIB product */
fortint length;
fortint original_len;

    original_len = *grib_prod_len;
    length =  readprod("GRIB",buffer,&original_len,fileRead,fileSeek,
                        fileTell,file);
    *grib_prod_len = original_len;

    if ( buffer == NULL )
        return ( length == -1 ? length : -3 );
    else
        return ( length > 0 ? 0 : length );

}
