
#include <linux/major.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/fs.h>
#include <linux/stat.h>
#include <linux/errno.h>
#include <linux/fd.h>
#include <linux/wrapper.h>
#include <linux/init.h>
#include <linux/blkdev.h>
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,0)
  #include <linux/iobuf.h>
#endif
#include <linux/sched.h>
#include <linux/file.h>
#include <linux/pagemap.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
  #define rq_data_dir(req) ((req)->cmd & 0x01)
#endif
#define __NBD_FILE "enbd_bufferwr.c"

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)
  #define  init_waitqueue_head(x) *(x) = NULL
  typedef struct wait_queue *wait_queue_head_t;
#endif

#include <linux/enbd.h>
#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c)  (((a) << 16) + ((b) << 8) + (c))
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) 
  // BH_Protected disappeared somewhere around 2.4.10
  #define mark_buffer_protected(rbh) \
      { \
  	mark_buffer_dirty (rbh); \
  	mark_buffer_uptodate (rbh, 1); \
  	refile_buffer (rbh); \
       }

#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,30)
// LA a hack to allow the (writebuffer) code to compile w/ kernel 2.2
// these are not defined in 2.2.*;
// these definitions are taken from kernel source 2.4.*/include/linux/fs.h:
#define bh_kmap(bh)     ((bh)->b_data)
#define bh_kunmap(bh)   do { } while (0)// and these from include/linux/fs.h:
// PTB grrrr. They're now back in 2.2.20
/*
#define atomic_set_buffer_protected(bh) test_and_set_bit(BH_Protected, &(bh)->b_state)
#define mark_buffer_protected(bh) \
        if (!atomic_set_buffer_protected(bh)) \
                refile_buffer(bh)

*/
#endif



extern int
enbd_register_bufferwr(int (*f)(struct enbd_device *,struct request *));
extern int
enbd_unregister_bufferwr(int (*f)(struct enbd_device *,struct request *));

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) 
  /*
   * Magic function from rd.c that we hope saves a buffer head
   * permanently somewhere in the kernel VM system.
   */
  static int
  buffered_write_pagecache_IO(struct buffer_head *sbh, struct address_space *mapping) {
        unsigned long index;
        int offset, size, err;
        err = 0;


        // PTB index appears to be the page number
        index = sbh->b_rsector >> (PAGE_CACHE_SHIFT - 9);
        // PTB offset is in bytes, and says where in the page the sector starts
        offset = (sbh->b_rsector << 9) & ~PAGE_CACHE_MASK;
        // PTB well, an abbreviation for the buffer size, in bytes
        size = sbh->b_size;

        do {
            // PTB we mark each page that we should write to Uptodate
            
            int count;
            struct page ** hash;
            struct page * page;
            char * src, * dst;

            int unlock = 0;

            // PTB ummm, how much of the page is left to traverse
            count = PAGE_CACHE_SIZE - offset;
            // PTB reduce it to how much we actually need to traverse
            if (count > size)
                count = size;
            // PTB say NOW? that we have traversed what we want of the page
            size -= count;

            hash = page_hash(mapping, index);
            page = __find_get_page(mapping, index, hash);

            if (!page) {
                // PTB we get to make a new page
                page = grab_cache_page(mapping, index);
                if (!page) {
                    // PTB failed to get new page
                    err = -ENOMEM;
                    goto out;
                }
                // PTB magic
                if (!Page_Uptodate(page)) {
                    memset(kmap(page), 0, PAGE_CACHE_SIZE);
                    kunmap(page);
                    SetPageUptodate(page);
                }
                // PTB the new page is locked. We need to unlock it later
                unlock = 1;
            }

            // PTB prepare already for next page
            index++;

            // PTB set up for copy
            dst = kmap(page);
            dst+= offset;
            src = bh_kmap(sbh);

            // PTB prepare for next round
            offset = 0;

            // PTB do a copy
            memcpy(dst, src, count);

            kunmap(page);
            bh_kunmap(sbh);

            if (unlock) {
                UnlockPage(page);
            }
            SetPageDirty(page);
            __free_page(page);

        } while (size > 0);

out:
        return err;

  }
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9) 
static int
buffered_write (struct enbd_device *lo, struct request *req)
{

    struct buffer_head *bh;
    struct address_space * mapping = lo->inode->i_mapping;
    int err = 0;

    // PTB go through and copy and protect the written buffers
    for (bh = req->bh; bh; bh = bh->b_reqnext) {
	struct buffer_head *rbh;
	rbh =
	 getblk (bh->b_rdev, bh->b_rsector / (bh->b_size >> 9), bh->b_size);
	if (bh != rbh) {
	    char *bdata = bh_kmap (bh);
	    memcpy (rbh->b_data, bdata, rbh->b_size);
	}
	bh_kunmap (bh);
	mark_buffer_protected (rbh); // PTB equals dirty, uptodate
        // PTB we need to save the /dev/nda inode
        err = buffered_write_pagecache_IO(bh, mapping);
        if (err < 0) {
            break;
        }
	brelse (rbh);
    }
    return err;
}
#else
static int
buffered_write (struct enbd_device *lo, struct request * req)
{

    struct buffer_head *bh;

    // PTB go through and copy and protect the written buffers
    for (bh = req->bh; bh; bh = bh->b_reqnext) {
	struct buffer_head *rbh;
	char *bdata;
	rbh =
	 getblk (bh->b_rdev, bh->b_rsector / (bh->b_size >> 9), bh->b_size);
	bdata = bh_kmap (bh);
	if (bh != rbh) {
	    memcpy (rbh->b_data, bdata, rbh->b_size);
	}
	bh_kunmap (bh);
	mark_buffer_protected (rbh);
	brelse (rbh);

    }
    return 0;
}
#endif /* LINUX_VERSION_CODE > KERNEL_VERSION(2,4,9)  */



static int __init
enbd_bufferwr_init (void)
{
    enbd_register_bufferwr(&buffered_write);
    return 0;
}

static void __exit
enbd_bufferwr_cleanup (void) {
    enbd_unregister_bufferwr(&buffered_write);
}

module_init (enbd_bufferwr_init);
module_exit (enbd_bufferwr_cleanup);

int linux_version_code = LINUX_VERSION_CODE;

#ifdef MODULE
  #if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0)
    MODULE_AUTHOR ("Peter T. Breuer");
    MODULE_DESCRIPTION ("Enhanced Network Block Device Local Buffered Writes driver");
    #ifdef MODULE_LICENSE
      MODULE_LICENSE("GPL");
    #endif
  #endif
#endif		/* MODULE */



