
#include <linux/stddef.h>
#include <linux/errno.h>
#include <linux/enbd.h>
#include <linux/enbd_ioctl.h>

  /*
   * PTB this is the hook for the enbd_ioctl extra module
   */
  static int register_remote_ioctl(struct enbd_ioctl_stub *remote_ioctl, struct enbd_ioctl *x) {
          if (!remote_ioctl->remote) {
                remote_ioctl->remote = x;
                return 0;
          }
          return -EINVAL;
  }
  static int unregister_remote_ioctl(struct enbd_ioctl_stub *remote_ioctl, struct enbd_ioctl *x) {
        if (remote_ioctl->remote != x)
                return -EINVAL;
        remote_ioctl->remote = NULL;
        return 0;
  }

int enbd_init_ioctl_stub(struct enbd_ioctl_stub *remote_ioctl) {
        memset(remote_ioctl, 0, sizeof(*remote_ioctl));
        remote_ioctl->reg = register_remote_ioctl;
        remote_ioctl->unreg = unregister_remote_ioctl;
        return 0;
}

