/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#ifndef NBD_DB
#define NBD_DB 1

/* 
 * for small dbs. A simple list. 0 is not allowed as an index.
 */
   struct dbentry {
      void *nam;
      void *val;
   };
   struct nbd_db {
      int count;      // total entries including erased entries
      int max;        // max entries allowed
      int erased;     // number of erased entries
      int nent;       // total entries excluding erased entries

      struct dbentry *contents;

      int (*lookup)(struct nbd_db * self, void *nam, void **val);
      int (*add)(struct nbd_db * self, void *nam, void *val);
      int (*del)(struct nbd_db * self, void *nam);
      void (*norm)(struct nbd_db * self);
      int (*next)(struct nbd_db * self, int i, void **nam, void **val);
      int (*first)(struct nbd_db * self, void **nam, void **val);
      int (*size)(struct nbd_db * self);
   };

   int init_db(struct nbd_db * self, int max);
#endif
