/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

# define MAXFILE 32

struct nbd_file {
   int nfile; // = 0;                   /* number of files */
# define NBD_LINEAR_MODE 0              /* linear mode is the default! */
# define NBD_STRIPE_MODE 1
# define NBD_MIRROR_MODE 2
   int mode; // = NBD_LINEAR_MODE;      /* default linear raid */
   int blksize; //= 1024;               /* host device blocksize (default 1k) */
   u64 lastpoint; //= 0;                /* PTB last seek position */
   int changedfd; //= 0;                /* PTB is lastpoint untrustworthy */
   u64 lastpt[MAXFILE];                 /* PTB per export component */
   int   lasti; //    = -1;             /* PTB last component sought */
   u64 sizes[MAXFILE];                  /* file sizes */
   int exports[MAXFILE];                /* file descriptors */
   char *names[MAXFILE];
   u64 size;
#define F_READONLY      0x0001     /* same as NBD_READ_ONLY */
#define F_INITIALISED   0x0004     /* same as NBD_INITIALISED */
#define F_SIGNED        0x0008     /* same as NBD_SIGNED */
#define F_DEBUG         0x0010 
#define F_NEGOTIATED    0x0020     /* same as NBD_CLIENT_NEGOTIATED */
#define F_CLOSEWANTED   0x0020     /* missing closes */
#define F_SERVER_RO     0x0040     /* same as NBD_CLIENT_SERVER_RO */
#define F_OPENWANTED    0x0040     /* missing opens  */
#define F_OPEN          0x0080     /* device currently is fully open */
#define F_CLOSED        0x0100     /* device currently is fully closed */
#define F_DOLOCK        0x0200     /* we want to lock regions on resource */
#define F_INTRODUCED    0x0400     /* same as NBD_CLIENT_INTRODUCED */
#define F_ASYNC         0x0800     /* don't fsync, same as NBD_CLIENT_ASYNC */
#define F_DIRECT        0x1000     /* open O_DIRECT */

#define F_SYNC        0x400000     /* open sync & fsync after writes */
#define F_STAT        0x800000     /* have statted the resource */


   unsigned long flags;
   int (*write)(struct nbd_file *self, char * buf, unsigned len, u64 off);
   int (*read )(struct nbd_file *self, char * buf, unsigned len, u64 off);
   int (*sync )(struct nbd_file *self);
   int (*reopen)(struct nbd_file *self);
   int (*open)(struct nbd_file *self);
   int (*close)(struct nbd_file *self);
   s64 (*seek)(struct nbd_file *self, s64 off, int whence);

   int lives; // =0                /* number of reopens */
   int (*ioctl)(struct nbd_file *self, int ioctl, char *arg);
   short pid;
   int (*lock)(struct nbd_file *self, u64 from, s64 len, int type);
   int (*unlock)(struct nbd_file *self, u64 from, s64 len);
   unsigned long *caddr;
};

int init_file(struct nbd_file * self, int nfile, int mode, s64 *sizes,
        int blksize, char* names[], int ro, int sync, int async, int lock,
        int direct, unsigned long *caddr);

