/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#ifndef NBD_INTERFACE_H
#define NBD_INTERFACE_H 1

#ifndef HAVE_IF_NAMEINDEX
  // PTB - taken from net/if.h under glibc2

  /* Convert an interface name to an index, and vice versa.  */
  extern unsigned int if_nametoindex(const char *__ifname);
  extern char *if_indextoname(unsigned int __ifindex, char *__ifname);
  /* Return a list of all interfaces and their indices.  */
  struct if_nameindex {
    unsigned int if_index;      /* 1, 2, ... */
    char *if_name;              /* null terminated name: "eth0", ...  */
  };
  extern struct if_nameindex *if_nameindex(void);
  /* Free the data returned from if_nameindex.  */
  extern void if_freenameindex(struct if_nameindex *__ptr);

#endif


  struct interface {
       char name[IFNAMSIZ];        // interface name
       short type;                 // if type
       short flags;                // various flags
       int metric;                 // routing metric
       int mtu;                    // MTU value
       int tx_queue_len;           // transmit queue length
       //struct ifmap map;           // hardware setup
       struct sockaddr addr;       // IP address
       struct sockaddr dstaddr;    // P-P IP address
       struct sockaddr broadaddr;  // IP broadcast address
       struct sockaddr netmask;    // IP network mask
       int has_ip;
       char hwaddr[32];            // HW address
       int fd;                     // socket used to communicate with kernel
       struct if_nameindex * ifs;  // array of interfaces from kernel
       int i;                      // which interface in ifs list we are
                                   // load a new interface
       int (*next)(struct interface *ife);
                                   // convenience
       unsigned long (*getaddr)(struct interface *ife);
       unsigned long (*getmask)(struct interface *ife);
                                   // atomic write to static
       char *(*sprintaddr)(struct interface *ife);
       char *(*sprintmask)(struct interface *ife);
                                   // field
       char *(*getname)(struct interface *ife);
       int (*open)(struct interface *ife);
       int (*close)(struct interface *ife);
       int (*rewind)(struct interface *ife);
  };

  void init_interface(struct interface * ife);

#endif
