/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include "select.h"

// PTB this isn't at all OO .. it's just "anciliary" functionality

  int dounlock(char * lockfile) {
      int err = unlink(lockfile);
      return err;
   }

  /*
   * Do "dot locking" via the FS so that scripts can see it too.
   * This needs the dot lockfile name as argument. Return >= 0 for
   * success, < 0 for error.
   */
  int dolock(char * lockfile) {

      char * slash = strrchr(lockfile, '/');
      int slashindex = slash? slash - lockfile : -1 ;
      char * dirname = strdup(lockfile);

      const char basename[] = ".nbd-lock.XXXXXX";
      const int tries = 5;
      char * template;
      int err = 0;
      int fd = -1;
      int count;

      if (!dirname)
         return -1;
      if (slashindex < 0)
         slashindex = 0;

      dirname[slashindex] = 0;

      template = malloc(strlen(dirname) + 1 + strlen(basename) + 1);
      if (!template) {
        free(dirname);
        return -1;
      }

      sprintf(template, "%s/%s", dirname, basename);
      free(dirname);
      fd = mkstemp(template);
      if (fd < 0) {
        free(template);
        return -1;
      }

      err = -1;
      for (count = 0; count < tries; count ++) {
        err = link(template, lockfile);

        if (!err) {
          // PTB success. Write our pid in there
          char pidbuf[16];
          sprintf(pidbuf, "%hd\n", getpid());
          write(fd, pidbuf, strlen(pidbuf));
          break;
        }
        
        // PTB ostensible failure, but check that the owner is still alive
        if (1) {
          FILE *lfp = fopen(lockfile, "r");
          short pid = -1;
          if (lfp && (fscanf(lfp," %hd\n",&pid) < 1 || kill(pid,0) < 0)) {
             // PTB is this  a race?
             unlink(lockfile);
             fclose(lfp);
             continue;
          }
        }

        microsleep(1000000);
      }
      free(template);
      return err;
  }


