/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

struct timespec;
#include <sys/time.h>
#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/errno.h>
#include <syslog.h>
#include <netinet/in.h>

#define MY_NAME "select"
#include "cliserv.h"
#include "select.h"

extern int debug_level;

int
microselect (int n, fd_set * rfds, fd_set * wfds, fd_set * efds, long t)
{

    int errcount = 0;
    struct timeval timeout = { t / 1000000, t % 1000000 };

    // PTB we use the sysv semantics and hope that the timeout
    // is decremented on repeats

    while (1) {

	// PTB this is easier to see with strace !
	int res = select (n, rfds, wfds, efds, &timeout);
	int err;

	if (res > 0)
	    return res;		// PTB byte or error is expected 

	if (res == 0) {
	    DEBUG ("Select timed out: %m\n");
	    return -ETIME;
	}

	if (res >= 0)
	    continue;

	// PTB the select blew a gasket or intr
	err = errno;

	switch (err) {
            int sec, usec;

	    // PTB the sighandler will have fired, now we get the notify
	  case EINTR:
	    errcount = 0;
	    continue;
	    break;

	  case ENOMEM:
	    // PTB this is mysterious. What should I do?
            if (errcount++ > 10)
                return -err;
            sec = timeout.tv_sec; usec = timeout.tv_usec;
            timeout.tv_sec /= 2; timeout.tv_usec /= 2;
            select(0,NULL,NULL,NULL, &timeout);
            timeout.tv_sec += sec/2; timeout.tv_usec += usec/2;
	    continue;
	    break;

	  default:
	    PERR ("Select errored out: %m (%d)\n", err);
	    return -err;
	    break;
	}
    }
}

int microsleep(long n) {
    return microselect(0,NULL,NULL,NULL,n);
}


