#include "encompass.h"

static void encompass_bookmark_load (BrowserWindow * window,
				     GtkWidget * menu,
				     gchar * dent) {
  GtkWidget * menuitem;
  gchar * name;
  gchar * url;
  gchar * comment = NULL;
  
  if (!strcasecmp (g_strndup ((gchar *) strstr (dent, "Type=") +
			      strlen ("Type="),
			      strstr ((gchar *) strstr (dent, "Type="), "\n") -
			      (strstr (dent, "Type=") + strlen ("Type="))),
		   "URL")) {
    name = g_strndup ((gchar *) strstr (dent, "Name=") + strlen ("Name="),
		      strstr ((gchar *) strstr (dent, "Name="), "\n") -
		      (strstr (dent, "Name=") + strlen ("Name=")));
    if (strstr (dent, "Comment")) {
      comment = g_strndup ((gchar *) strstr (dent, "Comment=") +
			   strlen ("Comment="),
			   strstr ((gchar *) strstr (dent, "Comment="), "\n") -
			   (strstr (dent, "Comment=") + strlen ("Comment=")));
    }
    url = g_strndup ((gchar *) strstr (dent, "Exec=") + strlen ("Exec="),
		      strstr ((gchar *) strstr (dent, "Exec="), "\n") -
		      (strstr (dent, "Exec=") + strlen ("Exec=")));

    if (comment && *comment) {
      printf ("%s\n", comment);
    }
    if (name) {
      g_free (name);
    }
    if (url) {
      g_free (url);
    }
  }
}

static void encompass_subdir_parse (BrowserWindow * window, gchar * path,
				    GtkMenu * menu) {
  gchar * buffer, * dent;
  struct stat stbuf;
  struct dirent * dirent;
  gchar * filename;
  DIR * dir;
  int fd;

  if ((dir = opendir (path))) {
    while ((dirent = readdir (dir))) {
      if (strcmp (dirent->d_name, ".") && strcmp (dirent->d_name, "..")) {
	filename = g_strdup_printf ("%s/%s", path, dirent->d_name);
	if (!lstat (filename, &stbuf)) {
	  if (S_ISREG (stbuf.st_mode)) {
	    if (!strcmp ((gchar *) strrchr (filename, '.'), ".desktop")) {
	    } else if (!strcmp (filename, ".order")) {
	    }
	  } else if (S_ISDIR (stbuf.st_mode)) {
	  }
	  g_free (filename);
	  /*
	  if ((opendir (path) == NULL)
	      (fd = open (filename, O_RDONLY | O_NONBLOCK))) {
	    buffer = (gchar *) mmap (NULL, stbuf.st_size, PROT_READ,
				     MAP_SHARED, fd, 0);
	    dent = g_strdup (buffer);
	    close (fd);
	    munmap (buffer, stbuf.st_size);
	    encompass_bookmark_load (window, NULL, dent);
	    g_free (dent);
	  } else {
	    encompass_subdir_parse (window, filename);
	  }
	  */
	}
      }
    }
  }
}

void encompass_parse_bookmarks (BrowserWindow * window) {
  gchar * favsdir;

  favsdir = g_strconcat (g_get_home_dir (), "/.gnome/apps", NULL);

  encompass_subdir_parse (window, favsdir,
			  GTK_MENU (GTK_MENU_ITEM (window->book_menu)->submenu));

  g_free (favsdir);
}
