#include "encompass.h"
#include <ne_session.h>
#include <ne_redirect.h>

typedef struct _EURISession EURISession;

gboolean event_loop = FALSE;
gint counter = 0;

struct _EURISession {
  ne_session * session;
  EncompassURI * base_uri;
};

static int e_accept_mostly (void * userdata, ne_request * req,
			    const ne_status * st) {
  return ((st->klass == 1) ||
	  (st->klass == 2) ||
	  (st->klass == 4) ||
	  (st->klass == 5));
}

void encompass_http_stop (GtkWidget * widget, BrowserWindow * window) {
  GList * list;
  EURISession * session;

  /* test with penguinppc.org/~eb/penguin.html */
  for (list = window->sessions; list != NULL; list = list->next) {
    session = list->data;

    ne_close_connection (session->session);
    ne_session_destroy (session->session);
    encompass_uri_destroy (session->base_uri);

    window->sessions = g_list_remove (window->sessions, session);
    g_free (session);
  }
}

static ne_notify_status encompass_http_status (WebThreadStuff * stuff,
					       ne_conn_status status,
					       const gchar * info) {
  GnomeAppBar * blah;
  blah = GNOME_APPBAR (GNOME_APP (stuff->window->window)->statusbar);

  switch (status) {
  case ne_conn_namelookup: {
    gchar * msg = g_strdup_printf (_("Looking up %s..."), info);
    gnome_appbar_set_status (blah, msg);
    g_free (msg);
    break;
  }
  case ne_conn_connecting: {
    gchar * msg = g_strdup_printf (_("Connecting to %s..."), info);
    gnome_appbar_set_status (blah, msg);
    g_free (msg);
    break;
  }
  case ne_conn_connected: {
    gchar * msg = g_strdup_printf (_("Connected to %s..."), info);
    gnome_appbar_set_status (blah, msg);
    g_free (msg);
    break;
  }
  default: {
    gnome_appbar_set_status (blah, "");
    break;
  }
  }
}

static void * encompass_http_progress (WebThreadStuff * stuff,
				       off_t progress, off_t total) {
  GnomeAppBar * blah;
  gfloat percent = (progress / total);

  blah = GNOME_APPBAR (GNOME_APP (stuff->window->window)->statusbar);
  
  if (percent > 1.0) {
    percent = 1.0;
  }
  if (percent < 0.0) {
    percent = 0.0;
  }
}

static void encompass_http_read_block (WebThreadStuff * stuff,
				       const gchar * buf,
				       size_t len) {
  if (len) {
    gtk_html_write (GTK_HTML (stuff->window->html), stuff->handle, buf, len);
  }
  while (gtk_events_pending ())
    gtk_main_iteration ();
}

static void encompass_http_load (WebThreadStuff * stuff) {
  BrowserWindow * window = stuff->window;
  EncompassURI * uri = encompass_uri_dup (stuff->uri, ENCOMPASS_URI_DUP_ALL);
  EURISession * session = NULL;
  GList * list;
  gchar * referer;
  ne_request * request;

  if (uri->port == 0) {
    if (!g_strcasecmp (uri->protocol, "https")) {
      uri->port = 443;
    } else {
      uri->port = 80;
    }
  }

  for (list = window->sessions; list != NULL; list = list->next) {
    session = list->data;

    if (!strcmp (uri->hostname, session->base_uri->hostname) &&
	uri->port == session->base_uri->port) {
      break;
    }
  }

  if (session == NULL) {
    session = g_new0 (EURISession, 1);
    session->session = ne_session_create (uri->protocol, uri->hostname,
					  uri->port);
    session->base_uri = encompass_uri_dup (uri, ENCOMPASS_URI_DUP_ALL);

    ne_set_read_timeout (session->session, 10);

    /*
      ne_set_server_auth (session->session,
      (void *) encompass_http_auth, stuff);
    */

    ne_set_proxy_auth (session->session,
		       (void *) encompass_proxy_auth, stuff);
    ne_set_status (session->session,
		   (void *) encompass_http_status, stuff);
    ne_set_progress (session->session,
		     (void *) encompass_http_progress, stuff);

    if (!g_strcasecmp ("https", uri->protocol)) {
      ne_ssl_set_verify (session->session,
			 (void *) encompass_ssl_verify, window);
      ne_ssl_provide_ccert (session->session,
			    (void *) encompass_ssl_provide_cert, window);
      ne_ssl_load_default_ca (session->session);
    }
    if (window->prefs->use_proxy) {
      ne_session_proxy (session->session, window->prefs->proxy_host,
			window->prefs->proxy_port);
    }
    ne_set_useragent (session->session,
		      "Mozilla/4.0 (compatible; Encompass/" VERSION ")");
    ne_redirect_register (session->session);
  }

  if (stuff->isposting) {
    encompass_set_base (GTK_HTML (window->html),
			(const gchar *) encompass_uri_to_string (uri),
			window);

    request = ne_request_create (session->session, "POST", uri->path);
    ne_add_request_header(request, "Content-Type",
			  "application/x-www-form-urlencoded");
    
    ne_set_request_body_buffer (request, g_strdup (stuff->post_body),
				strlen (stuff->post_body));
    stuff->isposting = FALSE;
  } else {
    request = ne_request_create (session->session, "GET", uri->path);
  }
  ne_add_response_header_handler (request, "Set-Cookie",
				  (void *) encompass_cookie_received, stuff);

  if (window->referer != NULL) {
    referer = encompass_uri_to_string (window->referer);
    ne_add_request_header(request, "Referer", referer);
    g_free (referer);
  }

  ne_add_response_body_reader (request, e_accept_mostly,
			       (void *) encompass_http_read_block, stuff);

  encompass_find_cookies (uri, request, window);
  switch (ne_request_dispatch (request)) {
  case NE_OK:
    break;
  case NE_REDIRECT: {
    GtkHTMLStream * handle;
    EncompassURI * newuri;
    const ne_uri * foo;
    gchar * nurl;

    foo = ne_redirect_location (session->session);
    nurl = encompass_parse_url (ne_uri_unparse (foo), uri);
    newuri = encompass_uri_new (nurl);

    if (stuff->handle == window->handle) {
      encompass_set_base (GTK_HTML (window->html),
			  nurl, window);
      gtk_html_stream_close (window->handle, GTK_HTML_STREAM_ERROR);
      window->handle = gtk_html_begin (GTK_HTML (window->html));

      if (stuff->isposting) {
	encompass_http_load_url (window, newuri, window->handle,
				 stuff->isposting, stuff->post_body);
      } else {
	switch (encompass_check_mime (window, nurl)) {
	case E_CONTENT_TEXT: {
	  window->handle = gtk_html_begin (GTK_HTML (window->html));
	  encompass_set_base (GTK_HTML (window->html), nurl, window);
	  encompass_http_load_url (window, newuri, window->handle,
				   FALSE, NULL);
	  break;
	}
	case E_CONTENT_IMAGE: {
	  break;
	}
	case E_CONTENT_OTHER: {
	  CORBA_Environment ev;
	  GNOME_Elysium_Download_Shell shell;
	  
	  CORBA_exception_init (&ev);
	  shell =
	    bonobo_activation_activate_from_id ("OAFIID:GNOME_Elysium_Download_Shell",
						0, NULL, &ev);
	  if (ev._major != CORBA_NO_EXCEPTION || shell == CORBA_OBJECT_NIL) {
	  } else {
	    GNOME_Elysium_Download_Shell_save_uri_as (shell, nurl, &ev);
	  }
	  CORBA_exception_free (&ev);  
	  break;
	}
	}
      }
    } else {
      encompass_url_requested (GTK_HTML (window->html), nurl,
			       stuff->handle, window);
    }

    g_free (nurl);
    encompass_uri_destroy (newuri);

    ne_request_destroy (request);
    ne_session_destroy (session->session);
    encompass_uri_destroy (session->base_uri);
    
    window->sessions = g_list_remove (window->sessions, session);
    g_free (session);

    return;
  }
  default: {
    printf ("DEBUG: %s\n", ne_get_error (session->session));
    break;
  }
  }

  ne_request_destroy (request);
  ne_session_destroy (session->session);
  encompass_uri_destroy (session->base_uri);

  window->sessions = g_list_remove (window->sessions, session);
  g_free (session);

  if (stuff->post_body) {
    g_free (stuff->post_body);
    stuff->post_body = NULL;
  }

  gtk_html_end (GTK_HTML (window->html), stuff->handle,
		GTK_HTML_STREAM_OK);

}

void encompass_http_load_url (BrowserWindow * window, EncompassURI * uri,
			      GtkHTMLStream * handle, gboolean isposting,
			      gchar * post_body) {
  WebThreadStuff * stuff;
  gboolean start_loop;

  stuff = g_new0 (WebThreadStuff, 1);
  stuff->uri = uri;
  stuff->window = window;
  stuff->handle = handle;
  stuff->isposting = isposting;
  stuff->post_body = g_strdup (post_body);

  encompass_http_load (stuff);

  while(gtk_events_pending()) {
    gtk_main_iteration();
  }
}
