/*
 *  The MOOtcan MOO-client
 *  Copyright (C) 1999-2001 Sindre Srensen and Jan Rune Holmevik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

/**
 * a textfield to enter commands has support for history.  sends the
 * 'commands' into a pipe. for now it only sends strings, but it can probably
 * be expanded to send other types.
 *
 * This class has been changed to use the Java 1.1 event model.
 * The Java 1.1 TextArea is now used in all instances. 
 *
 * @author Sindre Srensen and Jan Rune Holmevik
 */

public class CommandTextField extends TextArea implements KeyListener {

  private int histSize;
  private HistoryList history;
  
  ControlPanel controlPanel;
  
  String issuedCommand;
  
  String mode;
  
  private TextArea commandArea;
  
  PipedOutputStream outputStream;
  PipedInputStream inputStream;
  DataOutputStream out;
  
  CommandTextField(Font font, int histSize, ControlPanel controlPanel) {

		super("", 3, 1, TextArea.SCROLLBARS_NONE);
		
		addKeyListener(this);
	
		this.setFont(font);
    	this.setEditable(true);
    	
    	this.histSize = histSize;
    	history = new HistoryList("", histSize);
    
    	outputStream = new PipedOutputStream();
    	
    	try {
      	inputStream = new PipedInputStream(outputStream);
    	} catch (IOException e) {
      		e.printStackTrace();
    	}

    	out = new DataOutputStream(outputStream);

  }

  public void requestFocus() {
      this.requestFocus();
  }

		 
	public PipedInputStream getInputStream() {
		return inputStream;
 	}


  private void sendIssuedCommand(String command) {
  
    try {
      out.writeBytes(command + "\n");
      out.flush();
      this.clean();
			
    } catch (IOException e) {
      e.printStackTrace();
    }
		
	}


  /*
   * Clean up input field. Check to see which input mode
   * has been selected and insert appropriate mode.
   */
	
  public void clean() {
  
    this.setText(controlPanel.getMode(mode));
     
    try {
	   this.setCaretPosition(this.getText().length());
    } 
    catch (NoSuchMethodError e) {
	}

    this.requestFocus();

    
  }


  public String getIssuedCommand() {
    return issuedCommand;
  }




       public void keyTyped(KeyEvent e) {
       }


	/*
	 * Command Area Event Handling. Java 1.1
	 */
	 
       public void keyPressed(KeyEvent e) {

         switch (e.getKeyCode()) {
           case KeyEvent.VK_ENTER:
     	        history.insertItem(getText());
     	        sendIssuedCommand(getText());
     	        break;
     	        
           case KeyEvent.VK_PAGE_UP:
           case KeyEvent.VK_UP:
     	        setText(history.getPreviousItem().toString());
     	        break;
     	        
           case KeyEvent.VK_PAGE_DOWN:
           case KeyEvent.VK_DOWN:
     	        setText(history.getNextItem().toString());

         }
       }


       public void keyReleased(KeyEvent e) {
         if (e.getKeyCode() == KeyEvent.VK_ENTER) 
            this.clean();
       }
 
}