/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class CommandTextField
extends TextArea
implements KeyListener {
    private int histSize;
    private HistoryList history;
    ControlPanel controlPanel;
    String issuedCommand;
    String mode;
    private TextArea commandArea;
    PipedOutputStream outputStream;
    PipedInputStream inputStream;
    DataOutputStream out;

    CommandTextField(Font font, int n, ControlPanel controlPanel) {
        super("", 3, 1, 3);
        this.addKeyListener(this);
        this.setFont(font);
        this.setEditable(true);
        this.histSize = n;
        this.history = new HistoryList("", n);
        this.outputStream = new PipedOutputStream();
        try {
            this.inputStream = new PipedInputStream(this.outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.out = new DataOutputStream(this.outputStream);
    }

    public void requestFocus() {
        this.requestFocus();
    }

    public PipedInputStream getInputStream() {
        return this.inputStream;
    }

    private void sendIssuedCommand(String string) {
        try {
            this.out.writeBytes(string + "\n");
            this.out.flush();
            this.clean();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void clean() {
        this.setText(this.controlPanel.getMode(this.mode));
        try {
            this.setCaretPosition(this.getText().length());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.requestFocus();
    }

    public String getIssuedCommand() {
        return this.issuedCommand;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.history.insertItem(this.getText());
                this.sendIssuedCommand(this.getText());
                break;
            }
            case 33: 
            case 38: {
                this.setText(this.history.getPreviousItem().toString());
                break;
            }
            case 34: 
            case 40: {
                this.setText(this.history.getNextItem().toString());
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.clean();
        }
    }
}

