/*
                         Endeavour Browser
 */

#ifndef BROWSER_H
#define BROWSER_H


#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvstatusbar.h"
#include "toolbar.h"
#include "mountbar.h"
#include "findbar.h"
#include "fopdialog.h"


/*
 *	Contents clist column type id codes:
 */
#define EDV_BROWSER_COLUMN_TYPE_NAME		0
#define EDV_BROWSER_COLUMN_TYPE_SIZE		1
#define EDV_BROWSER_COLUMN_TYPE_TYPE		2
#define EDV_BROWSER_COLUMN_TYPE_PERMISSIONS	3
#define EDV_BROWSER_COLUMN_TYPE_OWNER		4
#define EDV_BROWSER_COLUMN_TYPE_GROUP		5
#define EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS	6
#define EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED	7
#define EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED	8
#define EDV_BROWSER_COLUMN_TYPE_HARD_LINKS	9
#define EDV_BROWSER_COLUMN_TYPE_LINKED_TO	10
#define EDV_BROWSER_COLUMN_TYPE_DEVICE		11
#define EDV_BROWSER_COLUMN_TYPE_INODE		12
#define EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE	13
#define EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE	14
#define EDV_BROWSER_COLUMN_TYPE_BLOCKS		15

/* Total number of column types. */
#define EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX	16


/*
 *	Cell style id codes, each corresponds to an index of the
 *	cell_style array on the edv_browser_struct.
 */
#define EDV_BROWSER_CELL_STYLE_NO_ACCESS	0
#define EDV_BROWSER_CELL_STYLE_DANGLING_LINK	1
#define EDV_BROWSER_CELL_STYLE_HIDDEN		2
#define EDV_BROWSER_CELL_STYLE_EXECUTABLE	3

/* Total number of cell styles. */
#define EDV_BROWSER_TOTAL_CELL_STYLES		4


/*
 *	Browser operation codes:
 */
#define EDV_BROWSER_OP_NONE		0
#define EDV_BROWSER_OP_SEPARATOR	10

#define EDV_BROWSER_OP_CLOSE		20
#define EDV_BROWSER_OP_EXIT		21

#define EDV_BROWSER_OP_SYNC_DISKS       30
#define EDV_BROWSER_OP_RUN		31
#define EDV_BROWSER_OP_RUN_TERMINAL	32
#define EDV_BROWSER_OP_WRITE_PROTECT    35

#define EDV_BROWSER_OP_NEW		40
#define EDV_BROWSER_OP_NEW_FILE		41
#define EDV_BROWSER_OP_NEW_DIRECTORY	42
#define EDV_BROWSER_OP_NEW_LINK         43
#define EDV_BROWSER_OP_NEW_FIFO		44
#define EDV_BROWSER_OP_NEW_DEVICE_BLOCK	45
#define EDV_BROWSER_OP_NEW_DEVICE_CHARACTER	46
#define EDV_BROWSER_OP_NEW_SOCKET	47

#define EDV_BROWSER_OP_OPEN		50
#define EDV_BROWSER_OP_OPEN_WITH	51

#define EDV_BROWSER_OP_GOTO_PARENT	60
#define EDV_BROWSER_OP_EXPAND		61
#define EDV_BROWSER_OP_MOUNT		62	/* Mount/unmount. */
#define EDV_BROWSER_OP_EJECT		63

#define EDV_BROWSER_OP_MOVE		65
#define EDV_BROWSER_OP_COPY		66
#define EDV_BROWSER_OP_LINK		67
#define EDV_BROWSER_OP_RENAME		68
#define EDV_BROWSER_OP_CHMOD		69
#define EDV_BROWSER_OP_CHOWN		70
#define EDV_BROWSER_OP_DELETE		71
#define EDV_BROWSER_OP_SELECT_ALL	72
#define EDV_BROWSER_OP_UNSELECT_ALL	73
#define EDV_BROWSER_OP_INVERT_SELECTION	74
#define EDV_BROWSER_OP_PROPERTIES	75

#define EDV_BROWSER_OP_FIND		76

#define EDV_BROWSER_OP_HISTORY		77
#define EDV_BROWSER_OP_COPY_PATH	78
#define EDV_BROWSER_OP_COPY_URL		79

#define EDV_BROWSER_OP_REFRESH		80
#define EDV_BROWSER_OP_REFRESH_ALL	81

#define EDV_BROWSER_OP_DOWNLOAD		85

#define EDV_BROWSER_OP_SHOW_TOOL_BAR		90
#define EDV_BROWSER_OP_SHOW_LOCATION_BAR	91
#define EDV_BROWSER_OP_SHOW_MOUNT_BAR		92
#define EDV_BROWSER_OP_SHOW_FIND_BAR		93
#define EDV_BROWSER_OP_SHOW_STATUS_BAR		94
#define EDV_BROWSER_OP_MIME_TYPES	100
#define EDV_BROWSER_OP_DEVICES		101

#define EDV_BROWSER_OP_NEW_BROWSER	110
#define EDV_BROWSER_OP_NEW_IMBR		111
#define EDV_BROWSER_OP_NEW_ARCHIVER	112
#define EDV_BROWSER_OP_RECYCLE_BIN	113

#define EDV_BROWSER_OP_OPTIONS		150
#define EDV_BROWSER_OP_CUSTOMIZE	151

#define EDV_BROWSER_OP_DEVICE_CHECK	180
#define EDV_BROWSER_OP_DEVICE_TOOLS	181
#define EDV_BROWSER_OP_DEVICE_FORMAT	182

#define EDV_BROWSER_OP_HELP_ABOUT		1000
#define EDV_BROWSER_OP_HELP_CONTENTS		1001
#define EDV_BROWSER_OP_HELP_FILE_BROWSER	1002
#define EDV_BROWSER_OP_HELP_IMAGE_BROWSER	1003
#define EDV_BROWSER_OP_HELP_ARCHIVER		1004
#define EDV_BROWSER_OP_HELP_RECYCLE_BIN		1005
#define EDV_BROWSER_OP_HELP_KEYS_LIST		1006
#define EDV_BROWSER_OP_HELP_MIME_TYPES		1007
#define EDV_BROWSER_OP_HELP_DEVICES		1008
#define EDV_BROWSER_OP_HELP_COMMON_OPERATIONS	1009


/*
 *	Browser operation id structure:
 */
typedef struct {

	gpointer browser;	/* Pointer back to browser. */

	gint op;		/* One of EDV_BROWSER_OP_*. */

	gbool allow_multiple;	/* Allow multiple instances of this
				 * operation in a list if TRUE.
				 */

	gint toolbar_item_type;	/* Type of item when placed on the
				 * tool bar, one of TOOLBAR_ITEM_*.
				 */

	/* Operation function callback, sole argument is the pointer
	 * to this structure.
	 */
	void (*func_cb)(gpointer);

	/* Enter and leave notify callback, sole argument is the pointer
	 * to this structure.
	 */
	void (*enter_func_cb)(gpointer);
	void (*leave_func_cb)(gpointer);

	gchar *button_name;	/* Name as it would appear on a button. */
	gchar *menu_name;	/* Name as it would appear on a menu item. */
	gchar *tooltip;		/* Tool tip or description (one line). */

	gint accel_key;		/* GTK accelerator key. */
	guint accel_mods;	/* GTK key modifiers for accelerator key. */

	guint8	**button_icon_data,	/* Shared. */
		**menu_icon_data;	/* Shared. */

} edv_browser_opid_struct;


/*
 *	Browser structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool processing;
	gbool ignore_input;
	gint busy_count;
	gpointer core_ptr;

	edv_browser_opid_struct **opid;
	gint total_opids;

	GtkAccelGroup *accelgrp;

	gbool	tool_bar_map_state,
		location_bar_map_state,
                mount_bar_map_state,
		find_bar_map_state,
		status_bar_map_state;

	GtkWidget	*toplevel,
			*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox. */

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
                        *mount_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,	/* GtkHBox parent for location bar. */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,

			*main_paned,		/* GtkHPaned */
			*directory_ctree,	/* Directory GtkCTree. */
			*contents_clist;	/* Contents GtkCList. */

	/* General tool bar. */
	toolbar_struct *toolbar;

	/* Mount bar. */
	edv_mountbar_struct *mountbar;

	/* Find bar. */
	edv_findbar_struct *findbar;

	/* Important menu items. */
	GtkWidget	*open_mi,
			*openwith_mi,
			*new_object_submi,
			*new_object_submenu,
			*new_file_mi,
			*new_directory_mi,
                        *new_link_mi,
			*new_fifo_mi,
			*new_device_block_mi,
			*new_device_character_mi,
			*new_socket_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*move_mi,
			*copy_mi,
			*link_mi,
                        *rename_mi,
                        *chmod_mi,
                        *chown_mi,
                        *delete_mi,
			*select_all_mi,
			*unselect_all_mi,
                        *invert_selection_mi,
			*find_mi,
			*properties_mi,

			*mount_mi,
			*eject_mi,
                        *device_check_mi,
                        *device_tools_mi,
                        *device_format_mi,
			*devices_mi,

			*refresh_mi,
			*refresh_all_mi,
                        *show_tool_bar_micheck,
                        *show_location_bar_micheck,
			*show_mount_bar_micheck,
                        *show_find_bar_micheck,
                        *show_status_bar_micheck,
			*mime_types_mi,

                        *write_protect_mi,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
                        *window_new_imbr_mi,
                        *window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_contents_mi,
			*help_file_browser_mi,
			*help_keys_list_mi,
			*help_mime_types_mi,
			*help_devices_mi,
			*help_common_operations_mi,
			*help_about_mi;


	/* Directory ctree right-click menu. */
	GtkWidget	*directory_ctree_menu,
                        *directory_ctree_expand_mi,	/* Expand or colapse. */
			*directory_ctree_mount_mi,
			*directory_ctree_eject_mi,
			*directory_ctree_mount_misep,
			*directory_ctree_move_mi,
                        *directory_ctree_copy_mi,
                        *directory_ctree_link_mi,
                        *directory_ctree_rename_mi,
                        *directory_ctree_chmod_mi,
                        *directory_ctree_chown_mi,
                        *directory_ctree_delete_mi,
                        *directory_ctree_properties_mi;

        /* Contents ctree right-click menu. */
        GtkWidget       *contents_clist_menu,
                        *contents_clist_open_mi,
			*contents_clist_openwith_mi,
                        *contents_clist_move_mi,
                        *contents_clist_copy_mi,
                        *contents_clist_link_mi,
                        *contents_clist_rename_mi,
                        *contents_clist_chmod_mi,
                        *contents_clist_chown_mi,
                        *contents_clist_delete_mi,
                        *contents_clist_properties_mi;



	/* Styles for directory_ctree and contents_clist cells. */
	GtkStyle *cell_style[EDV_BROWSER_TOTAL_CELL_STYLES];

	/* Last selected node on the ctree, can be NULL.
	 * Note that even if this value is not NULL it should still
	 * be verified that it is a valid node that actuall exists on
	 * the ctree.
	 */
	GtkCTreeNode *directory_ctree_selected_node;

	/* Selected device, reflects the device of the disk object of
	 * the node specified by directory_ctree_selected_node. This
	 * device number corresponds with a device on the core's list of
	 * devices.
	 */
	gint selected_dev_num;

	/* Last selected row on the clist, can be -1. Note that
	 * this does not reflect other selected rows since multiple
	 * selections are allowed.
	 */
	gint contents_clist_selected_row;


        /* Last known items in recycle bin, this is used as a quick access
         * value to check if the recycle bin has contents or not. Can be
	 * -1 to indicate undefined.
         */
        gint last_recbin_items;

	/* Last known write protect state, can be -1 to indicate
	 * undefined.
	 */
	gint last_write_protect_state;



	/* Status bar. */
	edv_status_bar_struct *status_bar;


	/* File operation dialog. */
	edv_fopdialog_struct *fopdialog;

} edv_browser_struct;



extern void EDVBrowserSetTitle(
        edv_browser_struct *browser,
        const gchar *path
);

extern gchar *EDVBrowserCurrentLocation(edv_browser_struct *browser);
extern void EDVBrowserSetLocation(
        edv_browser_struct *browser,
        const gchar *path, gbool record_history
);
extern void EDVBrowserUpdateLocationIcon(
        edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserToolbarRegenerate(edv_browser_struct *browser);
extern void EDVBrowserDirectoryMenuRegenerate(edv_browser_struct *browser);
extern void EDVBrowserContentsMenuRegenerate(edv_browser_struct *browser);

extern void EDVBrowserSyncConfiguration(edv_browser_struct *browser);

extern edv_browser_opid_struct **EDVBrowserOPIDListNew(
        edv_browser_struct *browser,    /* Can be NULL. */
        gint *total
);
extern void EDVBrowserOPIDListDelete(
        edv_browser_opid_struct **list, gint total
);

extern edv_browser_struct *EDVBrowserNew(gpointer core_ptr);
extern void EDVBrowserReset(edv_browser_struct *browser, gbool need_unmap);
extern void EDVBrowserSyncData(edv_browser_struct *browser);
extern void EDVBrowserUpdateMenus(edv_browser_struct *browser);
extern void EDVBrowserSetBusy(edv_browser_struct *browser, gbool is_busy);
extern void EDVBrowserMap(edv_browser_struct *browser);
extern void EDVBrowserUnmap(edv_browser_struct *browser);
extern void EDVBrowserDelete(edv_browser_struct *browser);


#endif	/* BROWSER_H */
