#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <glib.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "edvtypes.h"
#include "edvarch.h"
#include "edvutils.h"


edv_archive_object_struct *EDVArchObjectNew(void);
edv_archive_object_struct *EDVArchObjectCopy(
        edv_archive_object_struct *obj
);
void EDVArchObjectSetPath(
        edv_archive_object_struct *obj, const gchar *path
);
void EDVArchObjectSetPath2(
        edv_archive_object_struct *obj,
        const gchar *parent, const gchar *name
);
void EDVArchObjectDelete(edv_archive_object_struct *obj);



/*
 *	Allocates a new archive object.
 */
edv_archive_object_struct *EDVArchObjectNew(void)
{
	edv_archive_object_struct *obj = (edv_archive_object_struct *)g_malloc0(
	    sizeof(edv_archive_object_struct)
	);
	if(obj == NULL)
	    return(obj);

	obj->type = EDV_OBJECT_TYPE_FILE;
	obj->name = NULL;
	obj->full_path = NULL;
	obj->linked_to = NULL;
	obj->permissions = 0;
	obj->access_time = 0;
	obj->modify_time = 0;
	obj->change_time = 0;
	obj->owner_name = NULL;
	obj->group_name = NULL;
	obj->size = 0;
        obj->device_type = 0;

	return(obj);
}


/*
 *	Creates a copy of the given archive object structure.
 */
edv_archive_object_struct *EDVArchObjectCopy(
	edv_archive_object_struct *obj
)
{
	edv_archive_object_struct *obj2;


	if(obj == NULL)
	    return(NULL);

	/* Create a new archive object structure. */
	obj2 = EDVArchObjectNew();
	if(obj2 == NULL)
	    return(NULL);

	/* Begin copying values from given disk object structure to the
	 * newly created disk object structure.
	 */
	obj2->type = obj->type;

	if(obj->name != NULL)
	    obj2->name = g_strdup(obj->name);
	if(obj->full_path != NULL)
	    obj2->full_path = g_strdup(obj->full_path);
	if(obj->linked_to != NULL)
	    obj2->linked_to = g_strdup(obj->linked_to);

	obj2->permissions = obj->permissions;
	obj2->access_time = obj->access_time;
	obj2->change_time = obj->change_time;

        if(obj->owner_name != NULL)
            obj2->owner_name = g_strdup(obj->owner_name);
        if(obj->group_name != NULL)
            obj2->group_name = g_strdup(obj->group_name);

	obj2->size = obj->size;
        obj2->device_type = obj->device_type;

	return(obj2);
}

/*
 *	Deallocates the given archive object and all its resources.
 */
void EDVArchObjectDelete(edv_archive_object_struct *obj)
{
	if(obj == NULL)
	    return;

	g_free(obj->name);
	g_free(obj->full_path);

	g_free(obj->linked_to);

        g_free(obj->owner_name);
        g_free(obj->group_name);

	g_free(obj);
}
