/*
                  Endeavour Archive Object Data Structure
 */

#ifndef EDVARCH_H
#define EDVARCH_H

#include <sys/stat.h>
#include <glib.h>
#include "edvtypes.h"
#include "edvobj.h"


/*
 *	Endeavour archive object structure:
 */
typedef struct {

	gint type;		/* One of EDV_OBJECT_TYPE_*. */

	gchar *name;
	gchar *full_path;	/* But not nessisarly an absolute path since
				 * paths stored in the archive are rarly
				 * absolute paths.
				 */

	gchar *linked_to;	/* Link destination, only for type
				 * EDV_OBJECT_TYPE_LINK
				 */

	guint permissions;	/* Any of EDV_PERMISSION_*. */

	gulong	access_time,	/* In systime seconds. */
		modify_time,
		change_time;

	gchar *owner_name;
	gchar *group_name;

	gulong size;		/* In bytes. */

	gint device_type;	/* Device major and minor numbers
				 * (used only if object type is one of
				 * EDV_OBJECT_TYPE_DEVICE_*.
				 * Use EDVGetDeviceNumbers() to parse this
				 * value casted as a dev_t.
				 */

} edv_archive_object_struct;



extern edv_archive_object_struct *EDVArchObjectNew(void);
extern edv_archive_object_struct *EDVArchObjectCopy(
	edv_archive_object_struct *obj
);
extern void EDVArchObjectDelete(edv_archive_object_struct *obj);


#endif	/* EDVARCH_H */
