#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "guiutils.h"
#include "stacklist.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "browser.h"
#include "browsercb.h"
#include "recbin.h"
#include "recbincb.h"
#include "optwin.h"
#include "edvcustomize.h"
#include "endeavour.h"
#include "edvcfglist.h"
#include "edvutils.h"
#include "config.h"

#include "images/icon_customize_48x48.xpm"
#include "images/endeavour_20x20.xpm"
#include "images/image_browser_20x20.xpm"
#include "images/archiver_20x20.xpm"
#include "images/icon_trash_20x20.xpm"


static void EDVCreateCustomizeRecBinContentsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateCustomizeRecBinToolBarPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateCustomizeRecBinAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);

static void EDVCreateCustomizeArchiverContentsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateCustomizeArchiverToolBarPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateCustomizeArchiverAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);

static void EDVCustomizeImbrThumbValueChangedCB(
        GtkAdjustment *adj, gpointer data
);
static gint EDVCustomizeImbrThumbSampleExposeCB(
        GtkWidget *widget, GdkEventExpose *expose, gpointer data
);
static void EDVCustomizeImbrThumbSampleDestroyCB(
        GtkObject *object, gpointer data
);
static void EDVCreateCustomizeImbrThumbsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateCustomizeImbrToolBarPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateCustomizeImbrAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);

static void EDVCreateCustomizeBrowserContentsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateCustomizeBrowserToolBarPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
	GtkWidget *parent
);
static void EDVCreateCustomizeBrowserAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);

static void EDVCreateCustomizeGeneralPage(
	edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);

void EDVCustomizeWindowSelectTab(
	edv_optwin_struct *optwin, const gchar *tab_name
);
edv_optwin_struct *EDVCreateCustomizeWindow(
        gpointer core_ptr
);



/*
 *	Create recycle bin contents list page on customize window.
 */
static void EDVCreateCustomizeRecBinContentsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2;
        edv_cfg_wref_struct *wref;
        stack_list_struct *slist;


        /* Display options frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Cell Display Options"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Las Opciones Despliegue Clula"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Les Options d'Exposition Cellule"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Hide dir size check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Directory Size"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Tamao Gua"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Taille d'Annuaire"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE
        );

        /* Hide link size check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Link Size"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Tamao Eslabn"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Taille Lien"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_SIZE
        );

        /* Hide link permission check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Link Permissions"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Permisos Eslabn"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Permissions Lien"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS
        );


        /* Arrangement frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Arrangement"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Arreglo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Arrangement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Create contents list stack list. */
        slist = StackListNew(
            parent2,
#ifdef PROG_LANGUAGE_ENGLISH
            "Available", "Current",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Disponible", "La Corriente",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Disponible", "Courant",
#endif
	    NULL, NULL
        );
        StackListMap(slist);
        wref = OptWinWRefAppend(
            optwin, NULL, NULL,
            EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN
        );
        wref->slist = slist;    /* This wref reffers to a stack list. */

        /* Create tool bar items from recycle bin operation ids. */
        StackListAppend(
            slist, "Name", "File name of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_NAME,
            FALSE, TRUE         /* No multiple, stay on target. */
        );
        StackListAppend(
            slist, "Size", "Size of the object on disk",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_SIZE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Type", "Object's MIME Type",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_TYPE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Permissions", "Object's permissions",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_PERMISSIONS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Owner", "Owner of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_OWNER,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Group", "Grouped ownership of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_GROUP,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Access", "Date the object was last accessed",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Modified", "Date the object was last modified",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Changed", "Date the object was last changed",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Deleted", "Date the object was deleted",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_DATE_DELETED,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Linked To", "Linked to destination path",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_LINKED_TO,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Original Path", "Path of object before deletion",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_ORIGINAL_PATH,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Index", "Recycled object index number",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_RECBIN_COLUMN_TYPE_INDEX,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );

        StackListUpdateMenus(slist);

}

/*
 *      Create recycle bin tool bar page on customize window.
 */
static void EDVCreateCustomizeRecBinToolBarPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint i;
        gint border_minor = 2, border_major = 5;
	gchar *strptr;
        GSList *gslist;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;
        stack_list_struct *slist;
        edv_recbin_opid_struct **opid, *opid_ptr;
        gint total_opids;
	gchar slist_item_name[256];


	/* Hbox for toolbar display and relief frames. */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


        /* Tool bar display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display Buttons As"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue Abrocha Como"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "L'exposition Boutonne Comme"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Text radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_TEXT;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures & text radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures & Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos Y El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images Et Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


        /* Tool bar relief frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Buttons Relief"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Alivio De Botones"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Soulagement De Boutons"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Flush radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Flush"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Rubor"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Eclat"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NONE;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Half radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Half"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Mitad"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Moiti"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_HALF;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Raised radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Raised"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Levantado"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Hauss"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NORMAL;


        /* Arrangement frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Arrangement"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Arreglo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Arrangement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Create tool bar stack list. */
        slist = StackListNew(
            parent2,
#ifdef PROG_LANGUAGE_ENGLISH
            "Available", "Current",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Disponible", "La Corriente",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Disponible", "Courant",
#endif
	    NULL, NULL
        );
        StackListMap(slist);
        wref = OptWinWRefAppend(
            optwin, NULL, NULL,
            EDV_CFG_PARM_RECBIN_TOOL_BAR
        );
        wref->slist = slist;    /* This wref reffers to a stack list. */

        /* Create tool bar items from recycle bin operation ids. */
        opid = EDVRecBinOPIDListNew(NULL, &total_opids);
        for(i = 0; i < total_opids; i++)
        {
            opid_ptr = opid[i];
            if(opid_ptr == NULL)
                continue;

	    /* Copy menu name from opid to the slist item name buffer
	     * and sanitize it.
	     */
	    strncpy(
		slist_item_name,
		(opid_ptr->menu_name != NULL) ?
		    opid_ptr->menu_name : "(null)",
		256
	    );
	    slist_item_name[256 - 1] = '\0';

	    strptr = strstr(slist_item_name, "...");
	    if(strptr != NULL)
		*strptr = '\0';

	    /* Add slist item from this opid. */
            StackListAppend(
                slist, slist_item_name, opid_ptr->tooltip,
                opid_ptr->button_icon_data,
                NULL,           /* No client data. */
                opid_ptr->op,   /* Operation id. */
                opid_ptr->allow_multiple,
                FALSE           /* Not fixed on target. */
            );
        }
        /* Deallocate local copy of recycle bin operation ids. */
        EDVRecBinOPIDListDelete(opid, total_opids);
        StackListUpdateMenus(slist);

}

/*
 *      Create recycle bin appearance page on customize window.
 */
static void EDVCreateCustomizeRecBinAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;


        /* Hbox to separate two columns. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent = w;


        /* First column vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

        /* Show in title bar frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Show In Title Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Muestre En La Barra Del Ttulo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Montrer Dans La Barre De Titre"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;


        /* Show user name in title. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "User Name"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Nombre Del Usuario"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Nom D'Utilisateur"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_TITLE_WITH_USER
        );


        /* Display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Exposition"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Show tool bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre d'Outil"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR
        );

        /* Show find bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Find Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Encuentre La Barra"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Trouver La Barre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR
        );

        /* Show status bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Status Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Posicin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre De Statut"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR
        );

        /* Show desktop icon check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Desktop Icon"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Escritorio Icon Primero"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Le Bureau Premire Icne"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON
        );

}


/*
 *      Create recycle bin contents list page on customize window.
 */
static void EDVCreateCustomizeArchiverContentsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2;
        edv_cfg_wref_struct *wref;
        stack_list_struct *slist;


        /* Display options frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Cell Display Options"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Las Opciones Despliegue Clula"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Les Options d'Exposition Cellule"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Hide dir size check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Directory Size"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Tamao Gua"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Taille d'Annuaire"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE
        );

        /* Hide link size check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Link Size"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Tamao Eslabn"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Taille Lien"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_SIZE
        );

        /* Hide link permission check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Link Permissions"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Permisos Eslabn"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Permissions Lien"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS
        );


        /* Arrangement frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Arrangement"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Arreglo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Arrangement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Create contents list stack list. */
        slist = StackListNew(
            parent2,
#ifdef PROG_LANGUAGE_ENGLISH
            "Available", "Current",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Disponible", "La Corriente",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Disponible", "Courant",
#endif
	    NULL, NULL
        );
        StackListMap(slist);
        wref = OptWinWRefAppend(
            optwin, NULL, NULL,
            EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN
        );
        wref->slist = slist;    /* This wref reffers to a stack list. */

        /* Create tool bar items from recycle bin operation ids. */
        StackListAppend(
            slist, "Name", "File name of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_NAME,
            FALSE, TRUE         /* No multiple, stay on target. */
        );
        StackListAppend(
            slist, "Size", "Size of the object on disk",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_SIZE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Type", "Object's MIME Type",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_TYPE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Permissions", "Object's permissions",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Owner", "Owner of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_OWNER,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Group", "Grouped ownership of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_GROUP,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Access", "Date the object was last accessed",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Modified", "Date the object was last modified",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Changed", "Date the object was last changed",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Location", "Location of object relative to archive",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_LOCATION,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Linked To", "Linked to destination path",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Device Type", "Device's major and minor number pair",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );

        StackListUpdateMenus(slist);

}

/*
 *      Create archiver tool bar page on customize window.
 */
static void EDVCreateCustomizeArchiverToolBarPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint i;
        gint border_minor = 2, border_major = 5;
	gchar *strptr;
        GSList *gslist;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;
        stack_list_struct *slist;
        edv_archiver_opid_struct **opid, *opid_ptr;
        gint total_opids;
	gchar slist_item_name[256];


        /* Hbox for toolbar display and relief frames. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


        /* Tool bar display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display Buttons As"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue Abrocha Como"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "L'exposition Boutonne Comme"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Text radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_TEXT;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures & text radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures & Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos Y El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images Et Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


        /* Tool bar relief frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Buttons Relief"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Alivio De Botones"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Soulagement De Boutons"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Flush radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Flush"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Rubor"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Eclat"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NONE;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Half radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Half"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Mitad"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Moiti"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_HALF;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Raised radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Raised"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Levantado"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Hauss"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NORMAL;


        /* Arrangement frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Arrangement"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Arreglo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Arrangement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Create tool bar stack list. */
        slist = StackListNew(
            parent2,
#ifdef PROG_LANGUAGE_ENGLISH
            "Available", "Current",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Disponible", "La Corriente",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Disponible", "Courant",
#endif
	    NULL, NULL
        );
        StackListMap(slist);
        wref = OptWinWRefAppend(
            optwin, NULL, NULL,
            EDV_CFG_PARM_ARCHIVER_TOOL_BAR
        );
        wref->slist = slist;    /* This wref reffers to a stack list. */

        /* Create tool bar items from archiver operation ids. */
        opid = EDVArchiverOPIDListNew(NULL, &total_opids);
        for(i = 0; i < total_opids; i++)
        {
            opid_ptr = opid[i];
            if(opid_ptr == NULL)
                continue;

            /* Copy menu name from opid to the slist item name buffer
             * and sanitize it.
             */
            strncpy(
                slist_item_name,
                (opid_ptr->menu_name != NULL) ?
                    opid_ptr->menu_name : "(null)",
                256
            );
            slist_item_name[256 - 1] = '\0';

            strptr = strstr(slist_item_name, "...");
            if(strptr != NULL)
                *strptr = '\0';

            /* Add slist item from this opid. */
            StackListAppend(
                slist, slist_item_name, opid_ptr->tooltip,
                opid_ptr->button_icon_data,
                NULL,           /* No client data. */
                opid_ptr->op,   /* Operation id. */
                opid_ptr->allow_multiple,
                FALSE           /* Not fixed on target. */
            );
        }
        /* Deallocate local copy of recycle bin operation ids. */
        EDVArchiverOPIDListDelete(opid, total_opids);
        StackListUpdateMenus(slist);

}

/*
 *      Create archiver appearance page on customize window.
 */
static void EDVCreateCustomizeArchiverAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;


        /* Hbox to separate two columns. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent = w;


        /* First column vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

        /* Show in title bar frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Show In Title Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Muestre En La Barra Del Ttulo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Montrer Dans La Barre De Titre"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;


        /* Show user name in title. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "User Name"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Nombre Del Usuario"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Nom D'Utilisateur"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TITLE_WITH_USER
        );

        /* Show location in title. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Emplacement"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_TITLE_WITH_LOCATION
        );


        /* Display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Exposition"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Show tool bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre d'Outil"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR
        );

        /* Show location bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Location Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre d'Emplacement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR
        );

        /* Show find bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Find Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Encuentre La Barra"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Trouver La Barre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR
        );

        /* Show status bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Status Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Posicin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre De Statut"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR
        );

}




static void EDVCustomizeImbrThumbValueChangedCB(
        GtkAdjustment *adj, gpointer data
)
{
	gpointer *cb_data = (gpointer *)data;
	if(cb_data == NULL)
	    return;

	EDVCustomizeImbrThumbSampleExposeCB(
	    (GtkWidget *)cb_data[1], NULL, cb_data
	);
}

static gint EDVCustomizeImbrThumbSampleExposeCB(
	GtkWidget *widget, GdkEventExpose *expose, gpointer data
)
{
	gint status = FALSE;
        gint state, width, height;
        GdkWindow *window;
	GtkAdjustment *width_adj, *height_adj, *border_adj;
        GtkStyle *style;
	gpointer *cb_data = (gpointer *)data;
        if((widget == NULL) || (cb_data == NULL))
            return(status);

        state = GTK_WIDGET_STATE(widget);
        style = gtk_widget_get_style(widget);
        window = widget->window;
        if((style == NULL) || (window == NULL))
            return(status);

	width_adj = (GtkAdjustment *)cb_data[2];
        height_adj = (GtkAdjustment *)cb_data[3];
        border_adj = (GtkAdjustment *)cb_data[4];

	width = widget->allocation.width;
	height = widget->allocation.height;

	/* Clear window and redraw sample thumb. */
	gdk_draw_rectangle(
	    (GdkDrawable *)window,
	    style->base_gc[state],
	    TRUE,
	    0, 0, width, height
	);

	if((width_adj != NULL) && (height_adj != NULL))
	{
	    gint	thumb_width = (gint)width_adj->value,
			thumb_height = (gint)height_adj->value;
	    gint	x = (width / 2) - (thumb_width / 2),
			y = (height / 2) - (thumb_height / 2);

	    gtk_draw_box(
		style, window, state, GTK_SHADOW_OUT,
		x, y,
		thumb_width, thumb_height
	    );

	    if(border_adj != NULL)
	    {
		gint border = (gint)border_adj->value;

		if(border >= 2)
		  gtk_draw_box(
		    style, window, state, GTK_SHADOW_IN,
		    x + border, y + border,
		    thumb_width - (2 * border), thumb_height - (2 * border)
		  );
	    }
	}

	return(status);
}

static void EDVCustomizeImbrThumbSampleDestroyCB(
	GtkObject *object, gpointer data
)
{
	g_free(data);
}

/*
 *	Create image browser thumbs list page on customize window.
 */
static void EDVCreateCustomizeImbrThumbsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
	gpointer *cb_data;
	GSList *gslist;
	GtkAdjustment *adj, *width_adj, *height_adj, *border_adj;
        GtkWidget *w, *parent2, *parent3, *parent4;
        edv_cfg_wref_struct *wref;



	/* Hbox to separate two columns of frames. */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
        parent = w;


	/* Vbox for left side column. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


        /* Thumb list tiling orientation frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Tiling Orientation"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Orientacin De Tiling"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Orientation Qui Carrel"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
        parent3 = w;

	/* Horizontal orientation radio. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Horizontal"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Horizontal"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Horizontal"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL
        );
        wref->radio_value = TRUE;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Vertical orientation radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Vertical"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Vertical"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Vertical"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL
        );
        wref->radio_value = FALSE;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));


        /* Misc thumb displaying options. */
        w = gtk_frame_new(
            "Misc"
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_widget_show(w);
        parent3 = w;

        /* Do not enlarge thumbs. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Do Not Enlarge"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "No Amplie"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Ne Pas Agrandir"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
	    w,
#ifdef PROG_LANGUAGE_ENGLISH
            "Do not enlarge the thumb if the actual image is smaller"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "No amplie el pulgar si la imagen verdadera es ms pequea"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Ne pas agrandir le pouce si l'image vritable est plus petite"
#endif
	);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE
        );


        /* Thumb geometry frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Thumb Geometry"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Geometra Del Pulgar"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Gomtrie De Pouce"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;


        /* Hbox for prompts. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;


	/* Hbox for size prompts. */
	w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

	w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Size:"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Tamao:"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Taille:"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

	/* Width spin. */
	width_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
	    20.0, 20.0, 320.0, 5.0, 20.0, 20.0
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_THUMB_WIDTH
        );

        w = gtk_label_new("X");
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        /* Height spin. */
	height_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
            20.0, 20.0, 320.0, 5.0, 20.0, 20.0
        );
        w = gtk_spin_button_new(adj, 1.0, 0);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_set_usize(w, 60, -1);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_THUMB_HEIGHT
        );


        /* Hbox for border prompt. */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent4 = w;

        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Border:"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Frontera:"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Frontire:"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        /* Border spin. */
        border_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
            2.0, 0.0, 48.0, 1.0, 5.0, 5.0
        );
        w = gtk_spin_button_new(adj, 1.0, 0);
        gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
        gtk_widget_set_usize(w, 50, -1);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_THUMB_BORDER
        );


        /* Hbox for sample thumb. */
        w = gtk_hbox_new(TRUE, border_major);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_frame_new(NULL);
        gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_IN);
        gtk_widget_show(w);
        parent3 = w;

	/* Create sample thumb drawing area. */
	w = gtk_drawing_area_new();
        cb_data = g_malloc0(5 * sizeof(gpointer));
        cb_data[0] = core_ptr;
        cb_data[1] = w;
        cb_data[2] = width_adj;
        cb_data[3] = height_adj;
        cb_data[4] = border_adj;
	gtk_widget_add_events(w, GDK_EXPOSURE_MASK);
	gtk_signal_connect(
	    GTK_OBJECT(w), "expose_event",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleExposeCB), cb_data
	);
        gtk_signal_connect(
            GTK_OBJECT(w), "destroy",
            GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleDestroyCB), cb_data
        );
	gtk_widget_set_usize(w, 320, 240);
	gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_widget_show(w);

        gtk_signal_connect(
            GTK_OBJECT(width_adj), "value_changed",
            GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), cb_data
        );
        gtk_signal_connect(
            GTK_OBJECT(height_adj), "value_changed",
            GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), cb_data
        );
        gtk_signal_connect(
            GTK_OBJECT(border_adj), "value_changed",
            GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), cb_data
        );


}

/*
 *      Create image browser tool bar page on customize window.
 */
static void EDVCreateCustomizeImbrToolBarPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint i;
        gint border_minor = 2, border_major = 5;
	gchar *strptr;
        GSList *gslist;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;
        stack_list_struct *slist;
        edv_imbr_opid_struct **opid, *opid_ptr;
        gint total_opids;
	gchar slist_item_name[256];


        /* Hbox for toolbar display and relief frames. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


        /* Tool bar display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display Buttons As"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue Abrocha Como"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "L'exposition Boutonne Comme"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Text radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_TEXT;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures & text radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures & Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos Y El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images Et Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


        /* Tool bar relief frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Buttons Relief"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Alivio De Botones"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Soulagement De Boutons"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Flush radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Flush"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Rubor"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Eclat"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NONE;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Half radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Half"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Mitad"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Moiti"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_HALF;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Raised radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Raised"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Levantado"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Hauss"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NORMAL;



        /* Arrangement frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Arrangement"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Arreglo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Arrangement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;


        /* Create tool bar stack list. */
        slist = StackListNew(
            parent2,
#ifdef PROG_LANGUAGE_ENGLISH
            "Available", "Current",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Disponible", "La Corriente",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Disponible", "Courant",
#endif
            NULL, NULL
        );
        StackListMap(slist);
        wref = OptWinWRefAppend(
            optwin, NULL, NULL,
            EDV_CFG_PARM_IMBR_TOOL_BAR
        );
        wref->slist = slist;    /* This wref reffers to a stack list. */

        /* Create tool bar items from image browser operation ids. */
        opid = EDVImbrOPIDListNew(NULL, &total_opids);
        for(i = 0; i < total_opids; i++)
        {
            opid_ptr = opid[i];
            if(opid_ptr == NULL)
                continue;

            /* Copy menu name from opid to the slist item name buffer
             * and sanitize it.
             */
            strncpy(
                slist_item_name,
                (opid_ptr->menu_name != NULL) ?
                    opid_ptr->menu_name : "(null)",
                256
            );
            slist_item_name[256 - 1] = '\0';

            strptr = strstr(slist_item_name, "...");
            if(strptr != NULL)
                *strptr = '\0';

            /* Add slist item from this opid. */
            StackListAppend(
                slist, slist_item_name, opid_ptr->tooltip,
                opid_ptr->button_icon_data,
                NULL,           /* No client data. */
                opid_ptr->op,   /* Operation id. */
                opid_ptr->allow_multiple,
                FALSE           /* Not fixed on target. */
            );
        }
        /* Deallocate local copy of image browser operation ids. */
        EDVImbrOPIDListDelete(opid, total_opids);
        StackListUpdateMenus(slist);

}

/*
 *      Create image browser appearance page on customize window.
 */
static void EDVCreateCustomizeImbrAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;


        /* Hbox to separate two columns. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent = w;


        /* First column vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

        /* Show in title bar frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Show In Title Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Muestre En La Barra Del Ttulo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Montrer Dans La Barre De Titre"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;


        /* Show user name in title. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "User Name"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Nombre Del Usuario"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Nom D'Utilisateur"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TITLE_WITH_USER
        );

        /* Show location in title. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Emplacement"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_TITLE_WITH_LOCATION
        );


        /* Display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Exposition"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Show tool bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre d'Outil"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR
        );

        /* Show location bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Location Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre d'Emplacement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR
        );

        /* Show mount bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Mount Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Monte La Barra"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Monter La Barre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR
        );

        /* Show find bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Find Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Encuentre La Barra"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Trouver La Barre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_FIND_BAR
        );

        /* Show status bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Status Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Posicin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre De Statut"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR
        );


        /* Second column vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;


        /* Filter frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Filter"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Filtro"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Filtre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Show hidden objects check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hidden Objects"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Objetos Escondidos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Objets Cachs"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN
        );

        /* Show no access objects check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "No Access Objects"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Objetos Ningn Acceso"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Aucun Accs Objets"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS
        );

        /* Show non-image objects check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Non-Image Objects"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "No Objetos De Imagen"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "La Non-Image S'Oppose"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE
        );



}


/*
 *      Create browser contents list page on customize window.
 */
static void EDVCreateCustomizeBrowserContentsListPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2;
        edv_cfg_wref_struct *wref;
        stack_list_struct *slist;


        /* Display options frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Cell Display Options"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Las Opciones Despliegue Clula"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Les Options d'Exposition Cellule"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

	/* Hide dir size check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Directory Size"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Tamao Gua"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Taille d'Annuaire"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE
        );

        /* Hide link size check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Link Size"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Tamao Eslabn"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Taille Lien"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_SIZE
        );

        /* Hide link permission check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hide Link Permissions"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Esconda Permisos Eslabn"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Cacher Permissions Lien"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS
        );


        /* Arrangement frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Arrangement"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Arreglo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Arrangement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Create contents list stack list. */
        slist = StackListNew(
            parent2,
#ifdef PROG_LANGUAGE_ENGLISH
            "Available", "Current",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Disponible", "La Corriente",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Disponible", "Courant",
#endif
	    NULL, NULL
        );
        StackListMap(slist);
        wref = OptWinWRefAppend(
            optwin, NULL, NULL,
            EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN
        );
        wref->slist = slist;    /* This wref reffers to a stack list. */

        /* Create tool bar items from browser operation ids. */
	StackListAppend(
	    slist, "Name", "File name of the object",
	    NULL,		/* No icon data. */
	    NULL,		/* No client data. */
	    EDV_BROWSER_COLUMN_TYPE_NAME,
	    FALSE, TRUE		/* No multiple, stay on target. */
	);
        StackListAppend(
            slist, "Size", "Size of the object on disk",
            NULL,               /* No icon data. */
	    NULL,		/* No client data. */
            EDV_BROWSER_COLUMN_TYPE_SIZE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Type", "Object's MIME Type",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_TYPE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Permissions", "Object's permissions",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_PERMISSIONS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Owner", "Owner of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_OWNER,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Group", "Grouped ownership of the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_GROUP,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Access", "Date the object was last accessed",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Modified", "Date the object was last modified",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Date Changed", "Date the object was last changed",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Hard Links", "Number of hard links",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_HARD_LINKS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Linked to", "Linked to destination path",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_LINKED_TO,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Device", "Device that the object exists on",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_DEVICE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "INode", "Object's address on the device",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_INODE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Device Type", "Device's major and minor number pair",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Block Size", "Unit of each block within the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );
        StackListAppend(
            slist, "Blocks", "Number of blocks within the object",
            NULL,               /* No icon data. */
            NULL,               /* No client data. */
            EDV_BROWSER_COLUMN_TYPE_BLOCKS,
            FALSE, FALSE        /* No multiple, no stay on target. */
        );

	StackListUpdateMenus(slist);

}

/*
 *	Create browser tool bar page on customize window.
 */
static void EDVCreateCustomizeBrowserToolBarPage(
	edv_core_struct *core_ptr, edv_optwin_struct *optwin,
	GtkWidget *parent
)
{
	gint i;
	gint border_minor = 2, border_major = 5;
	gchar *strptr;
	GSList *gslist;
	GtkWidget *w, *parent2, *parent3;
	edv_cfg_wref_struct *wref;
	stack_list_struct *slist;
	edv_browser_opid_struct **opid, *opid_ptr;
	gint total_opids;
	gchar slist_item_name[256];


        /* Hbox for toolbar display and relief frames. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;


	/* Tool bar display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display Buttons As"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue Abrocha Como"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "L'exposition Boutonne Comme"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Text radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_TEXT;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Pictures & text radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Pictures & Text"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Retratos Y El Texto"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Images Et Texte"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY
        );
        wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


        /* Tool bar relief frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Buttons Relief"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Alivio De Botones"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Soulagement De Boutons"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Flush radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Flush"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Rubor"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Eclat"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NONE;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Half radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Half"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Mitad"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Moiti"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_HALF;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Raised radio button. */
        w = gtk_radio_button_new_with_label(gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Raised"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Levantado"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Hauss"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF
        );
        wref->radio_value = TOOLBAR_RELIEF_NORMAL;



	/* Arrangement frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Arrangement"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Arreglo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Arrangement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

	/* Create tool bar stack list. */
	slist = StackListNew(
	    parent2,
#ifdef PROG_LANGUAGE_ENGLISH
            "Available", "Current",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Disponible", "La Corriente",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Disponible", "Courant",
#endif
	    NULL, NULL
	);
	StackListMap(slist);
	wref = OptWinWRefAppend(
	    optwin, NULL, NULL,
	    EDV_CFG_PARM_BROWSER_TOOL_BAR
	);
	wref->slist = slist;	/* This wref reffers to a stack list. */

	/* Create tool bar items from browser operation ids. */
	opid = EDVBrowserOPIDListNew(NULL, &total_opids);
	for(i = 0; i < total_opids; i++)
	{
	    opid_ptr = opid[i];
	    if(opid_ptr == NULL)
		continue;

            /* Copy menu name from opid to the slist item name buffer
             * and sanitize it.
             */
            strncpy(
                slist_item_name,
                (opid_ptr->menu_name != NULL) ?
                    opid_ptr->menu_name : "(null)",
                256
            );
            slist_item_name[256 - 1] = '\0';

            strptr = strstr(slist_item_name, "...");
            if(strptr != NULL)
                *strptr = '\0';

            /* Add slist item from this opid. */
	    StackListAppend(
		slist, slist_item_name, opid_ptr->tooltip,
		opid_ptr->button_icon_data,
		NULL,		/* No client data. */
		opid_ptr->op,	/* Operation id. */
		opid_ptr->allow_multiple,
		FALSE		/* Not fixed on target. */
	    );
	}
	/* Deallocate local copy of browser operation ids. */
	EDVBrowserOPIDListDelete(opid, total_opids);
	StackListUpdateMenus(slist);

}

/*
 *	Create browser appearance page on customize window.
 */
static void EDVCreateCustomizeBrowserAppearancePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;


	/* Hbox to separate two columns. */
        w = gtk_hbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	parent = w;


        /* First column vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;

        /* Show in title bar frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Show In Title Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Muestre En La Barra Del Ttulo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Montrer Dans La Barre De Titre"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;


        /* Show user name in title. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "User Name"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Nombre Del Usuario"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Nom D'Utilisateur"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TITLE_WITH_USER
        );

        /* Show location in title. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Emplacement"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_TITLE_WITH_LOCATION
        );


        /* Display frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Despliegue"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Exposition"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Show tool bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre d'Outil"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR
        );

        /* Show location bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Location Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre d'Emplacement"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR
        );

        /* Show mount bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Mount Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Monte La Barra"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Monter La Barre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR
        );

        /* Show find bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Find Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Encuentre La Barra"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Trouver La Barre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR
        );

        /* Show status bar check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Status Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Barra De Posicin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Barre De Statut"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR
        );


        /* Second column vbox. */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;


        /* Filter frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Filter"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Filtro"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Filtre"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        /* Show hidden objects check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Hidden Objects"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Objetos Escondidos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Objets Cachs"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN
        );

        /* Show no access objects check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "No Access Objects"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Objetos Ningn Acceso"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Aucun Accs Objets"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS
        );

}



/*
 *      Create general page on customize window.
 */
static void EDVCreateCustomizeGeneralPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2;
        edv_cfg_wref_struct *wref;


        /* Tool tips frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Tool Tips"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Herramienta Vuelca"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "L'outil Se Renverse"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Show tool tips check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Show Tool Tips"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Muestre Herramienta Puntas"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Montrer Les Pointes d'Outil"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_SHOW_TOOLTIPS
        );




}

/*
 *	Selects the notebook tab specified by tab_name for the given
 *	customize window.
 */
void EDVCustomizeWindowSelectTab(
        edv_optwin_struct *optwin, const gchar *tab_name
)
{
	gint page_num;
	GtkNotebook *notebook;


	if(optwin == NULL)
	    return;

	notebook = (GtkNotebook *)optwin->notebook;
	if(notebook == NULL)
	    return;

	if(tab_name != NULL)
	{
	    if(!strcasecmp(tab_name, "General"))
		page_num = 0;
            else if(!strcasecmp(tab_name, "File Browser"))
                page_num = 1;
            else if(!strcasecmp(tab_name, "Image Browser"))
                page_num = 2;
            else if(!strcasecmp(tab_name, "Archiver"))
                page_num = 3;
            else if(!strcasecmp(tab_name, "Recycle Bin"))
                page_num = 4;
	    else
		page_num = 0;
	}
	else
	{
	    page_num = 0;
	}

	gtk_notebook_set_page(notebook, page_num);

}

/*
 *	Creates a new customize window.
 */
edv_optwin_struct *EDVCreateCustomizeWindow(
        gpointer core_ptr
)
{
	gint border_minor = 2, border_major = 5;
	GtkWidget *w, *parent, *parent2;
	edv_optwin_struct *optwin = OptWinNew(
	    core_ptr,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Customize",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Haga Personal",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Personnaliser",
#endif
	    (guint8 **)icon_customize_48x48_xpm
	);
	if(optwin == NULL)
	    return(optwin);


	/* Begin creating general page. */
	w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "General"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "General"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Gnral"
#endif
	);
	parent = OptWinPageAppend(optwin, w);
	if(parent != NULL)
	{
	    gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
	    parent2 = parent;

            EDVCreateCustomizeGeneralPage(
                (edv_core_struct *)core_ptr, optwin, parent2
            );
	}

        /* Begin creating file browser page. */
	parent = gtk_hbox_new(FALSE, border_minor);
	w = GUICreateMenuItemIcon((u_int8_t **)endeavour_20x20_xpm);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "File Browser"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Archive A Examinador"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Classer Browser"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
	w = parent;
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;


	    /* Notebook. */
	    w = gtk_notebook_new();
            gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
            gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
            gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
            gtk_widget_show(w);
            parent2 = w;


            /* Appearance page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
		    "Appearance"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Apariencia"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Apparence"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeBrowserAppearancePage(
                (edv_core_struct *)core_ptr, optwin, w
            );

	    /* Toolbar page. */
            w = gtk_vbox_new(FALSE, border_major);
	    gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Barre d'Outil"
#endif
		)
	    );
	    gtk_widget_show(w);
	    EDVCreateCustomizeBrowserToolBarPage(
		(edv_core_struct *)core_ptr, optwin, w
	    );

	    /* Contents list page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Contents List"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "El Contenido Lista"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Contenus Liste"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeBrowserContentsListPage(
                (edv_core_struct *)core_ptr, optwin, w
            );

        }

        /* Begin creating image browser page. */
        parent = gtk_hbox_new(FALSE, border_minor);
        w = GUICreateMenuItemIcon((u_int8_t **)image_browser_20x20_xpm);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Image Browser"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Examinador De Imagen"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Browser d'Image"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        w = parent;
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;


            /* Notebook. */
            w = gtk_notebook_new();
            gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
            gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
            gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
            gtk_widget_show(w);
            parent2 = w;


            /* Appearance page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Appearance"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Apariencia"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Apparence"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeImbrAppearancePage(
                (edv_core_struct *)core_ptr, optwin, w
            );

            /* Toolbar page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Barre d'Outil"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeImbrToolBarPage(
                (edv_core_struct *)core_ptr, optwin, w
            );

            /* Thumbs list page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Thumbs List"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "Los Pulgares Lista"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Pouces Liste"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeImbrThumbsListPage(
                (edv_core_struct *)core_ptr, optwin, w
            );


	}


        /* Begin creating archiver page. */
        parent = gtk_hbox_new(FALSE, border_minor);
        w = GUICreateMenuItemIcon((u_int8_t **)archiver_20x20_xpm);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Archiver"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Archiver"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Archiver"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        w = parent;
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;


            /* Notebook. */
            w = gtk_notebook_new();
            gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
            gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
            gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
            gtk_widget_show(w);
            parent2 = w;


            /* Appearance page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Appearance"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Apariencia"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Apparence"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeArchiverAppearancePage(
                (edv_core_struct *)core_ptr, optwin, w
            );

            /* Toolbar page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Barre d'Outil"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeArchiverToolBarPage(
                (edv_core_struct *)core_ptr, optwin, w
            );

            /* Contents list page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Contents List"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "El Contenido Lista"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Contenus Liste"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeArchiverContentsListPage(
                (edv_core_struct *)core_ptr, optwin, w
            );

        }


        /* Begin creating recycle bin page. */
        parent = gtk_hbox_new(FALSE, border_minor);
        w = GUICreateMenuItemIcon((u_int8_t **)icon_trash_20x20_xpm);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Recycle Bin"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Cajn De Recirculacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Recycle L'Huche"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        w = parent;
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;


            /* Notebook. */
            w = gtk_notebook_new();
            gtk_notebook_set_tab_pos(GTK_NOTEBOOK(w), GTK_POS_TOP);
            gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
            gtk_notebook_set_scrollable(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_tabs(GTK_NOTEBOOK(w), TRUE);
            gtk_notebook_set_show_border(GTK_NOTEBOOK(w), TRUE);
            gtk_widget_show(w);
            parent2 = w;


            /* Appearance page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Appearance"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Apariencia"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Apparence"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeRecBinAppearancePage(
                (edv_core_struct *)core_ptr, optwin, w
            );

            /* Toolbar page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Tool Bar"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "La Barra De Herramienta"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Barre d'Outil"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeRecBinToolBarPage(
                (edv_core_struct *)core_ptr, optwin, w
            );

            /* Contents list page. */
            w = gtk_vbox_new(FALSE, border_major);
            gtk_container_border_width(GTK_CONTAINER(w), border_major);
            gtk_notebook_append_page(
                GTK_NOTEBOOK(parent2), w, gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Contents List"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "El Contenido Lista"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Contenus Liste"
#endif
		)
            );
            gtk_widget_show(w);
            EDVCreateCustomizeRecBinContentsListPage(
                (edv_core_struct *)core_ptr, optwin, w
            );

        }





	return(optwin);
}
