#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#include "../include/string.h"

#include "guiutils.h"

#include "tlist.h"
#include "edvlistseek.h"


gbool EDVCListSeekCharacter(
        GtkCList *clist, gint column, gint cidx, gchar c
);
gbool EDVTListSeekCharacter(
        tlist_struct *tlist, gint cidx, gchar c
);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))


/*
 *	Searches all cells of the given clist on the specified column
 *	who has the character at index cidx that matches c.
 *
 *	If a match is made, then the clist will be scrolled to the
 *	position of the first match and the return will be TRUE.
 */
gbool EDVCListSeekCharacter(
        GtkCList *clist, gint column, gint cidx, gchar c
)
{
	guint8 spacing;
	gint row;
	gchar *cstrptr;
	GdkBitmap *mask;
	GdkPixmap *pixmap;


	if((clist == NULL) || (cidx < 0))
	    return(FALSE);

	if((column < 0) || (column >= clist->columns))
	    return(FALSE);

	/* Iterate through all rows on the clist. */
	for(row = 0; row < clist->rows; row++)
	{
	    /* Handle by cell type. */
	    switch((gint)gtk_clist_get_cell_type(clist, row, column))
	    {
              case GTK_CELL_TEXT:
		gtk_clist_get_text(
		    clist, row, column, &cstrptr
		);
		break;

              case GTK_CELL_PIXTEXT:
		gtk_clist_get_pixtext(
		    clist, row, column, &cstrptr,
		    &spacing, &pixmap, &mask
		);
		break;

	      default:	/* Other cell types do not have text. */
		cstrptr = NULL;
		break;
	    }
	    /* Got pointer to text in current cell? */
	    if(cstrptr != NULL)
	    {
		gint len = strlen(cstrptr);

		/* Length of cell text long enough to check for
		 * character index?
		 */
		if(cidx < len)
		{
		    /* Length of cell text is allocated long enough, now
		     * check if the character of the cell text at index
		     * cidx matches the given character.
		     */
		    if(cstrptr[cidx] == c)
		    {
			/* Got a match, scroll to this row. */
                        gtk_clist_moveto(
			    clist,
			    row, column,	/* Row, column. */
			    0.5, 0.0		/* Row, column. */
			);
			return(TRUE);
		    }
		}
	    }
	}

	return(FALSE);
}

/*
 *      Searches all thumbs of the given tlist who has a the character
 *      at index cidx that matches c.
 *
 *      If a match is made, then the tlist will be scrolled to the
 *      position of the first match and the return will be TRUE.
 */
gbool EDVTListSeekCharacter(
        tlist_struct *tlist, gint cidx, gchar c
)
{
	const gchar *cstrptr;
	gint i;
	tlist_thumb_struct *thumb_ptr;


        if((tlist == NULL) || (cidx < 0))
            return(FALSE);


	/* Iterate through all thumbs. */
	for(i = 0; i < tlist->total_thumbs; i++)
	{
	    thumb_ptr = tlist->thumb[i];
	    if(thumb_ptr == NULL)
		continue;

	    cstrptr = thumb_ptr->text;

            /* Got pointer to text in current thumb? */
            if(cstrptr != NULL)
            {
                gint len = strlen(cstrptr);

                /* Length of thumb text long enough to check for
                 * character index?
                 */
                if(cidx < len)
                {
                    /* Length of thumb text is allocated long enough, now
                     * check if the character of the thumb text at index
                     * cidx matches the given character.
                     */
                    if(cstrptr[cidx] == c)
                    {
                        /* Got a match, scroll to this thumb. */
			TListMoveTo(tlist, i, 0.5);
                        return(TRUE);
                    }
                }
            }
	}

	return(FALSE);
}
