/*
                      Endeavour Utility Functions

	These utils do not depend on the edv_core_struct * pointer or
	any GTK+ resources.
 */

#ifndef EDVUTILS_H
#define EDVUTILS_H

#include <sys/types.h>
#include <glib.h>
#include "edvtypes.h"

extern void EDVSimplifyPath(gchar *path);
extern gboolean EDVIsParentPath(const gchar *parent, const gchar *child);
extern gboolean EDVIsExtension(const gchar *path, const gchar *ext);

extern gchar *EDVCopyShortenPath(const gchar *path, gint max);
extern gchar *EDVCopyEvaluateInputPath(
        const gchar *parent, const gchar *input_path
);
extern gchar *EDVTmpName(const gchar *dir);

extern void EDVGetDeviceNumbers(dev_t rdev, gint *major, gint *minor);
extern dev_t EDVFormatDeviceNumbers(gint major, gint minor);

#endif	/* EDVUTILS_H */
