/*
                      Endeavour Mark II Core Structure
 */

#ifndef ENDEAVOUR_H
#define ENDEAVOUR_H


#include <gtk/gtk.h>

#include "pulist.h"
#include "edvtypes.h"
#include "edvid.h"
#include "edvcfg.h"
#include "edvhistory.h"
#include "edvcursor.h"
#include "edvdevices.h"
#include "edvmimetypes.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "recbin.h"
#include "recbindeskicon.h"
#include "findwin.h"
#include "propwin.h"
#include "historywin.h"
#include "rundlg.h"
#include "deviceswin.h"
#include "mimetypeswin.h"
#include "optwin.h"
#include "aboutdialog.h"


#ifdef HAVE_IMLIB
extern gpointer imlib_handle;
#endif


/*
 *	Core structure:
 */
typedef struct {

	/* Browsers list. */
	edv_browser_struct **browser;
	gint total_browsers;

	/* Image browsers list. */
	edv_imbr_struct **imbr;
	gint total_imbrs;

        /* Archivers list. */
        edv_archiver_struct **archiver;
        gint total_archivers;

	/* Recycle bin. */
	edv_recbin_struct *recbin;
	/* Recycle bin desktop icon. */
	edv_recbin_deskicon_struct *recbin_deskicon;
	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not.
	 */
	gint last_recbin_items;

	/* Find window. */
	edv_findwin_struct *findwin;

        /* Properties windows list. */
        edv_propwin_struct **propwin;
        gint total_propwins;

	/* History list window. */
	edv_history_listwin_struct *history_listwin;

	/* Run dialog. */
	edv_run_dlg_struct *run_dlg;

	/* Devices list window. */
	edv_device_listwin_struct *device_listwin;

	/* MIME Types list window. */
	edv_mimetype_listwin_struct *mimetype_listwin;

	/* Options window. */
	edv_optwin_struct *options_window;

	/* Customize window. */
	edv_optwin_struct *customize_window;

	/* About dialog. */
	about_dialog_struct *about_dialog;


	/* Basic GUI options. */
	gbool geometry_set;
	GdkRectangle geometry;	/* Only defined if geometry_set is TRUE. */

	gchar *font_name;
	GdkFont *font;

	gchar	*fg_color_name, *bg_color_name,
		*sfg_color_name, *sbg_color_name,
		*cfg_color_name, *cbg_color_name,
		*bg_pixmap_path, *sbg_pixmap_path;
	gchar	*wm_name, *wm_class, *title;


	/* Timeout callback id and related members. */
	guint manage_toid;
	gbool need_close_all_windows;

	/* Queued interprocess commands. */
	gchar **interprocess_command;
	gint total_interprocess_commands;

	/* Path to program object taken from command line arguments. */
	gchar *prog_file;

	/* Process id. */
	gint pid;

	/* User and group id running this process. */
	gint user_id;			/* Real user id. */
	gint effective_user_id;		/* Effective user id. */
	gint group_id;			/* Real group id. */
	gint effective_group_id;	/* Effective group id. */

	/* User id list. */
	edv_uid_struct **uid;
	gint total_uids;
        pulist_struct *users_pulist;

        /* Group id list. */
        edv_gid_struct **gid;
        gint total_gids;
        pulist_struct *groups_pulist;

	/* Verbose string describing effective user and effective user
	 * @ hostname. This is used for quick setting of title bars
	 * since the user and location do not change often at run time.
	 */
	gchar *effective_user_id_str;		/* user */
	gchar *effective_user_id_location_str;	/* user@hostname */

	/* Cursors list. */
	edv_cursor_struct **cursor;
	gint total_cursors;

        /* Devices list. */
        edv_device_struct **device;
        gint total_devices;
        pulist_struct *devices_pulist;	/* For mount bars. */

	/* MIME Types list. */
	edv_mimetype_struct **mimetype;
	gint total_mimetypes;
	pulist_struct *openwith_pulist;	/* Lists application MIME Types for Open With... */
	/* MIME Types index hints, these are index values of the first
	 * and last items of a particular MIME Type class. These index values
	 * may not be valid.
	 */
	gint mimetype_system_index_first, mimetype_system_index_last;
        gint mimetype_format_index_first, mimetype_format_index_last;
        gint mimetype_program_index_first, mimetype_program_index_last;
        gint mimetype_unique_index_first, mimetype_unique_index_last;

	/* Configuration file path. */
	gchar *cfg_file;
	/* Configuration list. */
	edv_cfg_item_struct *cfg_list;

	/* Operation history list. */
	edv_history_struct **history_event;
	gint total_history_events;

} edv_core_struct;

#define EDV_CORE(p)	((edv_core_struct *)(p))

extern edv_core_struct *edv_core;	/* Passed around globally in
					 * functions main() and
					 * EDVSignalCB().
					 */

#endif	/* ENDEAVOUR_H */
