#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "cdialog.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "edvobj.h"
#include "edvstatusbar.h"
#include "archiver.h"
#include "archivercontents.h"
#include "browser.h"
#include "browserdirtree.h"
#include "browsercontents.h"
#include "recbincontents.h"
#include "imbr.h"
#include "imbrtlist.h"
#include "findwin.h"
#include "findwincb.h"
#include "endeavour.h"
#include "edvfind.h"
#include "edvopen.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"


void EDVFindWinListItemDestroyCB(gpointer data);

gint EDVFindWinDeleteEventCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
void EDVFindWinDestroyCB(GtkObject *object, gpointer data);

gint EDVFindWinCrossingCB(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
gint EDVFindWinButtonCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
);

void EDVFindWinComboActivateCB(GtkWidget *widget, gpointer data);

gint EDVFindWinFindProgressCB(
        const gchar *path, gfloat progress, gpointer data
);

void EDVFindWinFindMatchedExcerptCB(
        const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
        gpointer data
);
void EDVFindWinFindMatchedCB(
	const gchar *path, const struct stat *lstat_buf,
	gpointer data
);

void EDVFindWinClickColumnCB(
        GtkCList *clist, gint column, gpointer data
);
void EDVFindWinSelectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
void EDVFindWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);

void EDVFindWinSearchCB(GtkWidget *widget, gpointer data);
void EDVFindWinStopCB(GtkWidget *widget, gpointer data);
void EDVFindWinClearCB(GtkWidget *widget, gpointer data);
void EDVFindWinCloseCB(GtkWidget *widget, gpointer data);
void EDVFindWinOpenCB(GtkWidget *widget, gpointer data);
void EDVFindWinOpenWithCB(GtkWidget *widget, gpointer data);
void EDVFindWinGotoCB(GtkWidget *widget, gpointer data);

void EDVFindWinWriteProtectChangedCB(
        edv_findwin_struct *fw, gbool state
);




/*
 *      Find window results GtkCList item "destroy" signal callback.
 */
void EDVFindWinListItemDestroyCB(gpointer data)
{
        EDVObjectDelete((edv_object_struct *)data);
}

/*
 *	Find window GtkWidget "delete_event" signal callback.
 */
gint EDVFindWinDeleteEventCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	EDVFindWinCloseCB(widget, data);
        return(TRUE);
}

/*
 *      Find window GtkWidget "destroy" signal callback.
 */
void EDVFindWinDestroyCB(GtkObject *object, gpointer data)
{
	return;
}

/*
 *	GtkWidget "enter_notify_event" or "leave_notify_event" signal
 *	callback.
 */
gint EDVFindWinCrossingCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
	const gchar *mesg = NULL;
	gint etype;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if((widget == NULL) || (crossing == NULL) || (fw == NULL))
            return(FALSE);

	etype = crossing->type;

	if(etype == GDK_ENTER_NOTIFY)
	{
	    if(widget == fw->case_sensitive_check)
#ifdef PROG_LANGUAGE_ENGLISH
		mesg =
"Specifies if string matches should be case sensitive or not";
#endif
#ifdef PROG_LANGUAGE_SPANISH
		mesg =
"Especifica si los iguales de cuerda no deben ser el casos sensibles ni";
#endif
#ifdef PROG_LANGUAGE_FRENCH
		mesg =
"Spcifie si les allumettes de ficelle devraient tre des cas sensibles ou pas";
#endif
	    else if(widget == fw->recursive_check)
#ifdef PROG_LANGUAGE_ENGLISH
		mesg =
"Specifies if the search process should recurse into subdirectories";
#endif
#ifdef PROG_LANGUAGE_SPANISH
		mesg =
"Especifica si el proceso de la bsqueda debe recurse en el subdirectories";
#endif
#ifdef PROG_LANGUAGE_FRENCH
		mesg =
"Spcifie si le procd de recherche doit recurse dans subdirectories";
#endif
	    else if(widget == fw->search_btn)
#ifdef PROG_LANGUAGE_ENGLISH
                mesg = "Start the search";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                mesg = "Comience la bsqueda";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                mesg = "Commencer la recherche";
#endif
	    else if(widget == fw->stop_btn)
#ifdef PROG_LANGUAGE_ENGLISH
                mesg = "Stop the current find procedure";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                mesg = "Pare el procedimiento actual del hallazgo";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                mesg = "Arrter la procdure de dcouverte actuelle";
#endif
	    else if(widget == fw->clear_btn)
#ifdef PROG_LANGUAGE_ENGLISH
                mesg = "Clear search string and results list";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                mesg = "La cuerda clara de la bsqueda y resultados listan";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                mesg = "Clair recherche et rsultats numre";
#endif
            else if(widget == fw->close_btn)
#ifdef PROG_LANGUAGE_ENGLISH
                mesg = "Close this window";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                mesg = "Cierre esta ventana";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                mesg = "Fermer cette fentre";
#endif
            else if(widget == fw->open_btn)
#ifdef PROG_LANGUAGE_ENGLISH
                mesg = "Open selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                mesg = "Abra escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                mesg = "Ouvrir l'objet choisi";
#endif
            else if(widget == fw->open_with_btn)
#ifdef PROG_LANGUAGE_ENGLISH
                mesg = "Open selected object using a specific method";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                mesg = "Abra escogido se opone usar un method especfico";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                 mesg = "Ouvrir l'objet choisi pour utiliser un method spcifique";
#endif
            else if(widget == fw->goto_btn)
#ifdef PROG_LANGUAGE_ENGLISH
                mesg = "Go to selected object";
#endif
#ifdef PROG_LANGUAGE_SPANISH
                mesg = "Vaya a escogido se opone";
#endif
#ifdef PROG_LANGUAGE_FRENCH
                mesg = "Aller  l'objet choisi";
#endif
	}
	EDVStatusBarMessage(fw->status_bar, mesg, FALSE);


	return(FALSE);
}

/*
 *      Browser GtkWidget "button_press_event" signal callback.
 */
gint EDVFindWinButtonCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
)
{
        static gbool reenterent = FALSE;
        gint status = FALSE;
        gint etype;
        edv_core_struct *core_ptr;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if((widget == NULL) || (button == NULL) || (fw == NULL))
            return(status);

        if(fw->processing)
            return(status);

        core_ptr = (edv_core_struct *)fw->core_ptr;
        if(core_ptr == NULL)
            return(status);

        if(reenterent)
            return(status);
        else
            reenterent = TRUE;

        /* Get event type. */
        etype = button->type;

        /* Check which ctree this signal is for. */
        if(widget == fw->results_clist)
        {
            gint row, column;
            gint rows_selected = 0, selected_row = -1;
            GList *glist;
            GtkCList *clist = GTK_CLIST(widget);


            /* Find row and column based on given coordinates. */
            if(!gtk_clist_get_selection_info(
                clist, button->x, button->y, &row, &column
            ))
            {
                row = -1;
                column = 0;
            }

            /* Get number of selected rows and highest selected row. */
            glist = clist->selection;
            while(glist != NULL)
            {
                rows_selected++;
                selected_row = (gint)glist->data;
                glist = glist->next;
            }

            /* Handle by button number. */
            switch(button->button)
            {
              case 3:
                if(etype == GDK_BUTTON_PRESS)
                {
/*		    GtkMenu *menu; */

                    /* Select item before mapping menu? */
                    if(EDVCFGItemListGetValueI(
                        core_ptr->cfg_list, EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS
                    ) && (row >= 0) && (row < clist->rows))
                    {
                        /* Select the row that the button was pressed over.
                         * if no key modifiers are held then this will also
                         * unselect all previously selected rows.
                         */
                        gtk_clist_freeze(clist);
                        if(!(button->state & GDK_CONTROL_MASK) &&
                           !(button->state & GDK_SHIFT_MASK)
                        )
                            gtk_clist_unselect_all(clist);
                        clist->focus_row = row;
                        gtk_clist_select_row(clist, row, 0);
                        gtk_clist_thaw(clist);
                    }

                    /* Update all menus and map right click menu. */
                    EDVFindWinUpdateMenus(fw);
/*
                    menu = (GtkMenu *)fw->results_clist_menu;
                    if(menu != NULL)
                        gtk_menu_popup(
                            menu, NULL, NULL,
                            NULL, NULL,
                            button->button, button->time
                        );
 */
                }
                status = TRUE;
                break;

              case 2:
                if(etype == GDK_BUTTON_PRESS)
                {
/*
                    if((row >= 0) && (row < clist->rows))
                        EDVFindWinContentsDoFPromptRename(
                            fw, row, column
                        );
 */
                }
                status = TRUE;
                break;

              case 1:
                /* Double click? */
                if(etype == GDK_2BUTTON_PRESS)
                {
                    if((row >= 0) && (row < clist->rows))
                    {
			EDVFindWinOpenCB(NULL, fw);
                        status = TRUE;
                    }
                }
                break;
            }

            if(etype == GDK_BUTTON_PRESS)
                gtk_widget_grab_focus(widget);
        }

        reenterent = FALSE;
        return(status);
}






/*
 *	GtkCombo "activate" signal callback.
 */
void EDVFindWinComboActivateCB(GtkWidget *widget, gpointer data)
{
	EDVFindWinSearchCB(widget, data);
}


/*
 *	Find procedure progress callback.
 */
gint EDVFindWinFindProgressCB(
	const gchar *path, gfloat progress, gpointer data
)
{
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return(0);

	/* Need to stop? If so then 1 to indicate stop. */
	if(fw->stop_count > 0)
	    return(1);

	EDVStatusBarMessage(fw->status_bar, path, FALSE);
	EDVStatusBarProgress(fw->status_bar, progress, TRUE);
	return(0);
}

/*
 *	Find procedure got match callback.
 */
void EDVFindWinFindMatchedExcerptCB(
        const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
        gpointer data
)
{
	edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

	EDVFindWinListAppend(fw, path, lstat_buf, excerpt);
}

void EDVFindWinFindMatchedCB(
        const gchar *path, const struct stat *lstat_buf, gpointer data
)
{
	EDVFindWinFindMatchedExcerptCB(path, lstat_buf, NULL, data);
}


/*
 *	GtkCList "click_column" signal callback.
 */
void EDVFindWinClickColumnCB(
        GtkCList *clist, gint column, gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if((clist == NULL) || (fw == NULL))
            return;

        if(fw->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;




        reenterent = FALSE;
}

/*
 *	GtkCList "select_row" signal callback.
 */
void EDVFindWinSelectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if((clist == NULL) || (fw == NULL))
            return;

        if(fw->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Check which clist this signal is for. */
        if(GTK_WIDGET(clist) == fw->results_clist)
        {
            gint total_selected = 0;
            GList *glist;
            edv_object_struct *obj;


            /* Get total number of objects selected. */
            glist = clist->selection;
            while(glist != NULL)
            {
                total_selected++;
                glist = glist->next;
            }
            /* Update selected row. */
/*	    fw->results_clist_selected_row = row; */

            /* Update DND icon for results clist. */
/*
            EDVFindWinContentsDNDSetIcon(fw, row, column);
 */

            /* Get disk object structure from selected row. */
            obj = (edv_object_struct *)gtk_clist_get_row_data(
                clist, row
            );
            if(obj != NULL)
            {
                /* Update status bar message. */
                if(obj->full_path != NULL)
                {
                    gchar *buf;
		    const gchar *name;
                    const gchar *type_str = "Object";
                    gchar size_str[80];


		    /* Get name from full path, since the name of the
		     * object may be a string specifying a special
		     * notation depending on the role.
		     */
		    name = strrchr(obj->full_path, DIR_DELIMINATOR);
		    if(name != NULL)
			name++;
		    else
			name = obj->full_path;

                    /* Get object type string and size string. */
                    *size_str = '\0';
                    switch(obj->type)
                    {
                      case EDV_OBJECT_TYPE_FILE:
                        type_str = "File";
                        sprintf(size_str, " (%ld bytes)", obj->size);
                        break;
                      case EDV_OBJECT_TYPE_DIRECTORY:
                        type_str = "Directory";
                        break;
                      case EDV_OBJECT_TYPE_LINK:
                        type_str = "Link";
                        break;
                      case EDV_OBJECT_TYPE_DEVICE_BLOCK:
                        type_str = "Block device";
                        break;
                      case EDV_OBJECT_TYPE_DEVICE_CHARACTER:
                        type_str = "Character device";
                        break;
                      case EDV_OBJECT_TYPE_FIFO:
                        type_str = "FIFO Pipe";
                        break;
                      case EDV_OBJECT_TYPE_SOCKET:
                        type_str = "Socket";
                        break;
                    }

                    /* Format status bar message. */
                    if(total_selected > 1)
                        buf = g_strdup_printf(
                            "%i objects selected",
                            total_selected
                        );
                    else if(!strcmp(name, ".."))
                        buf = g_strdup_printf(
                            "Parent directory selected"
                        );
                    else
                        buf = g_strdup_printf(
                            "%s \"%s\" selected%s",
                            type_str, name, size_str
                        );

                    /* Set status bar message. */
                    EDVStatusBarMessage(
                        fw->status_bar, buf, FALSE
                    );

                    /* Deallocate status bar message. */
                    g_free(buf);
                }
                else
                {
                    EDVStatusBarMessage(
                        fw->status_bar,
                        "Object with NULL name selected",
                        FALSE
                    );
                }
            }

            /* Check if selected row is fully visible, if not then adjust
             * scroll position to try and make it visible.
             */
            if(gtk_clist_row_is_visible(clist, row) !=
                GTK_VISIBILITY_FULL
            )
                gtk_clist_moveto(
                    clist,
                    row, -1,	/* Row, column. */
                    0.5, 0.0	/* Row, column. */
                );

/*	    EDVFindWinSetTitle(fw); */
            EDVFindWinUpdateMenus(fw);
        }

        reenterent = FALSE;
}

/*
 *      GtkCList "unselect_row" signal callback.
 */
void EDVFindWinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if((clist == NULL) || (fw == NULL))
            return;

        if(fw->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Check which clist this signal is for. */
        if(GTK_WIDGET(clist) == fw->results_clist)
        {


/*	    EDVFindWinSetTitle(fw); */
            EDVFindWinUpdateMenus(fw);
        }

        reenterent = FALSE;
}


/*
 *	Search callback, this begins the finding process.
 */
void EDVFindWinSearchCB(GtkWidget *widget, gpointer data)
{
	gint op_code;
	const gchar *cstrptr;
	gbool case_sensitive = FALSE, recursive = FALSE;
	gchar *location, *search_string;
	gint total_matches;
	GtkWidget *w;
        edv_core_struct *core_ptr;
	edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

	if(fw->processing)
	    return;

        core_ptr = (edv_core_struct *)fw->core_ptr;
        if(core_ptr == NULL)
            return;

	fw->processing = TRUE;


	/* Begin getting search values. */

	/* Find operation code. */
	op_code = EDVFindWinCurrentFindOP(fw);

	/* Search string. */
	cstrptr = EDVFindWinCurrentSearch(fw);
	search_string = (cstrptr != NULL) ? g_strdup(cstrptr) : NULL;
	/* No wild cards in search string? */
	if((strchr(search_string, '*') == NULL) &&
           (strchr(search_string, '?') == NULL) &&
           (op_code == EDV_FINDWIN_FIND_OBJECT_NAME)
	)
	{
	    /* Tack on two '*' characters to the beginning and end of
	     * the search string.
	     */
	    gchar *strptr = g_strdup_printf("*%s*", search_string);
	    g_free(search_string);
	    search_string = strptr;
	}
	/* Record search string history. */
	EDVFindWinSetSearch(fw, search_string, TRUE);

        /* Get copy of starting parent directory as location and
	 * record the location history.
	 */
        location = NULL;
        switch(fw->role)
        {
          case EDV_FINDWIN_ROLE_DISK_OBJECT:
          case EDV_FINDWIN_ROLE_ARCHIVE_OBJECT:
	    cstrptr = EDVFindWinCurrentLocation(fw);
	    location = EDVCopyEvaluateInputPath(NULL, cstrptr);
            /* Record starting location history. */
            EDVFindWinSetLocation(fw, location, TRUE);
            break;

          case EDV_FINDWIN_ROLE_RECYCLED_OBJECT:
            cstrptr = EDVCFGItemListGetValueS(
                core_ptr->cfg_list, EDV_CFG_PARM_FILE_RECYCLED_INDEX
            );
	    location = EDVCopyEvaluateInputPath(NULL, cstrptr);
	    /* Record starting location history. */
	    EDVFindWinSetLocation(fw, GetParentDir(location), TRUE);
            break;
        }

	/* Case sensitive. */
	w = fw->case_sensitive_check;
	if(w != NULL)
	    case_sensitive = GTK_TOGGLE_BUTTON(w)->active;

        /* Recursive. */
        w = fw->recursive_check;
        if(w != NULL)
            recursive = GTK_TOGGLE_BUTTON(w)->active;


	/* Set up find window and begin search. */
	fw->stop_count = 0;
        EDVFindWinSetBusy(fw, TRUE);
	EDVFindWinListClear(fw);
	EDVFindWinListResetColumns(fw, op_code);
        EDVFindWinUpdateMenus(fw);

	/* Perform find procedure by find operation code. */
	total_matches = 0;
	switch(op_code)
	{
	  case EDV_FINDWIN_FIND_OBJECT_NAME:
            switch(fw->role)
            {
              case EDV_FINDWIN_ROLE_DISK_OBJECT:
		total_matches = EDVFindObjectByName(
		    location, search_string,
		    recursive, case_sensitive,
		    fw,
		    EDVFindWinFindProgressCB,
		    EDVFindWinFindMatchedCB
		);
		break;

              case EDV_FINDWIN_ROLE_RECYCLED_OBJECT:
                total_matches = EDVFindRecycledObjectByName(
                    location,		/* Recycled objects index file. */
                    search_string,
                    case_sensitive,
                    fw,
                    EDVFindWinFindProgressCB,
                    EDVFindWinFindMatchedCB
                );
                break;

              case EDV_FINDBAR_ROLE_ARCHIVE_OBJECT:
                total_matches = EDVFindArchiveObjectByName(
		    core_ptr,
                    location,           /* Archive. */
                    search_string,
                    case_sensitive,
                    fw,
                    EDVFindWinFindProgressCB,
                    EDVFindWinFindMatchedCB
                );
                break;
            }
	    break;

          case EDV_FINDWIN_FIND_OBJECT_CONTENT:
            switch(fw->role)
            {
              case EDV_FINDWIN_ROLE_DISK_OBJECT:
		total_matches = EDVFindObjectByContent(
		    location, search_string,
		    recursive, case_sensitive,
		    fw,
		    EDVFindWinFindProgressCB,
		    EDVFindWinFindMatchedExcerptCB
		);
                break;

              case EDV_FINDWIN_ROLE_RECYCLED_OBJECT:
                total_matches = EDVFindRecycledObjectByContent(
                    location,		/* Recycled objects index file. */
                    search_string,
                    case_sensitive,
                    fw,
                    EDVFindWinFindProgressCB,
                    EDVFindWinFindMatchedExcerptCB
                );
                break;

              case EDV_FINDBAR_ROLE_ARCHIVE_OBJECT:
                /* Finding archive object by content is not supported yet. */
                total_matches = 0;
                break;
            }
            break;
	}


        EDVFindWinSetBusy(fw, FALSE);


	/* Tally. */
	EDVStatusBarProgress(fw->status_bar, 0.0, FALSE);

	if(total_matches > 0)
	{
	    gchar *buf = g_strdup_printf(
		"Matched %i object%s",
		total_matches,
		(total_matches == 1) ? "" : "s"
	    );
	    EDVStatusBarMessage(fw->status_bar, buf, FALSE);
	    g_free(buf);
	}
	else
	{
	    EDVStatusBarMessage(fw->status_bar, "No objects found", FALSE);
	}

	/* Set values on find window reflecting end of search. */
	fw->processing = FALSE;
	EDVFindWinUpdateMenus(fw);


        /* Deallocate locally allocated memory. */
        g_free(location);
        location = NULL;

        g_free(search_string);
        search_string = NULL;
}

/*
 *	Stop callback.
 */
void EDVFindWinStopCB(GtkWidget *widget, gpointer data)
{
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

	/* Skip processing check, this callback is allowed to continue
	 * during processing.
	 */

	fw->stop_count++;
}

/*
 *	Clear callback.
 */
void EDVFindWinClearCB(GtkWidget *widget, gpointer data)
{
	GtkCombo *combo;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

	if(fw->processing)
	    return;

	combo = (GtkCombo *)fw->search_combo;
	if(combo != NULL)
	    gtk_entry_set_text(GTK_ENTRY(combo->entry), "");

	EDVFindWinListClear(fw);
	EDVFindWinUpdateMenus(fw);
}

/*
 *	Close callback.
 */
void EDVFindWinCloseCB(GtkWidget *widget, gpointer data)
{
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

        if(fw->processing)
            return;

	EDVFindWinSyncConfiguration(fw);
        EDVFindWinUnmap(fw);
}

/*
 *	Open callback.
 */
void EDVFindWinOpenCB(GtkWidget *widget, gpointer data)
{
	gint row;
	GtkCList *clist;
	edv_object_struct *obj;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

        if(fw->processing)
            return;

	clist = (GtkCList *)fw->results_clist;
	if(clist == NULL)
	    return;

	/* Unsupported role for opening object? */
	if(fw->role != EDV_FINDWIN_ROLE_DISK_OBJECT)
	{
	    CDialogSetTransientFor(fw->toplevel);
	    CDialogGetResponse(
		"Open Failed",
"The object does not actually exist as a normal disk object\n\
and therefore cannot be opened",
		NULL,
		CDIALOG_ICON_WARNING,
		CDIALOG_BTNFLAG_OK,
		CDIALOG_BTNFLAG_OK
	    );
	    CDialogSetTransientFor(NULL);

	    return;
	}

	row = EDVCListGetSelectedLast(clist, NULL);
	obj = (edv_object_struct *)gtk_clist_get_row_data(clist, row);

	if((obj != NULL) ? (obj->full_path != NULL) : FALSE)
	{
	    const gchar *full_path = obj->full_path;


	    if(ISPATHDIR(full_path))
	    {
		/* Open directory? */
/* Work this out later. */
	    }
	    else
	    {
		gchar	*stdout_path_rtn = NULL,
			*stderr_path_rtn = NULL;


		EDVFindWinSetBusy(fw, TRUE);
		EDVOpenObjectPath(
		    (edv_core_struct *)fw->core_ptr, full_path,
		    NULL,		/* Command name. */
		    fw->toplevel, TRUE,
		    &stdout_path_rtn, &stderr_path_rtn
		);
		EDVFindWinSetBusy(fw, FALSE);

		g_free(stdout_path_rtn);
		stdout_path_rtn = NULL;
		g_free(stderr_path_rtn);
		stderr_path_rtn = NULL;
	    }
	}
}

/*
 *      Open with callback.
 */
void EDVFindWinOpenWithCB(GtkWidget *widget, gpointer data)
{
        gint row;
        GtkCList *clist;
        edv_object_struct *obj;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

        if(fw->processing)
            return;

        clist = (GtkCList *)fw->results_clist;
        if(clist == NULL)
            return;

        /* Unsupported role for opening object? */
        if(fw->role != EDV_FINDWIN_ROLE_DISK_OBJECT)
        {
            CDialogSetTransientFor(fw->toplevel);
            CDialogGetResponse(
                "Open Failed",
"The object does not actually exist as a normal disk object\n\
and therefore cannot be opened",
                NULL,
                CDIALOG_ICON_WARNING,
                CDIALOG_BTNFLAG_OK,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);

            return;
        }

        row = EDVCListGetSelectedLast(clist, NULL);
        obj = (edv_object_struct *)gtk_clist_get_row_data(clist, row);

        if((obj != NULL) ? (obj->full_path != NULL) : FALSE)
        {
            gchar       *stdout_path_rtn = NULL,
                        *stderr_path_rtn = NULL;

            EDVOpenWithObjectPath(
                (edv_core_struct *)fw->core_ptr, obj->full_path,
                NULL,                   /* Command name. */
                fw->toplevel, TRUE,
                &stdout_path_rtn, &stderr_path_rtn
            );

            g_free(stdout_path_rtn);
            stdout_path_rtn = NULL;
            g_free(stderr_path_rtn);
            stderr_path_rtn = NULL;
        }
}


/*
 *	Goto callback.
 */
void EDVFindWinGotoCB(GtkWidget *widget, gpointer data)
{
	gint row;
	GtkCList *clist;
	edv_object_struct *obj;
	edv_core_struct *core_ptr;
	gchar *parent_dir, *full_path;
        edv_findwin_struct *fw = (edv_findwin_struct *)data;
        if(fw == NULL)
            return;

	if(fw->processing)
	    return;

	core_ptr = (edv_core_struct *)fw->core_ptr;
	if(core_ptr == NULL)
	    return;

        clist = (GtkCList *)fw->results_clist;
        if(clist == NULL)
            return;

        row = EDVCListGetSelectedLast(clist, NULL);
        obj = (edv_object_struct *)gtk_clist_get_row_data(clist, row);

        if((obj != NULL) ? (obj->full_path == NULL) : TRUE)
	    return;


	/* Get copy of full path and parent directory. */
	full_path = g_strdup(obj->full_path);
	parent_dir = g_strdup(GetParentDir(full_path));


	/* Check which window `go to' by checking if its index set on
	 * the find window structure is non-negative.
	 */
	/* File browser? */
	if(fw->browser_num > -1)
	{
	    gint browser_num = fw->browser_num;
	    edv_browser_struct *browser;

	    if((browser_num >= 0) && (browser_num < core_ptr->total_browsers))
		browser = core_ptr->browser[browser_num];
	    else
		browser = NULL;

	    if(browser != NULL)
	    {
		gint row;
		const gchar *cur_path = EDVBrowserCurrentLocation(browser);
		GtkCList *clist = (GtkCList *)browser->contents_clist;

		/* Select the parent directory only if its different than
		 * the current directory.
	 	 */
		if((cur_path != NULL) ? strcmp(cur_path, parent_dir) : TRUE)
		    EDVBrowserDirTreeDoSelectPath(browser, parent_dir);

		/* The contents listing on the browser should be updated
		 * if the parent directory was selected successfully.
		 * Now find the object on the content's clist who's path
		 * matches the path of the object.
		 */
		if(clist != NULL)
		{
		    row = EDVBrowserContentsFindRowByPath(browser, full_path);
		    if((row >= 0) && (row < clist->rows))
		    {
			gtk_clist_freeze(clist);
			gtk_clist_unselect_all(clist);
			gtk_clist_thaw(clist);

			gtk_clist_select_row(clist, row, 0);
		    }
		}
	    }
	}
	/* Image browser? */
	else if(fw->imbr_num > -1)
	{
            gint imbr_num = fw->imbr_num;
            edv_imbr_struct *imbr;

            if((imbr_num >= 0) && (imbr_num < core_ptr->total_imbrs))
                imbr = core_ptr->imbr[imbr_num];
            else
                imbr = NULL;

            if(imbr != NULL)
            {
                gint thumb_num;
                const gchar *cur_path = EDVImbrCurrentLocation(imbr);
                tlist_struct *tlist = imbr->tlist;

                /* Select the parent directory only if its different than
                 * the current directory.
                 */
                if((cur_path != NULL) ? strcmp(cur_path, parent_dir) : TRUE)
		    EDVImbrSelectPath(imbr, parent_dir);

		/* The thumbs list should now contain a list of the contents
		 * of the parent_dir. Now we look for a particular thumb
		 * that matches the path of the object.
		 */
                if(tlist != NULL)
                {
                    thumb_num = EDVImbrTListFindThumbByPath(imbr, full_path);
		    TListFreeze(tlist);
		    TListUnselectAll(tlist);
		    TListSelectThumb(tlist, thumb_num);
		    TListThaw(tlist);
                }

		EDVImbrUpdateMenus(imbr);
	    }
	}
	/* Recycle bin. */
	else if(fw->recbin_num > -1)
	{
	    edv_recbin_struct *recbin = core_ptr->recbin;
	    if((recbin != NULL) && (obj->name != NULL))
	    {
		gint row;
                GtkCList *clist = (GtkCList *)recbin->contents_clist;

		/* The disk object's name is a string specifying the
		 * recycled object index number.
		 */
		row = EDVRecBinContentsFindRowByIndex(
		    recbin, (guint)atoi(obj->name)
		);
		if((row >= 0) && (row < clist->rows))
		{
                    gtk_clist_freeze(clist);
                    gtk_clist_unselect_all(clist);
                    gtk_clist_thaw(clist);

		    gtk_clist_select_row(clist, row, 0);
		}
	    }
	}
        /* Archiver. */
        else if(fw->archiver_num > -1)
        {
            gint archiver_num = fw->archiver_num;
            edv_archiver_struct *archiver;

            if((archiver_num >= 0) && (archiver_num < core_ptr->total_archivers))
                archiver = core_ptr->archiver[archiver_num];
            else
                archiver = NULL;

            if(archiver != NULL)
            {
                gint row;
                GtkCList *clist = (GtkCList *)archiver->contents_clist;

                if(clist != NULL)
                {
                    row = EDVArchiverContentsFindRowByPath(
			archiver, full_path
		    );
                    if((row >= 0) && (row < clist->rows))
                    {
                        gtk_clist_freeze(clist);
                        gtk_clist_unselect_all(clist);
                        gtk_clist_thaw(clist);

                        gtk_clist_select_row(clist, row, 0);
		    }
                }
            }
	}


	/* Deallocate coppied paths. */
	g_free(parent_dir);
	parent_dir = NULL;

	g_free(full_path);
	full_path = NULL;
}



/*
 *	Called whenever the global write protect state has changed.
 */
void EDVFindWinWriteProtectChangedCB(
	edv_findwin_struct *fw, gbool state
)
{
	if(fw == NULL)
	    return;

	EDVFindWinUpdateMenus(fw);	
}
