/*
                   Endeavour File operation dialog

	Used for copying, moving, and linking files.
 */

#ifndef FOPDIALOG_H
#define FOPDIALOG_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvobj.h"


/*
 *	File operation dialog operation codes:
 */
#define EDV_FOPDIALOG_OP_MOVE	0
#define EDV_FOPDIALOG_OP_COPY	1
#define EDV_FOPDIALOG_OP_LINK	2

#define EDV_FOPDIALOG_OP_CHMOD	3
#define EDV_FOPDIALOG_OP_CHOWN	4


/*
 *	File operation dialog structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;

	gpointer core_ptr;

	GtkAccelGroup *accelgrp;
	GtkWidget	*toplevel,
			*main_vbox,
			*icon_fixed,
			*icon_pm,
			*label,		/* Describing source objects. */

			*target_entry,		/* For move, copy, and link destinations. */

			*target_browse_btn,

			*target_chmod_parent,	/* Parent containing chmode check widgets. */
			*target_uread_check,
                        *target_uwrite_check,
                        *target_uexecute_check,
                        *target_gread_check,
                        *target_gwrite_check,
                        *target_gexecute_check,
                        *target_aread_check,
                        *target_awrite_check,
                        *target_aexecute_check,
                        *target_setuid_check,
                        *target_setgid_check,
                        *target_sticky_check,

			*target_chown_parent,	/* Parent containing chown widgets. */
			*target_owner_entry,	/* For chowning. */
                        *target_owner_btn,
                        *target_group_entry,
                        *target_group_btn,

			*move_btn,
			*copy_btn,
			*link_btn,
                        *chmod_btn,
                        *chown_btn,

			*cancel_btn;

	/* Reference toplevel for transiency, shared. */
	GtkWidget *ref_toplevel;

	/* Operation code, one of EDV_FOPDIALOG_OP_*. */
	gint op;

	/* Source list of objects. */
	edv_object_struct **src_obj;
	gint src_obj_total;

	/* Source directory (relative/current location). */
	gchar *src_dir;

} edv_fopdialog_struct;



extern edv_fopdialog_struct *EDVFOPDialogNew(gpointer core_ptr);
extern void EDVFOPDialogReset(edv_fopdialog_struct *d);
extern void EDVFOPDialogMapValues(
	edv_fopdialog_struct *d,
	gint op,		/* One ofEDV_FOPDIALOG_OP_*. */
	edv_object_struct **src_obj,	/* Source list, will be coppied. */
        gint src_obj_total,
	const gchar *src_dir,
        GtkWidget *toplevel
);
extern void EDVFOPDialogUnmap(edv_fopdialog_struct *d);
extern void EDVFOPDialogDelete(edv_fopdialog_struct *d);


#endif	/* FOPDIALOG_H */
