#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "cdialog.h"
#include "progressdialog.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "edvobj.h"
#include "edvconfirm.h"
#include "edvrecbin.h"
#include "edvrecbinfio.h"
#include "edvrecbinfop.h"
#include "edvdevices.h"
#include "edvmount.h"
#include "fopdialog.h"
#include "imbr.h"
#include "imbrcb.h"
#include "imbropcb.h"
#include "imbrtlist.h"
#include "endeavour.h"
#include "edvfcreate.h"
#include "edvcb.h"
#include "edvop.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"



void EDVImbrMenuItemCB(GtkWidget *widget, gpointer data);
gint EDVImbrMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
gint EDVImbrMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
void EDVImbrOPCB(gpointer data);
void EDVImbrOPEnterCB(gpointer data);
void EDVImbrOPLeaveCB(gpointer data);

void EDVImbrMountBarMountCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);
void EDVImbrMountBarEjectCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);
void EDVImbrMountBarGoToCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);

gchar *EDVImbrFindBarLocationCB(gpointer fb, gpointer data);
void EDVImbrFindBarStartCB(gpointer fb, gpointer data);
void EDVImbrFindBarEndCB(
        gpointer fb, gint total_matches, gpointer data
);
void EDVImbrFindBarMatchCB(
        const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
	gpointer data
);

void EDVImbrBarStatusMessageCB(
        gpointer bar, const gchar *message, gpointer data
);
void EDVImbrBarStatusProgressCB(
        gpointer bar, gfloat progress, gpointer data
);

void EDVImbrOPSyncDisks(edv_imbr_struct *imbr);
void EDVImbrOPWriteProtect(edv_imbr_struct *imbr);

void EDVImbrOPClose(edv_imbr_struct *imbr);
void EDVImbrOPExit(edv_imbr_struct *imbr);

void EDVImbrOPNewFile(edv_imbr_struct *imbr);
void EDVImbrOPNewDirectory(edv_imbr_struct *imbr);
void EDVImbrOPNewLink(edv_imbr_struct *imbr);
void EDVImbrOPNewFifo(edv_imbr_struct *imbr);
void EDVImbrOPNewDeviceBlock(edv_imbr_struct *imbr);
void EDVImbrOPNewDeviceCharacter(edv_imbr_struct *imbr);
void EDVImbrOPNewSocket(edv_imbr_struct *imbr);

void EDVImbrOPOpen(edv_imbr_struct *imbr);
void EDVImbrOPOpenWith(edv_imbr_struct *imbr);

static edv_object_struct **EDVImbrGetSelectedObjects(
        edv_imbr_struct *imbr, gint *total
);
void EDVImbrOPMove(edv_imbr_struct *imbr);
void EDVImbrOPCopy(edv_imbr_struct *imbr);
void EDVImbrOPLink(edv_imbr_struct *imbr);
void EDVImbrOPRename(edv_imbr_struct *imbr);
void EDVImbrOPChMod(edv_imbr_struct *imbr);
void EDVImbrOPChown(edv_imbr_struct *imbr);
void EDVImbrOPDelete(edv_imbr_struct *imbr);
void EDVImbrOPProperties(edv_imbr_struct *imbr);

void EDVImbrOPCopyPath(edv_imbr_struct *imbr);
void EDVImbrOPCopyURL(edv_imbr_struct *imbr);

void EDVImbrOPGoToParent(edv_imbr_struct *imbr);
void EDVImbrOPMount(edv_imbr_struct *imbr);
void EDVImbrOPEject(edv_imbr_struct *imbr);
void EDVImbrOPSelectAll(edv_imbr_struct *imbr);
void EDVImbrOPUnselectAll(edv_imbr_struct *imbr);
void EDVImbrOPInvertSelection(edv_imbr_struct *imbr);

void EDVImbrOpStop(edv_imbr_struct *imbr);
void EDVImbrOpContinue(edv_imbr_struct *imbr);
void EDVImbrOPRefresh(edv_imbr_struct *imbr);
void EDVImbrOPRefreshAll(edv_imbr_struct *imbr);

void EDVImbrOPDownload(edv_imbr_struct *imbr);


/*
 *      Menu item activate callback.
 *
 *	The given client data must be a edv_imbr_opid_struct *.
 */
void EDVImbrMenuItemCB(GtkWidget *widget, gpointer data)
{
        EDVImbrOPCB(data);
}

/*
 *      Menu item "enter_notify_event" signal callback.
 *
 *      The given client data must be a edv_imbr_opid_struct *.
 */
gint EDVImbrMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
        EDVImbrOPEnterCB(data);
        return(TRUE);
}

/*
 *      Menu item "leave_notify_event" signal callback.
 *
 *      The given client data must be a edv_imbr_opid_struct *.
 */
gint EDVImbrMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
	EDVImbrOPLeaveCB(data);
        return(TRUE);
}

/*
 *      Operation id callback nexus.
 *
 *      The given client data must be a edv_imbr_opid_struct *.
 */
void EDVImbrOPCB(gpointer data)
{
	static gbool reenterent = FALSE;
        gint dev_num;
        edv_device_struct *dev_ptr;
        edv_imbr_struct *imbr;
	edv_core_struct *core_ptr;
        edv_imbr_opid_struct *opid = (edv_imbr_opid_struct *)data;
        if(opid == NULL)
            return;

        imbr = (edv_imbr_struct *)opid->imbr;
        if(imbr == NULL)
            return;

	if(imbr->processing)
	    return;

	core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get last selected device (if any). */
        dev_num = imbr->selected_dev_num;
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;

	if(reenterent)
	    return;
	else
	    reenterent = TRUE;

	/* Handle by operation id code. */
	switch(opid->op)
	{
	  case EDV_IMBR_OP_CLOSE:
	    EDVImbrOPClose(imbr);
	    break;

	  case EDV_IMBR_OP_EXIT:
	    EDVImbrOPExit(imbr);
	    break;


          case EDV_IMBR_OP_SYNC_DISKS:
            EDVImbrOPSyncDisks(imbr);
            break;

          case EDV_IMBR_OP_WRITE_PROTECT:
	    EDVImbrOPWriteProtect(imbr);
	    break;

          case EDV_IMBR_OP_RUN:
            EDVDoMapRunDlg(core_ptr);
            break;

          case EDV_IMBR_OP_RUN_TERMINAL:
            EDVDoRunTerminal(core_ptr, NULL);
            break;


	  case EDV_IMBR_OP_NEW:
	    break;

          case EDV_IMBR_OP_NEW_FILE:
            EDVImbrOPNewFile(imbr);
            break;

	  case EDV_IMBR_OP_NEW_DIRECTORY:
	    EDVImbrOPNewDirectory(imbr);
	    break;

          case EDV_IMBR_OP_NEW_LINK:
            EDVImbrOPNewLink(imbr);
            break;

          case EDV_IMBR_OP_NEW_FIFO:
            EDVImbrOPNewFifo(imbr);
            break;

          case EDV_IMBR_OP_NEW_DEVICE_BLOCK:
            EDVImbrOPNewDeviceBlock(imbr);
            break;

          case EDV_IMBR_OP_NEW_DEVICE_CHARACTER:
            EDVImbrOPNewDeviceCharacter(imbr);
            break;

          case EDV_IMBR_OP_NEW_SOCKET:
            EDVImbrOPNewSocket(imbr);
            break;


          case EDV_IMBR_OP_OPEN:
            EDVImbrOPOpen(imbr);
            break;

          case EDV_IMBR_OP_OPEN_WITH:
	    EDVImbrOPOpenWith(imbr);
	    break;


	  case EDV_IMBR_OP_GOTO_PARENT:
            EDVImbrOPGoToParent(imbr);
            break;

          case EDV_IMBR_OP_MOUNT:
            EDVImbrOPMount(imbr);
            break;

          case EDV_IMBR_OP_EJECT:
	    EDVImbrOPEject(imbr);
            break;

          case EDV_IMBR_OP_MOVE:
	    EDVImbrOPMove(imbr);
            break;

          case EDV_IMBR_OP_COPY:
	    EDVImbrOPCopy(imbr);
            break;

	  case EDV_IMBR_OP_LINK:
	    EDVImbrOPLink(imbr);
	    break;

	  case EDV_IMBR_OP_RENAME:
	    EDVImbrOPRename(imbr);
	    break;

          case EDV_IMBR_OP_CHMOD:
            EDVImbrOPChMod(imbr);
            break;

          case EDV_IMBR_OP_CHOWN:
            EDVImbrOPChown(imbr);
            break;

	  case EDV_IMBR_OP_DELETE:
	    EDVImbrOPDelete(imbr);
	    break;

	  case EDV_IMBR_OP_SELECT_ALL:
	    EDVImbrOPSelectAll(imbr);
            break;

          case EDV_IMBR_OP_UNSELECT_ALL:
	    EDVImbrOPUnselectAll(imbr);
            break;

          case EDV_IMBR_OP_INVERT_SELECTION:
            EDVImbrOPInvertSelection(imbr);
            break;

	  case EDV_IMBR_OP_PROPERTIES:
	    EDVImbrOPProperties(imbr);
            break;

          case EDV_IMBR_OP_FIND:
            EDVDoMapImbrFindWin(core_ptr, imbr);
            break;

          case EDV_IMBR_OP_HISTORY:
            EDVDoMapHistoryListWin(core_ptr, imbr->toplevel);
            break;

          case EDV_IMBR_OP_COPY_PATH:
	    EDVImbrOPCopyPath(imbr);
	    break;

	  case EDV_IMBR_OP_COPY_URL:
	    EDVImbrOPCopyURL(imbr);
	    break;


	  case EDV_IMBR_OP_STOP:
	    EDVImbrOpStop(imbr);
	    break;

          case EDV_IMBR_OP_CONTINUE:
            EDVImbrOpContinue(imbr);
            break;

	  case EDV_IMBR_OP_REFRESH:
	    EDVImbrOPRefresh(imbr);
	    break;

	  case EDV_IMBR_OP_REFRESH_ALL:
            EDVImbrOPRefreshAll(imbr);
            break;


          case EDV_IMBR_OP_DOWNLOAD:
	    EDVImbrOPDownload(imbr);
	    break;


          case EDV_IMBR_OP_SHOW_TOOL_BAR:
	    if(core_ptr != NULL)
	    {
		gbool state = !EDVCFGItemListGetValueI(
		    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR
		);
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR,
		    state, FALSE
                );
		EDVReconfiguredEmit(core_ptr);
	    }
            break;

          case EDV_IMBR_OP_SHOW_LOCATION_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

          case EDV_IMBR_OP_SHOW_MOUNT_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

          case EDV_IMBR_OP_SHOW_FIND_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_FIND_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_FIND_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

          case EDV_IMBR_OP_SHOW_STATUS_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

	  case EDV_IMBR_OP_MIME_TYPES:
	    EDVDoMapMIMETypesListWin(core_ptr, imbr->toplevel);
	    break;

          case EDV_IMBR_OP_DEVICES:
            EDVDoMapDevicesListWin(core_ptr, imbr->toplevel);
            break;


	  case EDV_IMBR_OP_NEW_BROWSER:
	    EDVDoNewBrowser(core_ptr);
	    break;

          case EDV_IMBR_OP_NEW_IMBR:
            EDVDoNewImbr(core_ptr);
            break;

          case EDV_IMBR_OP_NEW_ARCHIVER:
            EDVDoNewArchiver(core_ptr);
            break;

          case EDV_IMBR_OP_RECYCLE_BIN:
	    EDVDoMapRecBin(core_ptr);
            break;

	  case EDV_IMBR_OP_OPTIONS:
	    EDVDoMapOptionsWin(core_ptr, imbr->toplevel);
	    break;

	  case EDV_IMBR_OP_CUSTOMIZE:
	    EDVDoMapCustomizeWin(core_ptr, imbr->toplevel);
	    break;


          case EDV_IMBR_OP_DEVICE_CHECK:
            EDVDoRunDeviceCheck(core_ptr, dev_ptr, imbr->toplevel);
            break;

          case EDV_IMBR_OP_DEVICE_TOOLS:
            EDVDoRunDeviceTools(core_ptr, dev_ptr, imbr->toplevel);
            break;

          case EDV_IMBR_OP_DEVICE_FORMAT:
            EDVDoRunDeviceFormat(core_ptr, dev_ptr, imbr->toplevel);
            break;


          case EDV_IMBR_OP_HELP_ABOUT:
            EDVDoHelpAbout(core_ptr, imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_CONTENTS:
            EDVDoHelp(core_ptr, "Contents", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_FILE_BROWSER:
            EDVDoHelp(core_ptr, "File Browser", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_IMAGE_BROWSER:
            EDVDoHelp(core_ptr, "Image Browser", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_ARCHIVER:
            EDVDoHelp(core_ptr, "Archiver", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_RECYCLE_BIN:
            EDVDoHelp(core_ptr, "Recycle Bin", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_KEYS_LIST:
            EDVDoHelp(core_ptr, "Keys List", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_MIME_TYPES:
            EDVDoHelp(core_ptr, "MIME Types", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_DEVICES:
            EDVDoHelp(core_ptr, "Devices", imbr->toplevel);
            break;
          case EDV_IMBR_OP_HELP_COMMON_OPERATIONS:
            EDVDoHelp(core_ptr, "Common Operations", imbr->toplevel);
            break;


	  default:
	    if(1)
	    {
		gchar text[256];

		sprintf(
		    text,
		    "Unsupported image browser operation `%i'\n",
		    opid->op
		);

		CDialogSetTransientFor(imbr->toplevel);
		CDialogGetResponse(
		    "Operation Error",
		    text,
		    NULL,
		    CDIALOG_ICON_ERROR,
		    CDIALOG_BTNFLAG_OK,
		    CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
	    }
	    break;
	}

	reenterent = FALSE;
}

/*
 *      Operation id enter notify callback nexus.
 *
 *      The given client data must be a edv_imbr_opid_struct *.
 */
void EDVImbrOPEnterCB(gpointer data)
{
        const gchar *tooltip;
        edv_imbr_struct *imbr;
        edv_imbr_opid_struct *opid = (edv_imbr_opid_struct *)data;
        if(opid == NULL)
            return;

        imbr = (edv_imbr_struct *)opid->imbr;
        if(imbr == NULL)
            return;

        tooltip = opid->tooltip;
        if(tooltip != NULL)
            EDVStatusBarMessage(imbr->status_bar, tooltip, FALSE);
}

/*
 *      Operation id leave notify callback nexus.
 */
void EDVImbrOPLeaveCB(gpointer data)
{
        edv_imbr_struct *imbr;
        edv_imbr_opid_struct *opid = (edv_imbr_opid_struct *)data;
        if(opid == NULL)
            return;

        imbr = (edv_imbr_struct *)opid->imbr;
        if(imbr == NULL)
            return;

	EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
}


/*
 *      Find bar get current location callback.
 */
gchar *EDVImbrFindBarLocationCB(gpointer fb, gpointer data)
{
        return(EDVImbrCurrentLocation(
            (edv_imbr_struct *)data
        ));
}

/*
 *	Mount bar mount callback.
 */
void EDVImbrMountBarMountCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
)
{
	static gbool reenterent = FALSE;
	gbool original_mount_state;
	gint status;
	edv_core_struct *core_ptr;
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
	if((imbr == NULL) || (dev_ptr == NULL))
	    return;

	if(imbr->processing)
	    return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

	if(reenterent)
	    return;
	else
	    reenterent = TRUE;

        /* Record original mount state. */
        original_mount_state = dev_ptr->is_mounted;


        EDVImbrSetBusy(imbr, TRUE);


        /* Unmount or mount? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
        else
            status = EDVMountDoMount(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


        EDVImbrSetBusy(imbr, FALSE);


        /* Mount error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    original_mount_state ?
                        "Unmount Failed" : "Mount Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
            /* Report mount signal to all of endeavour's resources. */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
        }

	reenterent = FALSE;
}

/*
 *      Mount bar eject callback.
 */
void EDVImbrMountBarEjectCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
)
{
        static gbool reenterent = FALSE;
        gbool original_mount_state;
        gint status;
        edv_core_struct *core_ptr;
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
        if((imbr == NULL) || (dev_ptr == NULL))
            return;

        if(imbr->processing)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Record original mount state. */
        original_mount_state = dev_ptr->is_mounted;


        EDVImbrSetBusy(imbr, TRUE);

        /* Need to unmount first? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
        /* So now eject. */
        status = EDVMountDoEject(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );

        EDVImbrSetBusy(imbr, FALSE);


        /* Mount error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Eject Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
            /* Report eject (unmount) signal to all of endeavour's
             * resources.
             */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
        }

        reenterent = FALSE;
}

/*
 *	Mount bar go to mount path callback.
 */
extern void EDVImbrMountBarGoToCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
)
{
        static gbool reenterent = FALSE;
	gchar *path;
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
        if((imbr == NULL) || (dev_ptr == NULL))
            return;

        if(imbr->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	/* Get copy of mount path. */
	path = (dev_ptr->mount_path != NULL) ?
	    g_strdup(dev_ptr->mount_path) : NULL;

	EDVImbrSetBusy(imbr, TRUE);

	EDVImbrSelectPath(imbr, path);
	EDVImbrUpdateMenus(imbr);

	EDVImbrSetBusy(imbr, FALSE);

	/* Deallocate copy of mount path. */
	g_free(path);
	path = NULL;

        reenterent = FALSE;
}


/*
 *      Find bar start find callback.
 */
void EDVImbrFindBarStartCB(gpointer fb, gpointer data)
{
        tlist_struct *tlist;
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
        if(imbr == NULL)
            return;

        tlist = imbr->tlist;
        if(tlist == NULL)
            return;

	EDVImbrSetBusy(imbr, TRUE);
/*	GUIBlockInput(imbr->toplevel, TRUE); */

	TListFreeze(tlist);
	TListUnselectAll(tlist);
	TListThaw(tlist);

        EDVImbrUpdateMenus(imbr);
}

/*
 *      Find bar end find callback.
 */
void EDVImbrFindBarEndCB(
        gpointer fb, gint total_matches, gpointer data
)
{
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
        if(imbr == NULL)
            return;

/*	GUIBlockInput(imbr->toplevel, FALSE); */
	EDVImbrSetBusy(imbr, FALSE);
}


/*
 *      Find bar match callback.
 */
void EDVImbrFindBarMatchCB(
        const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
	gpointer data
)
{
        gint thumb_num;
	tlist_struct *tlist;
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
        if((path == NULL) || (lstat_buf == NULL) || (imbr == NULL))
            return;

	tlist = imbr->tlist;
        if(tlist == NULL)
            return;

	thumb_num = EDVImbrTListFindThumbByPath(imbr, path);
	if((thumb_num >= 0) && (thumb_num < tlist->total_thumbs))
	{
	    TListFreeze(tlist);
	    TListSelectThumb(tlist, thumb_num);
	    TListThaw(tlist);
	}
}


/*
 *      Opaque status bar message update callback, the first argument
 *      bar is completely ignored.
 */
void EDVImbrBarStatusMessageCB(
        gpointer mb, const gchar *message, gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
        if(imbr == NULL)
            return;

        if(imbr->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	EDVStatusBarMessage(imbr->status_bar, message, FALSE);

        reenterent = FALSE;
}

/*
 *      Opaque status bar progress update callback, the first argument
 *      bar is completely ignored.
 */
void EDVImbrBarStatusProgressCB(
        gpointer bar, gfloat progress, gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_imbr_struct *imbr = (edv_imbr_struct *)data;
        if(imbr == NULL)
            return;

        if(imbr->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        EDVStatusBarProgress(imbr->status_bar, progress, FALSE);

        reenterent = FALSE;
}


/*
 *	Flush data transfer output to disks.
 */
void EDVImbrOPSyncDisks(edv_imbr_struct *imbr)
{
	if(imbr == NULL)
	    return;

        EDVStatusBarMessage(
            imbr->status_bar,
            "Flushing all write buffers to disk...",
            TRUE
        );
        EDVImbrSetBusy(imbr, TRUE);

        EDVDoSyncDisks((edv_core_struct *)imbr->core_ptr);

        EDVImbrSetBusy(imbr, FALSE);
        EDVStatusBarMessage(
            imbr->status_bar,
            "Disk sync done",
            FALSE
        );
        EDVStatusBarProgress(imbr->status_bar, 0.0, FALSE);
}

/*
 *	Write protect toggle.
 */
void EDVImbrOPWriteProtect(edv_imbr_struct *imbr)
{
	gbool write_protect;
	edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

	core_ptr = (edv_core_struct *)imbr->core_ptr;
	if(core_ptr == NULL)
	    return;

	/* Get new write protect state, changing from the previous one. */
	write_protect = EDVCFGItemListGetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_WRITE_PROTECT
	) ? FALSE : TRUE;

	/* Update write protect in the configuration list. */
	EDVCFGItemListSetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_WRITE_PROTECT,
	    write_protect, FALSE
        );

	/* Notify all resources about change in write protect. */
	EDVWriteProtectChangedEmit(core_ptr, write_protect);
}


/*
 *	Close image browser.
 */
void EDVImbrOPClose(edv_imbr_struct *imbr)
{
        if(imbr == NULL)
            return;

	if(imbr->processing)
	    return;

        /* Set current properties of the imbr to the configuration
         * list.
         */
        EDVImbrSyncConfiguration(imbr);

        /* Unmap the image browser. */
        EDVImbrUnmap(imbr);
}

/*
 *      Close all windows.
 */
void EDVImbrOPExit(edv_imbr_struct *imbr)
{
	edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

	core_ptr = (edv_core_struct *)imbr->core_ptr;
	if(core_ptr == NULL)
	    return;

        /* Set current properties of the image browser to the configuration
         * list.
         */
        EDVImbrSyncConfiguration(imbr);

        /* Unmap this image browser. */
        EDVImbrUnmap(imbr);

	/* Mark need_close_all_windows on the core structure to TRUE, this
	 * will be checked during the management timeout. In which case
	 * all windows will be deleted.
	 */
	core_ptr->need_close_all_windows = TRUE;
}


/*
 *      Creates a new file object.
 */
void EDVImbrOPNewFile(edv_imbr_struct *imbr)
{
        gbool yes_to_all = FALSE;
        gint status;
	gchar *new_path = NULL;
	const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

	/* Get current location as the path to create the new object
	 * at.
	 */
	cur_path = EDVImbrCurrentLocation(imbr);
	if(cur_path == NULL)
	{
            DO_FREE_LOCALS
            return;
        }

        EDVImbrSetBusy(imbr, TRUE);

	/* Create new file. */
	status = EDVFCreateFile(
	    core_ptr, cur_path, &new_path,
	    imbr->toplevel,
	    TRUE, TRUE, &yes_to_all
	);

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

	/* Error creating new object? */
	if(status)
	{
	    error_mesg = EDVFCreateGetError();
	    if(error_mesg != NULL)
	    {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
		    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
	    }

            EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
	}
	else
	{
            /* Successfully created new object. */
            struct stat lstat_buf;

            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint thumb_num;
		tlist_struct *tlist = imbr->tlist;


                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new thumb (if any) who's disk object structure
		 * matches the newly added object path.
		 */
		thumb_num = EDVImbrTListFindThumbByPath(imbr, new_path);
                if((thumb_num > -1) && (tlist != NULL))
                {
		    TListFreeze(tlist);
		    TListUnselectAll(tlist);
		    TListSelectThumb(tlist, thumb_num);
		    TListThaw(tlist);
                }
            }

            EDVStatusBarMessage(
		imbr->status_bar,
		"Created new file",
		FALSE
	    );
        }

        EDVImbrSetBusy(imbr, FALSE);

	DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new directory object.
 */
void EDVImbrOPNewDirectory(edv_imbr_struct *imbr)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVImbrCurrentLocation(imbr);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVImbrSetBusy(imbr, TRUE);

        /* Create new directory. */
        status = EDVFCreateDirectory(
            core_ptr, cur_path, &new_path,
            imbr->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint thumb_num;
                tlist_struct *tlist = imbr->tlist;


                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new thumb (if any) who's disk object structure
                 * matches the newly added object path.
                 */
                thumb_num = EDVImbrTListFindThumbByPath(imbr, new_path);
                if((thumb_num > -1) && (tlist != NULL))
                {
                    TListFreeze(tlist);
                    TListUnselectAll(tlist);
                    TListSelectThumb(tlist, thumb_num);
                    TListThaw(tlist);
                }
            }

            EDVStatusBarMessage(
                imbr->status_bar,
                "Created new directory",
                FALSE
            );
        }

        EDVImbrSetBusy(imbr, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new symbolic link object.
 */
void EDVImbrOPNewLink(edv_imbr_struct *imbr)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVImbrCurrentLocation(imbr);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVImbrSetBusy(imbr, TRUE);

        /* Create new symbolic link. */
        status = EDVFCreateLink(
            core_ptr, cur_path, &new_path,
            imbr->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint thumb_num;
                tlist_struct *tlist = imbr->tlist;


                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new thumb (if any) who's disk object structure
                 * matches the newly added object path.
                 */
                thumb_num = EDVImbrTListFindThumbByPath(imbr, new_path);
                if((thumb_num > -1) && (tlist != NULL))
                {
                    TListFreeze(tlist);
                    TListUnselectAll(tlist);
                    TListSelectThumb(tlist, thumb_num);
                    TListThaw(tlist);
                }
            }

            EDVStatusBarMessage(
                imbr->status_bar,
                "Created new symbolic link",
                FALSE
            );
        }

        EDVImbrSetBusy(imbr, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *	Creates a new FIFO pipe object.
 */
void EDVImbrOPNewFifo(edv_imbr_struct *imbr)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVImbrCurrentLocation(imbr);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVImbrSetBusy(imbr, TRUE);

        /* Create new FIFO pipe. */
        status = EDVFCreateFifo(
            core_ptr, cur_path, &new_path,
            imbr->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint thumb_num;
                tlist_struct *tlist = imbr->tlist;


                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new thumb (if any) who's disk object structure
                 * matches the newly added object path.
                 */
                thumb_num = EDVImbrTListFindThumbByPath(imbr, new_path);
                if((thumb_num > -1) && (tlist != NULL))
                {
                    TListFreeze(tlist);
                    TListUnselectAll(tlist);
                    TListSelectThumb(tlist, thumb_num);
                    TListThaw(tlist);
                }
            }

            EDVStatusBarMessage(
                imbr->status_bar,
                "Created new FIFO pipe",
                FALSE
            );
        }

        EDVImbrSetBusy(imbr, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new block device object.
 */
void EDVImbrOPNewDeviceBlock(edv_imbr_struct *imbr)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVImbrCurrentLocation(imbr);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVImbrSetBusy(imbr, TRUE);

        /* Create new block device. */
        status = EDVFCreateDeviceBlock(
            core_ptr, cur_path, &new_path,
            imbr->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint thumb_num;
                tlist_struct *tlist = imbr->tlist;


                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new thumb (if any) who's disk object structure
                 * matches the newly added object path.
                 */
                thumb_num = EDVImbrTListFindThumbByPath(imbr, new_path);
                if((thumb_num > -1) && (tlist != NULL))
                {
                    TListFreeze(tlist);
                    TListUnselectAll(tlist);
                    TListSelectThumb(tlist, thumb_num);
                    TListThaw(tlist);
                }
            }

            EDVStatusBarMessage(
                imbr->status_bar,
                "Created new block device",
                FALSE
            );
        }

        EDVImbrSetBusy(imbr, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new character device object.
 */
void EDVImbrOPNewDeviceCharacter(edv_imbr_struct *imbr)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVImbrCurrentLocation(imbr);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVImbrSetBusy(imbr, TRUE);

        /* Create new character device. */
        status = EDVFCreateDeviceCharacter(
            core_ptr, cur_path, &new_path,
            imbr->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint thumb_num;
                tlist_struct *tlist = imbr->tlist;


                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new thumb (if any) who's disk object structure
                 * matches the newly added object path.
                 */
                thumb_num = EDVImbrTListFindThumbByPath(imbr, new_path);
                if((thumb_num > -1) && (tlist != NULL))
                {
                    TListFreeze(tlist);
                    TListUnselectAll(tlist);
                    TListSelectThumb(tlist, thumb_num);
                    TListThaw(tlist);
                }
            }

            EDVStatusBarMessage(
                imbr->status_bar,
                "Created new character device",
                FALSE
            );
        }

        EDVImbrSetBusy(imbr, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new socket object.
 */
void EDVImbrOPNewSocket(edv_imbr_struct *imbr)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVImbrCurrentLocation(imbr);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVImbrSetBusy(imbr, TRUE);

        /* Create new socket. */
        status = EDVFCreateSocket(
            core_ptr, cur_path, &new_path,
            imbr->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(imbr->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint thumb_num;
                tlist_struct *tlist = imbr->tlist;


                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new thumb (if any) who's disk object structure
                 * matches the newly added object path.
                 */
                thumb_num = EDVImbrTListFindThumbByPath(imbr, new_path);
                if((thumb_num > -1) && (tlist != NULL))
                {
                    TListFreeze(tlist);
                    TListUnselectAll(tlist);
                    TListSelectThumb(tlist, thumb_num);
                    TListThaw(tlist);
                }
            }

            EDVStatusBarMessage(
                imbr->status_bar,
                "Created new socket",
                FALSE
            );
        }

        EDVImbrSetBusy(imbr, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}



/*
 *      Open the selected object on thumbs list.
 */
void EDVImbrOPOpen(edv_imbr_struct *imbr)
{
        gint thumb_num;
	GList *glist;
        tlist_struct *tlist;


        if(imbr == NULL)
            return;

	tlist = imbr->tlist;
	if(tlist == NULL)
	    return;

	glist = tlist->selection_end;
	thumb_num = (glist != NULL) ? (gint)glist->data : -1;
	if(thumb_num > -1)
	    EDVImbrTListDoOpenObject(imbr, thumb_num, 0);
}

/*
 *      `Open with' the selected object on contents clist.
 */
void EDVImbrOPOpenWith(edv_imbr_struct *imbr)
{
        gint thumb_num;
        GList *glist;
        tlist_struct *tlist;


        if(imbr == NULL)
            return;

        tlist = imbr->tlist;
        if(tlist == NULL)
            return;

        glist = tlist->selection_end;
        thumb_num = (glist != NULL) ? (gint)glist->data : -1;
        if(thumb_num > -1)
            EDVImbrTListDoOpenWithObject(imbr, thumb_num);
}


/*
 *	Go to parent directory.
 */
void EDVImbrOPGoToParent(edv_imbr_struct *imbr)
{
	const gchar *cstrptr, *cstrptr2;
	gchar *parent_dir;


	if(imbr == NULL)
	    return;

	cstrptr = EDVImbrCurrentLocation(imbr);
	cstrptr2 = GetParentDir(cstrptr);
	parent_dir = (cstrptr2 != NULL) ? g_strdup(cstrptr2) : NULL;
	if(parent_dir == NULL)
	    return;

        EDVImbrSetBusy(imbr, TRUE);

	EDVImbrSelectPath(imbr, parent_dir);
        EDVImbrUpdateMenus(imbr);

        EDVImbrSetBusy(imbr, FALSE);

	g_free(parent_dir);
}

/*
 *	Mounts or unmounts the selected node on the directory ctree.
 */
void EDVImbrOPMount(edv_imbr_struct *imbr)
{
	gbool original_mount_state;
	gint status, dev_num;
	edv_device_struct *dev_ptr;
	edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

	core_ptr = (edv_core_struct *)imbr->core_ptr;
	if(core_ptr == NULL)
	    return;

	/* Get number of last selected device index (if any). */
	dev_num = imbr->selected_dev_num;
	if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
	    dev_ptr = core_ptr->device[dev_num];
	else
	    dev_ptr = NULL;
	if(dev_ptr == NULL)
	    return;

	/* Record original mount state. */
	original_mount_state = dev_ptr->is_mounted;


	EDVImbrSetBusy(imbr, TRUE);


	/* Unmount or mount? */
	if(dev_ptr->is_mounted)
	    status = EDVMountDoUnmount(dev_ptr);
	else
	    status = EDVMountDoMount(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


        EDVImbrSetBusy(imbr, FALSE);


	/* Mount error? */
	if(status)
	{
	    const gchar *last_error = EDVMountGetError();
	    if(last_error != NULL)
	    {
		CDialogSetTransientFor(imbr->toplevel);
		CDialogGetResponse(
		    original_mount_state ?
			"Unmount Failed" : "Mount Failed",
		    last_error,
		    NULL,
		    CDIALOG_ICON_ERROR,
		    CDIALOG_BTNFLAG_OK,
		    CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
	    }
	}
	else
	{
	    /* Report mount signal to all of endeavour's resources. */
	    EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
	}
}

/*
 *      Ejects the media from the selected device.
 *
 *	Device will be unmounted first as needed.
 */
void EDVImbrOPEject(edv_imbr_struct *imbr)
{
        gbool original_mount_state;
        gint status, dev_num;
        edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get number of last selected device index (if any). */
        dev_num = imbr->selected_dev_num;
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
            return;

        /* Record original mount state. */
        original_mount_state = dev_ptr->is_mounted;


        EDVImbrSetBusy(imbr, TRUE);


        /* Need to unmount first? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
        /* So now eject. */
        status = EDVMountDoEject(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );

        EDVImbrSetBusy(imbr, FALSE);


        /* Eject error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(imbr->toplevel);
                CDialogGetResponse(
                    "Eject Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
	    /* Report eject (unmount) signal to all of endeavour's
	     * resources.
	     */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
        }
}


/*
 *      Returns a list of selected disk object structures on the given
 *      image browser.
 *
 *      Only the returned pointer array (not each object) needs to be
 *      deallocated by the calling function.
 */
static edv_object_struct **EDVImbrGetSelectedObjects(
        edv_imbr_struct *imbr, gint *total
)
{
        edv_object_struct **sel_object = NULL, *obj;
        gint total_sel_objects = 0;


        if(total != NULL)
            *total = 0;

        if(imbr == NULL)
            return(sel_object);

        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */

        if(1)
        {
            gint i, thumb_num;
            GList *glist;
            tlist_struct *tlist = imbr->tlist;

            glist = (tlist != NULL) ? tlist->selection : NULL;
            while(glist != NULL)
            {
                thumb_num = (gint)glist->data;
                obj = (edv_object_struct *)TListGetThumbData(tlist, thumb_num);
                if(obj != NULL)
                {
                    i = total_sel_objects;
                    total_sel_objects = i + 1;
                    sel_object = (edv_object_struct **)g_realloc(
                        sel_object,
                        total_sel_objects * sizeof(edv_object_struct *)
                    );
                    if(sel_object == NULL)
                    {
                        total_sel_objects = 0;
                        break;
                    }

                    sel_object[i] = obj;
                }

                glist = glist->next;
            }
        }

        /* Update returns. */
        if(total != NULL)
            *total = total_sel_objects;

        return(sel_object);
}

/*
 *	Queries user to move selected disk objects.
 */
void EDVImbrOPMove(edv_imbr_struct *imbr)
{
	edv_object_struct **sel_object;
	gint total_sel_objects;
        edv_core_struct *core_ptr;
	edv_fopdialog_struct *d;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

	/* Get pointer to file operation dialog and create it as needed. */
	d = imbr->fopdialog;
	if(d == NULL)
	    imbr->fopdialog = d = EDVFOPDialogNew(core_ptr);
	if(d == NULL)
	    return;


        /* Sync data on image browser so as to ensure we have the most up
	 * to date information to work with.
         */
        EDVImbrSyncData(imbr);


	/* Create a list of disk objects, each pointer in the array will
	 * reffer to a shared object structure pointer so it should not
	 * be deallocated.
	 */
	sel_object = EDVImbrGetSelectedObjects(
	    imbr, &total_sel_objects
	);
	if(sel_object == NULL)
	    return;

	/* Map dialog. */
	EDVFOPDialogMapValues(
	    d, EDV_FOPDIALOG_OP_MOVE,
	    sel_object, total_sel_objects,
	    EDVImbrCurrentLocation(imbr),
	    imbr->toplevel
	);

	/* Deallocate selected disk objects pointer array but not each
	 * structure since they are shared.
	 */
	g_free(sel_object);
	sel_object = NULL;
	total_sel_objects = 0;
}

/*
 *      Queries user to move selected disk objects.
 */
void EDVImbrOPCopy(edv_imbr_struct *imbr)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = imbr->fopdialog;
        if(d == NULL)
            imbr->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;


        /* Sync data on image browser so as to ensure we have the most up
	 * to date information to work with.
         */
        EDVImbrSyncData(imbr);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         */
        sel_object = EDVImbrGetSelectedObjects(
            imbr, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog. */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_COPY,
            sel_object, total_sel_objects,
            EDVImbrCurrentLocation(imbr),
            imbr->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *	Queries user to link selected disk objects.
 */
void EDVImbrOPLink(edv_imbr_struct *imbr)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = imbr->fopdialog;
        if(d == NULL)
            imbr->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;


        /* Sync data on image browser so as to ensure we have the most up
	 * to date information to work with.
         */
        EDVImbrSyncData(imbr);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         */
        sel_object = EDVImbrGetSelectedObjects(
            imbr, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog.
         *
         * Note that linking only allows one selected object, so always
         * report total as no more than 1.
         */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_LINK,
            sel_object, MIN(total_sel_objects, 1),
            EDVImbrCurrentLocation(imbr),
            imbr->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *	Rename object callback.
 */
void EDVImbrOPRename(edv_imbr_struct *imbr)
{
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

/* This will actually be checked again when the rename fprompt map call
 * but we check it first initially anyways.
 */
        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

	if(1)
	{
            gint thumb_num;
            GList *glist;
            tlist_struct *tlist = imbr->tlist;

	    glist = (tlist != NULL) ? tlist->selection_end : NULL;
	    thumb_num = (glist != NULL) ? (gint)glist->data : -1;
	    if(thumb_num > -1)
		EDVImbrTListDoFPromptRename(imbr, thumb_num);
	}
}

/*
 *      Queries user to change permissions of selected disk objects.
 */
void EDVImbrOPChMod(edv_imbr_struct *imbr)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = imbr->fopdialog;
        if(d == NULL)
            imbr->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;

        /* Sync data on image browser so as to ensure we have the most up
         * to date information to work with.
         */
        EDVImbrSyncData(imbr);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         */
        sel_object = EDVImbrGetSelectedObjects(
            imbr, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog. */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_CHMOD,
            sel_object, total_sel_objects,
            EDVImbrCurrentLocation(imbr),
            imbr->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *      Queries user to chown selected disk objects.
 */
void EDVImbrOPChown(edv_imbr_struct *imbr)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = imbr->fopdialog;
        if(d == NULL)
            imbr->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;

        /* Sync data on image browser so as to ensure we have the most up
         * to date information to work with.
         */
        EDVImbrSyncData(imbr);

        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         */
        sel_object = EDVImbrGetSelectedObjects(
            imbr, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog. */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_CHOWN,
            sel_object, total_sel_objects,
            EDVImbrCurrentLocation(imbr),
            imbr->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *	Delete object callback.
 */
void EDVImbrOPDelete(edv_imbr_struct *imbr)
{
	gbool yes_to_all = FALSE;
	gint i, status;
	const gchar *path_ptr;
	gchar **object_path = NULL;
	gint total_object_paths = 0, objects_deleted = 0;
	guint *index;
	gint total_indexes;
	const gchar *error_mesg;
        edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

#define DO_FREE_LOCALS	\
{ \
 /* Deallocate list of disk object paths. */ \
 for(i = 0; i < total_object_paths; i++) \
  g_free(object_path[i]); \
 g_free(object_path); \
 object_path = NULL; \
 total_object_paths = 0; \
}

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
	{
	    DO_FREE_LOCALS
            return;
	}

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
	{
	    DO_FREE_LOCALS
            return;
	}


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         */
        if(1)
        {
            gint i, thumb_num;
            GList *glist;
            tlist_struct *tlist = imbr->tlist;
	    edv_object_struct *obj;


            glist = (tlist != NULL) ? tlist->selection : NULL;
            while(glist != NULL)
            {
                thumb_num = (gint)glist->data;
                obj = (edv_object_struct *)TListGetThumbData(tlist, thumb_num);
                if((obj != NULL) ? (obj->full_path != NULL) : FALSE)
                {
                    i = total_object_paths;
                    total_object_paths = i + 1;
                    object_path = (gchar **)g_realloc(
                        object_path,
                        total_object_paths * sizeof(gchar *)
                    );
                    if(object_path == NULL)
                    {
                        total_object_paths = 0;
                        break;
                    }

                    object_path[i] = g_strdup(obj->full_path);
                }

                glist = glist->next;
            }
        }

	/* No disk objects selected? */
	if(total_object_paths <= 0)
	{
	    DO_FREE_LOCALS
	    return;
	}

        /* Confirm delete. */
        status = EDVConfirmDelete(
            core_ptr, imbr->toplevel,
            (total_object_paths == 1) ? object_path[0] : NULL,
            total_object_paths
        );
        switch(status)
        {
          case CDIALOG_RESPONSE_YES_TO_ALL:
            yes_to_all = TRUE;
          case CDIALOG_RESPONSE_YES:
          case CDIALOG_RESPONSE_OK:
            break;

          default:
            DO_FREE_LOCALS
            return;
            break;
        }


	EDVImbrSetBusy(imbr, TRUE);

	/* Iterate through list of disk object paths. */
	status = 0;
	for(i = 0; i < total_object_paths; i++)
	{
	    path_ptr = object_path[i];
	    if(path_ptr == NULL)
		continue;

	    index = NULL;
	    total_indexes = 0;

	    /* Delete disk object. */
	    status = EDVRecBinFOPDelete(
		core_ptr, path_ptr,
		&index, &total_indexes,
		imbr->toplevel,
		TRUE, TRUE, &yes_to_all
	    );

	    /* Get error message (if any) that might have occured in the
	     * above operation.
	     */
	    error_mesg = EDVRecBinFOPGetError();
	    if(error_mesg != NULL)
	    {
		CDialogSetTransientFor(imbr->toplevel);
		CDialogGetResponse(
		    "Operation Error",
		    error_mesg,
		    NULL,
		    CDIALOG_ICON_ERROR,
		    CDIALOG_BTNFLAG_OK,
		    CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
	    }

	    /* Object was delected successfully? */
	    if((index != NULL) && !status)
	    {
		gint n;
		struct stat lstat_buf;


                /* Report recycle object added for all non-zero indexes. */
                for(n = 0; n < total_indexes; n++)
                {
                    if(index[n] != 0)
                        EDVRecycledObjectAddedEmit(core_ptr, index[n]);
                }

                /* Check if disk object no longer exists. */
                if(lstat(path_ptr, &lstat_buf))
		{
		    /* Report disk object removed. */
                    EDVObjectRemovedEmit(core_ptr, path_ptr);
		}

		/* Increment number of disk objects deleted. */
		objects_deleted += total_indexes;
	    }

	    /* Deallocate returned recycle objects index array. */
	    g_free(index);
	    index = NULL;
	    total_indexes = 0;

	    /* Error occured (not 0) and it was not a user `no' or
	     * `not available' (-5) response?
	     */
	    if(status && (status != -5))
	    {
		/* Skip rest of the disk object paths due to error. */
		break;
	    }
	}

	/* Update status bar. */
	if(1)
	{
            gchar *buf;

            switch(status)
            {
              case 0: case -5:
                buf = g_strdup_printf(
                    "Deleted %i object%s",
                    objects_deleted,
                    (objects_deleted == 1) ? "" : "s"
                );
                break;

              case -4:  /* Cancel. */
                buf = g_strdup_printf(
                    "Delete operation canceled"
                );
                break;

              default:  /* Error. */
                buf = g_strdup_printf(
                    "Unable to delete object%s",
                    (total_object_paths == 1) ? "" : "s"
                );
                break;
            }
	    EDVStatusBarMessage(imbr->status_bar, buf, FALSE);
	    g_free(buf);
	}

        EDVImbrSetBusy(imbr, FALSE);


	/* Unmap progress dialog, it may have been mapped if any
	 * operations occured in the above loop.
	 */
	ProgressDialogBreakQuery(TRUE);
	ProgressDialogSetTransientFor(NULL);


	DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *	Select all callback.
 */
void EDVImbrOPSelectAll(edv_imbr_struct *imbr)
{
        edv_core_struct *core_ptr;
	tlist_struct *tlist;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

	tlist = imbr->tlist;
        if(tlist == NULL)
            return;

        EDVImbrSetBusy(imbr, TRUE);

	/* Select all thumbs. */
        TListFreeze(tlist);
	TListSelectAll(tlist);
	TListThaw(tlist);

	/* Assume highest thumb index as the last selected thumb. */
        imbr->tlist_selected_thumb = tlist->total_thumbs - 1;

        EDVStatusBarMessage(
            imbr->status_bar, "All objects selected", FALSE
        );

        EDVImbrSetBusy(imbr, FALSE);

	EDVImbrUpdateMenus(imbr);
}

/*
 *	Unselect all callback.
 */
void EDVImbrOPUnselectAll(edv_imbr_struct *imbr)
{
	edv_core_struct *core_ptr;
        tlist_struct *tlist;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        tlist = imbr->tlist;
        if(tlist == NULL)
            return;

        EDVImbrSetBusy(imbr, TRUE);

        /* Unselect all thumbs. */
        TListFreeze(tlist);
	TListUnselectAll(tlist);
        TListThaw(tlist);

        /* Mark that no thumb is selected. */
        imbr->tlist_selected_thumb = -1;

	EDVStatusBarMessage(
	    imbr->status_bar, "All objects unselected", FALSE
	);

	EDVImbrSetBusy(imbr, FALSE);

	EDVImbrUpdateMenus(imbr);
}

/*
 *      Invert selection callback.
 */
void EDVImbrOPInvertSelection(edv_imbr_struct *imbr)
{
        edv_core_struct *core_ptr;
        GList *glist, *selection;
        gint thumb, total_thumbs;
	tlist_struct *tlist;


        if(imbr == NULL)
            return;

        core_ptr = (edv_core_struct *)imbr->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get thumbs list. */
        tlist = imbr->tlist;
        if(tlist == NULL)
            return;

        EDVImbrSetBusy(imbr, TRUE);
        TListFreeze(tlist);

        /* Get copy of selected rows list from tlist. */
        selection = (tlist->selection != NULL) ?
            g_list_copy(tlist->selection) : NULL;

        for(thumb = 0, total_thumbs = tlist->total_thumbs;
            thumb < total_thumbs;
            thumb++
        )
        {
            for(glist = selection;
                glist != NULL;
                glist = glist->next
            )
            {
                if(thumb == (gint)glist->data)
                {
                    TListUnselectThumb(tlist, thumb);
                    break;
                }
            }
            /* Thumb not selected? */
            if(glist == NULL)
                TListSelectThumb(tlist, thumb);
        }

        g_list_free(selection);

        TListThaw(tlist);
        EDVStatusBarMessage(
            imbr->status_bar, "Selection inverted", FALSE
        );
        EDVImbrSetBusy(imbr, FALSE);
}

/*
 *      Object properties callback.
 */
void EDVImbrOPProperties(edv_imbr_struct *imbr)
{
	edv_object_struct *obj = NULL;


        if(imbr == NULL)
            return;

        /* Sync data on image browser so as to ensure we have the most up
	 * to date information to work with.
         */
        EDVImbrSyncData(imbr);

	/* Get disk object structure from last selected thumb. */
	obj = (edv_object_struct *)TListGetThumbData(
	    imbr->tlist, imbr->tlist_selected_thumb
	);
	if(obj != NULL)
	{
	    EDVDoPropWin(
		(edv_core_struct *)imbr->core_ptr,
		obj,
		imbr->toplevel
	    );
	}
}


/*
 *      Copy location of selected objects to dde as space separated list
 *      of absolute paths.
 */
void EDVImbrOPCopyPath(edv_imbr_struct *imbr)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;


        if(imbr == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVImbrSyncData(imbr);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVImbrGetSelectedObjects(
            imbr, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Copy the paths of the selected objects to the dde. */
        EDVCopyDiskObjectsToDDEPath(
            (edv_core_struct *)imbr->core_ptr,
            sel_object, total_sel_objects
        );


        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *      Copy location of selected objects to dde as space separated list
 *      of absolute urls.
 */
void EDVImbrOPCopyURL(edv_imbr_struct *imbr)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;


        if(imbr == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVImbrSyncData(imbr);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVImbrGetSelectedObjects(
            imbr, &total_sel_objects
        );
        if(sel_object == NULL)
            return;


        /* Copy the urls of the selected objects to the dde. */
        EDVCopyDiskObjectsToDDEURL(
            (edv_core_struct *)imbr->core_ptr,
            sel_object, total_sel_objects
        );


        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}


/*
 *	Stop callback.
 */
void EDVImbrOpStop(edv_imbr_struct *imbr)
{
	if(imbr == NULL)
	    return;

	imbr->stop_count++;
}

/*
 *	Continue callback.
 */
void EDVImbrOpContinue(edv_imbr_struct *imbr)
{
        if(imbr == NULL)
            return;

	/* Reset loading process timeout callback and initialize loading
	 * values.
	 */
	EDVImbrQueueLoadingProcess(imbr);

        EDVImbrUpdateMenus(imbr);
}

/*
 *      Refresh callback.
 */
void EDVImbrOPRefresh(edv_imbr_struct *imbr)
{
	const gchar *cstrptr;
	gchar *cur_path;
	tlist_struct *tlist;


        if(imbr == NULL)
            return;

	/* Get current location path and make a copy of it. */
	cstrptr = EDVImbrCurrentLocation(imbr);
	cur_path = (cstrptr != NULL) ? g_strdup(cstrptr) : NULL;


	EDVImbrSetBusy(imbr, TRUE);
        GUIBlockInput(imbr->toplevel, TRUE);


	/* Update thumbs list by reselecting its path. */
	tlist = imbr->tlist;
	if(tlist != NULL)
	{
	    GtkAdjustment *hadj = tlist->hadj, *vadj = tlist->vadj;
	    gfloat last_hpos = 0.0, last_vpos = 0.0;


	    /* Record last scroll position. */
	    if(hadj != NULL)
		last_hpos = hadj->value;
	    if(vadj != NULL)
		last_vpos = vadj->value;

            /* Reget listing and initialize values for the loading
	     * process. The entire list should be fully obtained after
	     * this call so it is possible to scroll to the old position.
	     */
	    EDVImbrSelectPath(imbr, cur_path);

	    /* Scroll back to previous location. */
	    if(hadj != NULL)
	    {
		hadj->value = last_hpos;
		if(hadj->value > (hadj->upper - hadj->page_size))
		    hadj->value = hadj->upper - hadj->page_size;
		if(hadj->value < hadj->lower)
		    hadj->value = hadj->lower;
		gtk_signal_emit_by_name(GTK_OBJECT(hadj), "value_changed");
	    }
            if(vadj != NULL)
            {
                vadj->value = last_vpos;
                if(vadj->value > (vadj->upper - vadj->page_size))
                    vadj->value = vadj->upper - vadj->page_size;
                if(vadj->value < vadj->lower)
                    vadj->value = vadj->lower;
                gtk_signal_emit_by_name(GTK_OBJECT(vadj), "value_changed");
            }
	}


        GUIBlockInput(imbr->toplevel, FALSE);
        EDVImbrSetBusy(imbr, FALSE);


        EDVImbrUpdateMenus(imbr);

        EDVStatusBarMessage(
            imbr->status_bar, "Refreshed contents listing", FALSE
        );


	/* Deallocate copy of current location path. */
	g_free(cur_path);
	cur_path = NULL;
}

/*
 *      Refresh all callback.
 */
void EDVImbrOPRefreshAll(edv_imbr_struct *imbr)
{
        const gchar *cstrptr;
        gchar *cur_path;
	tlist_struct *tlist;
	edv_core_struct *core_ptr;


        if(imbr == NULL)
            return;

	core_ptr = (edv_core_struct *)imbr->core_ptr;
	if(core_ptr == NULL)
	    return;


        /* Get current location path and make a copy of it. */
        cstrptr = EDVImbrCurrentLocation(imbr);
        cur_path = (cstrptr != NULL) ? g_strdup(cstrptr) : NULL;


        EDVImbrSetBusy(imbr, TRUE);
        GUIBlockInput(imbr->toplevel, TRUE);


        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


        /* Update thumbs list by reselecting its path. */
        tlist = imbr->tlist;
        if(tlist != NULL)
        {
            GtkAdjustment *hadj = tlist->hadj, *vadj = tlist->vadj;
            gfloat last_hpos = 0.0, last_vpos = 0.0;


            /* Record last scroll position. */
            if(hadj != NULL)
                last_hpos = hadj->value;
            if(vadj != NULL)
                last_vpos = vadj->value;

            /* Reget listing and initialize values for the loading
             * process. The entire list should be fully obtained after
             * this call so it is possible to scroll to the old position.
             */
            EDVImbrSelectPath(imbr, cur_path);

            /* Scroll back to previous location. */
            if(hadj != NULL)
            {
                hadj->value = last_hpos;
                if(hadj->value > (hadj->upper - hadj->page_size))
                    hadj->value = hadj->upper - hadj->page_size;
                if(hadj->value < hadj->lower)
                    hadj->value = hadj->lower;
                gtk_signal_emit_by_name(GTK_OBJECT(hadj), "value_changed");
            }
            if(vadj != NULL)
            {
                vadj->value = last_vpos;
                if(vadj->value > (vadj->upper - vadj->page_size))
                    vadj->value = vadj->upper - vadj->page_size;
                if(vadj->value < vadj->lower)
                    vadj->value = vadj->lower;
                gtk_signal_emit_by_name(GTK_OBJECT(vadj), "value_changed");
            }
        }


	GUIBlockInput(imbr->toplevel, FALSE);
        EDVImbrSetBusy(imbr, FALSE);


        EDVImbrUpdateMenus(imbr);

        EDVStatusBarMessage(
            imbr->status_bar, "Refreshed all listings", FALSE
        );


        /* Deallocate copy of current location path. */
        g_free(cur_path);
        cur_path = NULL;
}


/*
 *	Download callback.
 */
void EDVImbrOPDownload(edv_imbr_struct *imbr)
{
        if(imbr == NULL)
            return;

        EDVDoInternetDownloadObject(
            (edv_core_struct *)imbr->core_ptr,
            NULL,
            EDVImbrCurrentLocation(imbr),
            imbr->toplevel
        );
}


