/*
 *	Recovers the recycled object specified by the index from the
 *	first argument of the command line.  Recovers it to the location
 *	specified by the second argument from the command line.
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	if(argc >= 3)
	{
	    guint index = atoi(argv[1]);
            const gchar *path = argv[2];

	    /* Recover the recycled object specified by index to the
	     * location specified by path.
	     *
             * Note that notify is set to TRUE, which means that if
             * Endeavour2 is running then it will be aware of this
             * incident and update it's values to reflect the change.
             *
             * We skip the callback functions (last two arguments) by
             * setting them both NULL. This means that we are not
             * interested in the progress of this operation.
             */
	    if(EDVRecover(
		ctx, index, path, TRUE, NULL, NULL
	    ))
		printf("#%i: %s.\n", index, EDVRecycleGetError(ctx));
	    else
		printf("#%i: Recovered to `%s'.\n", index, path);
	}
	else
	{
	    printf("%s: <index> <recover_to_file>\n", argv[0]);
	}

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
