#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_IMLIB
# include <Imlib.h>
#endif
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkrgb.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "cdialog.h"
#include "clipboard.h"
#include "csd.h"
#include "fsd.h"
#include "fb.h"
#include "progressdialog.h"
#include "pdialog.h"
#include "fprompt.h"
#include "pulist.h"

#include "edvtypes.h"
#include "edvobj.h"
#include "edvrecbin.h"
#include "edvdate.h"
#include "edvhistory.h"
#include "edvid.h"
#include "edvcfg.h"
#include "edvcfgfio.h"
#include "edvcursor.h"
#include "edvobj.h"
#include "edvdevices.h"
#include "edvdevicesfio.h"
#include "edvmimetypes.h"
#include "edvmimetypesfio.h"
#include "browser.h"
#include "recbin.h"
#include "recbindeskicon.h"
#include "findwin.h"
#include "propwin.h"
#include "historywin.h"
#include "rundlg.h"
#include "optwin.h"
#include "endeavour.h"
#include "edvcb.h"
#include "edvop.h"
#include "edvinterps.h"
#include "edvutils.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_file_20x20.xpm"
#include "images/icon_file_32x32.xpm"
#include "images/icon_executable_20x20.xpm"
#include "images/icon_executable_32x32.xpm"
#include "images/icon_folder_opened_20x20.xpm"
#include "images/icon_folder_opened_32x32.xpm"
#include "images/icon_folder_closed_20x20.xpm"
#include "images/icon_folder_closed_32x32.xpm"
#include "images/icon_link2_20x20.xpm"
#include "images/icon_link2_32x32.xpm"
#include "images/icon_device_block_20x20.xpm"
#include "images/icon_device_block_32x32.xpm"
#include "images/icon_device_character_20x20.xpm"
#include "images/icon_device_character_32x32.xpm"
#include "images/icon_pipe_20x20.xpm"
#include "images/icon_pipe_32x32.xpm"
#include "images/icon_socket_20x20.xpm"
#include "images/icon_socket_32x32.xpm"


/* This is used in EDVNew for dynamic allocation of
 * a char array to get the hostname from gethostname().
 * This WILL be truncated by one to ensure no messy
 * segfaults (the last character is overwritten with '\0'),
 * so the number of characters that will actually be
 * allowed is MAX_HOSTNAME_LEN - 1.
 */
#define MAX_HOSTNAME_LEN 64


#ifdef HAVE_IMLIB
gpointer imlib_handle;
#endif	/* HAVE_IMLIB */

edv_core_struct *edv_core = NULL;


static void EDVDoCreateStandardConfiguration(edv_core_struct *core_ptr);
static void EDVDoCreateStandardCursors(edv_core_struct *core_ptr);
static void EDVDoCreateStandardMimeTypes(edv_core_struct *core_ptr);
static void EDVDoCreateIDPULists(edv_core_struct *core_ptr);

edv_core_struct *EDVNew(gint argc, gchar *argv[], gint *err_rtn);
void EDVDelete(edv_core_struct *core_ptr, gbool save_config);


/*
 *      Sets configuration values on the given core structure to their
 *	default values.
 */
static void EDVDoCreateStandardConfiguration(edv_core_struct *core_ptr)
{
	const gchar *cstrptr;
	edv_intlist_struct intlist;
        const edv_cfg_item_struct src_cfg_list[] = EDV_CONFIGURATION_LIST;

	gchar data_local[PATH_MAX];
	gchar data_global[PATH_MAX];
	gchar startup_dir[PATH_MAX];


	/* Copy the source configuration item list to the target
	 * configuration item list on the core structure.
	 */
	core_ptr->cfg_list = EDVCFGItemListCopyList(src_cfg_list);
	if(core_ptr->cfg_list == NULL)
	    return;


	/* Begin setting default configuration values. */

	/* Version. */
        EDVCFGItemListSetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_VERSION_MAJOR,
	    PROG_VERSION_MAJOR, FALSE
	);
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_VERSION_MINOR,
            PROG_VERSION_MINOR, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_VERSION_RELEASE,
            PROG_VERSION_RELEASE, FALSE
        );

	/* Directories. */
	*startup_dir = '\0';
	getcwd(startup_dir, PATH_MAX);
	EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_DIR_START_UP,
            (*startup_dir != '\0') ? startup_dir : "/",
	    FALSE
        );

	strncpy(
	    data_global,
	    EDV_DEF_GLOBAL_DATA_DIR,
	    PATH_MAX
	);
	data_global[PATH_MAX - 1] = '\0';
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_DIR_GLOBAL,
            data_global, FALSE
        );

	/* Get local data directory by using the directory specified
	 * in the environment variable HOME.
	 */
	cstrptr = getenv("HOME");
	if(cstrptr != NULL)
	    cstrptr = PrefixPaths(cstrptr, EDV_DEF_LOCAL_DATA_DIR);
	strncpy(
	    data_local,
	    (cstrptr != NULL) ? cstrptr : EDV_DEF_GLOBAL_DATA_DIR,
	    PATH_MAX
	);
	data_local[PATH_MAX - 1] = '\0';
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_DIR_LOCAL,
            data_local, FALSE
        );

        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_DIR_TMP,
            "/tmp", FALSE
        );


	/* File paths. */
	/* Recycled objects index file. */
	cstrptr = PrefixPaths(data_local, EDV_DEF_RECYCLED_INDEX_FILE);
	EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_RECYCLED_INDEX,
            (cstrptr != NULL) ?
                cstrptr : "/nosuchfile",
            FALSE
        );
	/* MIME Types file. */
	cstrptr = PrefixPaths(data_local, EDV_DEF_MIMETYPES_FILE);
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_MIME_TYPES,
	    (cstrptr != NULL) ?
                cstrptr : EDV_DEF_GLOBAL_DATA_DIR "/" EDV_DEF_MIMETYPES_FILE,
	    FALSE
        );
	/* MIME Types file (global). */
        cstrptr = PrefixPaths(data_global, EDV_DEF_MIMETYPES_FILE);
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL,
            (cstrptr != NULL) ?
                cstrptr : EDV_DEF_GLOBAL_DATA_DIR "/" EDV_DEF_MIMETYPES_FILE,
	    FALSE
        );
	/* Devices file. */
        cstrptr = PrefixPaths(data_local, EDV_DEF_DEVICES_FILE);
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_DEVICES,
            (cstrptr != NULL) ?
                cstrptr : EDV_DEF_GLOBAL_DATA_DIR "/" EDV_DEF_DEVICES_FILE,
            FALSE
        );
        /* Run dialog run history file. */
        cstrptr = PrefixPaths(data_local, EDV_DEF_RUNHISTORY_FILE);
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_RUNDLG_HISTORY,
            (cstrptr != NULL) ?
                cstrptr : EDV_DEF_GLOBAL_DATA_DIR "/" EDV_DEF_RUNHISTORY_FILE,
            FALSE
        );


	/* Programs. */
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_TERMINAL,
            "/usr/X11R6/bin/xterm", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_TERMINAL_RUN,
            "/usr/X11R6/bin/xterm -e", FALSE
        );

        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_ARJ,
            "/usr/bin/arj", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_RPM,
	    "/bin/rpm", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_TAR,
            "/bin/tar", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_ZIP,
            "/usr/bin/zip", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_UNZIP,
            "/usr/bin/unzip", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_COMPRESS,
            "/usr/bin/compress", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_UNCOMPRESS,
            "/usr/bin/uncompress", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_GZIP,
            "/bin/gzip", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_GUNZIP,
            "/bin/gunzip", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_BZIP2,
            "/bin/bzip2", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_BUNZIP2,
            "/bin/bunzip2", FALSE
        );
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_PROG_NET_DOWNLOAD,
            EDV_DEF_NET_DOWNLOAD_PROGRAM, FALSE
        );

	/* Master write protect. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_WRITE_PROTECT,
            TRUE, FALSE
        );

	/* Record start up directory (instead of fixed user set). */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECORD_START_UP_DIR,
	    TRUE, FALSE
	);

        /* Right click menus also select. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS,
            TRUE, FALSE
        );

	/* MIME type no deliminator matching. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_MIMETYPE_NODELIM_MATCH,
            FALSE, FALSE
        );

	/* Date relativity. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_DATE_RELATIVITY,
            EDV_DATE_RELATIVITY_ABSOLUTE, FALSE
        );
	/* Date format (see strftime). */
	EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_DATE_FORMAT,
	    "%b %d %H:%M", FALSE
	);

	/* Image quality (0 to 2). */
	EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMAGE_QUALITY,
            1, FALSE
        );

	/* Lists use double buffer. */
	EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_LISTS_DOUBLE_BUFFER,
            TRUE, FALSE
        );

	/* Lists animate updates. */
	EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_LISTS_ANIMATE_UPDATES,
            TRUE, FALSE
        );

        /* Show tooltips. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_SHOW_TOOLTIPS,
            TRUE, FALSE
        );

        /* Confirm copy. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_COPY,
	    TRUE, FALSE
        );
        /* Confirm move. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_MOVE,
            TRUE, FALSE
        );
        /* Confirm link. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_LINK,
            TRUE, FALSE
        );
        /* Confirm delete. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_DELETE,
            TRUE, FALSE
        );
        /* Confirm add to archive. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD,
            TRUE, FALSE
        );
        /* Confirm extract from archive. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT,
            TRUE, FALSE
        );
        /* Confirm delete from archive. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE,
            TRUE, FALSE
        );
        /* Confirm recover. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_RECOVER,
            TRUE, FALSE
        );
        /* Confirm purge from recycle bin. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_PURGE,
            TRUE, FALSE
        );
        /* Confirm downloads. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_CONFIRM_DOWNLOAD,
            TRUE, FALSE
        );

	/* History events max. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_HISTORY_EVENTS_MAX,
	    20, FALSE
        );

        /* Recycle bin size warn (in bytes). */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_SIZE_WARN,
            10000000, FALSE
        );

	/* Delete method. */
	EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_DELETE_METHOD,
	    EDV_DELETE_METHOD_MOVE_TO_RECBIN, FALSE
	);

        /* Add to archive: Compression level (value from 0 to 100). */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION,
            50, FALSE
        );

	/* Add to archive: Recursivly. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE,
            TRUE, FALSE
        );

	/* Add to archive: Dereference links. */
	EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS,
            FALSE, FALSE
        );

	/* Extract from archive: Preserve archive directory paths. */
	EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR,
            TRUE, FALSE
        );


        /* Startup with file browser. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_BROWSER,
            TRUE, FALSE
        );
        /* Startup with image browser. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_IMBR,
            FALSE, FALSE
        );
        /* Startup with archiver. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_ARCHIVER,
            FALSE, FALSE
        );
        /* Startup with recycle bin. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_RECBIN,
            FALSE, FALSE
        );

	/* Browser geometry. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_X,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_Y,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_WIDTH,
            EDV_DEF_BROWSER_WIDTH, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_HEIGHT,
            EDV_DEF_BROWSER_HEIGHT, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_PANED_POSITION,
            EDV_DEF_BROWSER_PANED_POSITION, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR,
            TRUE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR,
            TRUE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR,
            TRUE, FALSE
        );

	/* Tool bar. */
	intlist.total = 15;
	intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
	if(intlist.i != NULL)
	{
	    intlist.i[0] = EDV_BROWSER_OP_NEW_FILE;
	    intlist.i[1] = EDV_BROWSER_OP_NEW_DIRECTORY;
	    intlist.i[2] = EDV_BROWSER_OP_NEW_LINK;
	    intlist.i[3] = EDV_BROWSER_OP_SEPARATOR;
            intlist.i[4] = EDV_BROWSER_OP_MOVE;
            intlist.i[5] = EDV_BROWSER_OP_COPY;
            intlist.i[6] = EDV_BROWSER_OP_RENAME;
            intlist.i[7] = EDV_BROWSER_OP_DELETE;
            intlist.i[8] = EDV_BROWSER_OP_PROPERTIES;
            intlist.i[9] = EDV_BROWSER_OP_SEPARATOR;
            intlist.i[10] = EDV_BROWSER_OP_REFRESH;
            intlist.i[11] = EDV_BROWSER_OP_SEPARATOR;
            intlist.i[12] = EDV_BROWSER_OP_NEW_BROWSER;
            intlist.i[13] = EDV_BROWSER_OP_NEW_IMBR;
            intlist.i[14] = EDV_BROWSER_OP_RECYCLE_BIN;
	}
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TOOL_BAR,
            &intlist, FALSE
        );
	g_free(intlist.i);
	intlist.i = NULL;

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY,
            TOOLBAR_DISPLAY_PICTURES_AND_TEXT, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF,
            TOOLBAR_RELIEF_NONE, FALSE
        );

	EDVCFGItemListSetValueI(
            core_ptr->cfg_list,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE,
	    FALSE, FALSE
	);
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list,
	    EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS,
            FALSE, FALSE
        );

	/* Browser contents column reference numbers. */
        intlist.total = 9;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[0] = EDV_BROWSER_COLUMN_TYPE_NAME;
            intlist.i[1] = EDV_BROWSER_COLUMN_TYPE_SIZE;
            intlist.i[2] = EDV_BROWSER_COLUMN_TYPE_TYPE;
            intlist.i[3] = EDV_BROWSER_COLUMN_TYPE_PERMISSIONS;
            intlist.i[4] = EDV_BROWSER_COLUMN_TYPE_OWNER;
            intlist.i[5] = EDV_BROWSER_COLUMN_TYPE_GROUP;
            intlist.i[6] = EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED;
            intlist.i[7] = EDV_BROWSER_COLUMN_TYPE_HARD_LINKS;
            intlist.i[8] = EDV_BROWSER_COLUMN_TYPE_LINKED_TO;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;

        /* Browser contents column widths. */
        intlist.total = EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[EDV_BROWSER_COLUMN_TYPE_NAME] = 150;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_SIZE] = 70;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_TYPE] = 100;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_PERMISSIONS] = 80;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_OWNER] = 80;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_GROUP] = 80;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS] = 120;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED] = 120;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED] = 120;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_HARD_LINKS] = 70;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_LINKED_TO] = 150;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_DEVICE] = 60;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_INODE] = 70;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE] = 90;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE] = 80;
            intlist.i[EDV_BROWSER_COLUMN_TYPE_BLOCKS] = 60;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;

	/* Show hidden objects? */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN,
            TRUE, FALSE
        );
	/* Show no access objects? */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS,
            TRUE, FALSE
        );


        /* Image browser geometry. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_X,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_Y,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_WIDTH,
            EDV_DEF_IMBR_WIDTH, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_HEIGHT,
            EDV_DEF_IMBR_HEIGHT, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_PANED_POSITION,
            EDV_DEF_IMBR_PANED_POSITION, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR,
            TRUE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR,
            TRUE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_FIND_BAR,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR,
            TRUE, FALSE
        );

        /* Tool bar. */
        intlist.total = 14;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
	    intlist.i[0] = EDV_IMBR_OP_GOTO_PARENT;
            intlist.i[1] = EDV_IMBR_OP_REFRESH;
            intlist.i[2] = EDV_IMBR_OP_SEPARATOR;
            intlist.i[3] = EDV_IMBR_OP_MOVE;
            intlist.i[4] = EDV_IMBR_OP_COPY;
            intlist.i[5] = EDV_IMBR_OP_DELETE;
            intlist.i[6] = EDV_IMBR_OP_PROPERTIES;
            intlist.i[7] = EDV_IMBR_OP_SEPARATOR;
            intlist.i[8] = EDV_IMBR_OP_STOP;
            intlist.i[9] = EDV_IMBR_OP_CONTINUE;
            intlist.i[10] = EDV_IMBR_OP_SEPARATOR;
            intlist.i[11] = EDV_IMBR_OP_NEW_BROWSER;
            intlist.i[12] = EDV_IMBR_OP_NEW_IMBR;
            intlist.i[13] = EDV_IMBR_OP_RECYCLE_BIN;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_TOOL_BAR,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY,
            TOOLBAR_DISPLAY_PICTURES_AND_TEXT, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF,
            TOOLBAR_RELIEF_NONE, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_THUMB_WIDTH,
            DEF_IMBR_THUMB_WIDTH, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_THUMB_HEIGHT,
            DEF_IMBR_THUMB_HEIGHT, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_THUMB_BORDER,
            DEF_IMBR_THUMB_BORDER, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE,
            FALSE, FALSE
        );

        /* Show hidden objects? */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN,
            TRUE, FALSE
        );
        /* Show no access objects? */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS,
            TRUE, FALSE
        );
        /* Show non-image objects? */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE,
            TRUE, FALSE
        );

        /* Archiver geometry. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_X,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_Y,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_WIDTH,
            EDV_DEF_ARCHIVER_WIDTH, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_HEIGHT,
            EDV_DEF_ARCHIVER_HEIGHT, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR,
            TRUE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR,
            TRUE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR,
            TRUE, FALSE
        );

        /* Tool bar. */
        intlist.total = 9;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[0] = EDV_ARCHIVER_OP_NEW;
            intlist.i[1] = EDV_ARCHIVER_OP_OPEN;
            intlist.i[2] = EDV_ARCHIVER_OP_SEPARATOR;
            intlist.i[3] = EDV_ARCHIVER_OP_ADD;
            intlist.i[4] = EDV_ARCHIVER_OP_EXTRACT;
            intlist.i[5] = EDV_ARCHIVER_OP_EXTRACT_ALL;
            intlist.i[6] = EDV_ARCHIVER_OP_DELETE;
            intlist.i[7] = EDV_ARCHIVER_OP_SEPARATOR;
            intlist.i[8] = EDV_ARCHIVER_OP_REFRESH;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_TOOL_BAR,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY,
            TOOLBAR_DISPLAY_PICTURES_AND_TEXT, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF,
            TOOLBAR_RELIEF_NONE, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list,
            EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list,
            EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS,
            FALSE, FALSE
        );

        /* Archiver contents column reference numbers. */
        intlist.total = 8;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[0] = EDV_ARCHIVER_COLUMN_TYPE_NAME;
            intlist.i[1] = EDV_ARCHIVER_COLUMN_TYPE_SIZE;
            intlist.i[2] = EDV_ARCHIVER_COLUMN_TYPE_TYPE;
            intlist.i[3] = EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS;
            intlist.i[4] = EDV_ARCHIVER_COLUMN_TYPE_OWNER;
            intlist.i[5] = EDV_ARCHIVER_COLUMN_TYPE_GROUP;
            intlist.i[6] = EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED;
            intlist.i[7] = EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;

        /* Archiver contents column widths. */
        intlist.total = EDV_ARCHIVER_CONTENTS_CLIST_COLUMNS_MAX;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_NAME] = 150;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_SIZE] = 70;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_TYPE] = 100;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS] = 80;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_OWNER] = 80;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_GROUP] = 80;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS] = 120;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED] = 120;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED] = 120;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_LOCATION] = 150;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO] = 150;
            intlist.i[EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE] = 90;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN_WIDTH,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;


        /* Recycle bin geometry. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_X,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_Y,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_WIDTH,
            EDV_DEF_RECBIN_WIDTH, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_HEIGHT,
            EDV_DEF_RECBIN_HEIGHT, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y,
            0, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR,
            TRUE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR,
            TRUE, FALSE
        );

        /* Tool bar. */
        intlist.total = 6;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[0] = EDV_RECBIN_OP_RECOVER;
            intlist.i[1] = EDV_RECBIN_OP_SEPARATOR;
            intlist.i[2] = EDV_RECBIN_OP_PURGE;
            intlist.i[3] = EDV_RECBIN_OP_PURGE_ALL;
            intlist.i[4] = EDV_RECBIN_OP_SEPARATOR;
            intlist.i[5] = EDV_RECBIN_OP_REFRESH;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_TOOL_BAR,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY,
            TOOLBAR_DISPLAY_PICTURES_AND_TEXT, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF,
            TOOLBAR_RELIEF_NONE, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list,
            EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list,
            EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS,
            FALSE, FALSE
        );

        /* Recycle bin contents column reference numbers. */
        intlist.total = 7;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[0] = EDV_RECBIN_COLUMN_TYPE_NAME;
            intlist.i[1] = EDV_RECBIN_COLUMN_TYPE_SIZE;
            intlist.i[2] = EDV_RECBIN_COLUMN_TYPE_TYPE;
            intlist.i[3] = EDV_RECBIN_COLUMN_TYPE_PERMISSIONS;
            intlist.i[4] = EDV_RECBIN_COLUMN_TYPE_OWNER;
            intlist.i[5] = EDV_RECBIN_COLUMN_TYPE_GROUP;
            intlist.i[6] = EDV_RECBIN_COLUMN_TYPE_ORIGINAL_PATH;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;

        /* Recycle bin contents column widths. */
        intlist.total = EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX;
        intlist.i = (gint *)g_malloc0(intlist.total * sizeof(gint));
        if(intlist.i != NULL)
        {
            intlist.i[EDV_RECBIN_COLUMN_TYPE_NAME] = 150;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_SIZE] = 70;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_TYPE] = 100;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_PERMISSIONS] = 80;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_OWNER] = 80;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_GROUP] = 80;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS] = 120;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED] = 120;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED] = 120;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_DATE_DELETED] = 120;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_LINKED_TO] = 150;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_ORIGINAL_PATH] = 150;
            intlist.i[EDV_RECBIN_COLUMN_TYPE_INDEX] = 60;
        }
        EDVCFGItemListSetValueIntList(
            core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH,
            &intlist, FALSE
        );
        g_free(intlist.i);
        intlist.i = NULL;


        /* Find window geometry. */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_X,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_Y,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_WIDTH,
            EDV_DEF_FINDWIN_WIDTH, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_HEIGHT,
            EDV_DEF_FINDWIN_HEIGHT, FALSE
        );

        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_SEARCH_STRING,
            "", FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_FIND_OP,
            EDV_FINDWIN_FIND_OBJECT_NAME, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_CASE_SENSITIVE,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_FINDWIN_RECURSIVE,
            FALSE, FALSE
        );

        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RUNDLG_X,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RUNDLG_Y,
            0, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RUNDLG_RUN_IN_TERMINAL,
            FALSE, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_RUNDLG_KEEP_DIALOG,
            FALSE, FALSE
        );
	cstrptr = getenv("HOME");
        EDVCFGItemListSetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_RUNDLG_LAST_WORKING_DIR,
            (cstrptr != NULL) ? cstrptr : "/", FALSE
        );


}

/*
 *      Creates a standard list of cursors on the given core structure.
 */
static void EDVDoCreateStandardCursors(edv_core_struct *core_ptr)
{
        gint i, cursor_code;
        GdkCursorType gdk_cursor_type;
        edv_cursor_struct *cur;


#define DO_APPEND_CURSOR	\
{ \
 i = core_ptr->total_cursors; \
 core_ptr->total_cursors = i + 1; \
 \
 core_ptr->cursor = (edv_cursor_struct **)g_realloc( \
  core_ptr->cursor, \
  core_ptr->total_cursors * sizeof(edv_cursor_struct *) \
 ); \
 if(core_ptr->cursor == NULL) \
 { \
  core_ptr->total_cursors = 0; \
  i = -1; \
  cur = NULL; \
 } \
 else \
 { \
  core_ptr->cursor[i] = cur = EDVCursorNewByGDKPreset( \
   cursor_code, gdk_cursor_type \
  ); \
 } \
}

	cursor_code = EDV_CURSOR_CODE_BUSY;
	gdk_cursor_type = GDK_WATCH;
	DO_APPEND_CURSOR

	cursor_code = EDV_CURSOR_CODE_TEXT;
	gdk_cursor_type = GDK_XTERM;
        DO_APPEND_CURSOR

	cursor_code = EDV_CURSOR_CODE_TRANSLATE;
        gdk_cursor_type = GDK_FLEUR;
        DO_APPEND_CURSOR

        cursor_code = EDV_CURSOR_CODE_RESIZE;
        gdk_cursor_type = GDK_SIZING;
        DO_APPEND_CURSOR

        cursor_code = EDV_CURSOR_CODE_CROSSHAIR;
        gdk_cursor_type = GDK_TCROSS;
        DO_APPEND_CURSOR

	cursor_code = EDV_CURSOR_CODE_HAND;
	gdk_cursor_type = GDK_HAND2;
        DO_APPEND_CURSOR

#undef DO_APPEND_CURSOR
}


/*
 *	Creates a standard list of mimetypes on the given core structure.
 */
static void EDVDoCreateStandardMimeTypes(edv_core_struct *core_ptr)
{
	gint i;
	guint8 **data[EDV_MIMETYPE_TOTAL_ICON_STATES];
	const gchar *extension, *type, *description;
	edv_mimetype_struct *m;


#define DO_APPEND_MIMETYPE	\
{ \
 /* Allocate more pointers. */ \
 i = core_ptr->total_mimetypes; \
 core_ptr->total_mimetypes = i + 1; \
 \
 core_ptr->mimetype = (edv_mimetype_struct **)g_realloc( \
  core_ptr->mimetype, \
  core_ptr->total_mimetypes * sizeof(edv_mimetype_struct *) \
 ); \
 if(core_ptr->mimetype == NULL) \
 { \
  core_ptr->total_mimetypes = 0; \
  i = -1; \
  m = NULL; \
 } \
 else \
 { \
  /* Allocate a new MIME Type structure. */ \
  core_ptr->mimetype[i] = m = EDVMimeTypeNew( \
   EDV_MIMETYPE_CLASS_SYSTEM, extension, type, description \
  ); \
  if(m != NULL) \
  { \
   /* Mark as read only since this MIME Type is allocated in the \
    * standard internal list. Also mark as realized since we're loading \
    * all resources at time of creation. \
    */ \
   m->read_only = TRUE; \
   m->realized = TRUE; \
  } \
 } \
}

        extension = NULL;
        type = EDV_MIMETYPE_STR_FILE;
        description = NULL;
        DO_APPEND_MIMETYPE
        if(m != NULL)
        {
            data[0] = (guint8 **)icon_file_20x20_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_file_32x32_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
        }

        extension = NULL;
        type = EDV_MIMETYPE_STR_FILE_EXECUTABLE;
        description = NULL;
        DO_APPEND_MIMETYPE
        if(m != NULL)
        {
            data[0] = (guint8 **)icon_executable_20x20_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_executable_32x32_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
        }

	extension = NULL;
	type = EDV_MIMETYPE_STR_DIRECTORY;
	description = NULL;
	DO_APPEND_MIMETYPE
	if(m != NULL)
	{
	    data[0] = (guint8 **)icon_folder_closed_20x20_xpm;
            data[1] = (guint8 **)icon_folder_opened_20x20_xpm;
	    data[2] = NULL;
	    EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_folder_closed_32x32_xpm;
            data[1] = (guint8 **)icon_folder_opened_32x32_xpm;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
	}

        extension = NULL;
        type = EDV_MIMETYPE_STR_LINK;
        description = NULL;
        DO_APPEND_MIMETYPE
        if(m != NULL)
        {
            data[0] = (guint8 **)icon_link2_20x20_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_link2_32x32_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
        }

        extension = NULL;
        type = EDV_MIMETYPE_STR_DEVICE_BLOCK;
        description = NULL;
        DO_APPEND_MIMETYPE
        if(m != NULL)
        {
            data[0] = (guint8 **)icon_device_block_20x20_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_device_block_32x32_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
        }

        extension = NULL;
        type = EDV_MIMETYPE_STR_DEVICE_CHARACTER;
        description = NULL;
        DO_APPEND_MIMETYPE
        if(m != NULL)
        {
            data[0] = (guint8 **)icon_device_character_20x20_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_device_character_32x32_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
        }

        extension = NULL;
        type = EDV_MIMETYPE_STR_FIFO;
        description = NULL;
        DO_APPEND_MIMETYPE
        if(m != NULL)
        {
            data[0] = (guint8 **)icon_pipe_20x20_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_pipe_32x32_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
        }

        extension = NULL;
        type = EDV_MIMETYPE_STR_SOCKET;
        description = NULL;
        DO_APPEND_MIMETYPE
        if(m != NULL)
        {
            data[0] = (guint8 **)icon_socket_20x20_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadSmallIconsData(m, data);
            data[0] = (guint8 **)icon_socket_32x32_xpm;
            data[1] = NULL;
            data[2] = NULL;
            EDVMimeTypeLoadMediumIconsData(m, data);
        }



#undef DO_APPEND_MIMETYPE
}


/*
 *	Creates the users and groups popup lists, the users and groups
 *	lists should already be loaded prior to this call.
 */
static void EDVDoCreateIDPULists(edv_core_struct *core_ptr)
{
	gint i;
	edv_uid_struct *uid_ptr;
	edv_gid_struct *gid_ptr;
	pulist_struct *list;


	/* Begin creating users popup list. */
	core_ptr->users_pulist = list = PUListNew();
	if(list != NULL)
	{
	    for(i = 0; i < core_ptr->total_uids; i++)
	    {
		uid_ptr = core_ptr->uid[i];
		if(uid_ptr == NULL)
		    continue;

		PUListAddItem(
		    list, uid_ptr->name,
		    (gpointer)i, NULL
		);
	    }
	}

        /* Begin creating groups popup list. */
        core_ptr->groups_pulist = list = PUListNew();
        if(list != NULL)
        {
            for(i = 0; i < core_ptr->total_gids; i++)
            {
                gid_ptr = core_ptr->gid[i];
                if(gid_ptr == NULL)
                    continue;

                PUListAddItem(
		    list, gid_ptr->name,
		    (gpointer)i, NULL
		);
            }
        }
}



/*
 *	Allocates a new core structure, loads configuration, and creates 
 *	initial window(s).
 *
 *	If a lock link exists and reffers to an existing process then
 *	an interprocess command will be sent to the reffered process.
 *
 *	err_rtn will be set appropriately, since returning NULL does
 *	not always indicate failure.
 */
edv_core_struct *EDVNew(gint argc, gchar *argv[], gint *err_rtn)
{
	gint i, p;
	gbool cfg_version_different;
	gint old_version_major, old_version_minor, old_version_release;
	gbool	startup_browser,
		startup_imbr,
		startup_archiver,
		startup_recbin;
	const gchar *arg, *cstrptr, *cstrptr2;
	const gchar *window_name = NULL;
	const gchar *window_extra = NULL;
	const gchar *recycled_index_file;
	const gchar *alternate_config_file = NULL;
	const gchar *startup_dir = NULL;
	char *hostname = NULL;	/* A buffer for getting the hostname
				 * from gethostname().
				 */
	edv_core_struct *core_ptr = (edv_core_struct *)g_malloc0(
	    sizeof(edv_core_struct)
	);
	if(core_ptr == NULL)
	{
	    if(err_rtn != NULL)
		*err_rtn = -3;
	    return(core_ptr);
	}


	if(err_rtn != NULL)
	    *err_rtn = 0;


	/* Begin resetting values. */
	core_ptr->browser = NULL;
	core_ptr->total_browsers = 0;

	core_ptr->imbr = NULL;
	core_ptr->total_imbrs = 0;

	core_ptr->recbin = NULL;
	core_ptr->recbin_deskicon = NULL;
	core_ptr->last_recbin_items = 0;

	core_ptr->findwin = NULL;

        core_ptr->propwin = NULL;
        core_ptr->total_propwins = 0;

	core_ptr->options_window = NULL;
	core_ptr->customize_window = NULL;

	core_ptr->about_dialog = NULL;

	core_ptr->geometry_set = FALSE;
	memset(&core_ptr->geometry, 0x00, sizeof(GdkRectangle));
        core_ptr->font_name = NULL;
        core_ptr->font = NULL;
        core_ptr->fg_color_name = NULL;
        core_ptr->bg_color_name = NULL;
        core_ptr->sfg_color_name = NULL;
        core_ptr->sbg_color_name = NULL;
        core_ptr->cfg_color_name = NULL;
        core_ptr->cbg_color_name = NULL;
        core_ptr->bg_pixmap_path = NULL;
        core_ptr->sbg_pixmap_path = NULL;
        core_ptr->wm_name = NULL;
        core_ptr->wm_class = NULL;
        core_ptr->title = NULL;

	core_ptr->manage_toid = (guint)-1;
	core_ptr->need_close_all_windows = FALSE;

        core_ptr->interprocess_command = NULL;
	core_ptr->total_interprocess_commands = 0;

	core_ptr->prog_file = NULL;
	core_ptr->pid = getpid();

	core_ptr->user_id = getuid();
	core_ptr->effective_user_id = geteuid();
	core_ptr->group_id = getgid();
	core_ptr->effective_group_id = getegid();

        core_ptr->uid = NULL;
        core_ptr->total_uids = 0;
	core_ptr->users_pulist = NULL;
        core_ptr->gid = NULL;
        core_ptr->total_gids = 0;
	core_ptr->groups_pulist = NULL;

	core_ptr->effective_user_id_str = NULL;
	core_ptr->effective_user_id_location_str = NULL;

	core_ptr->cursor = NULL;
	core_ptr->total_cursors = 0;

        core_ptr->device = NULL;
        core_ptr->total_devices = 0;
	core_ptr->devices_pulist = NULL;

	core_ptr->mimetype = NULL;
	core_ptr->total_mimetypes = 0;
	core_ptr->openwith_pulist = NULL;
	core_ptr->mimetype_system_index_first = -1;
	core_ptr->mimetype_system_index_last = -1;
	core_ptr->mimetype_format_index_first = -1;
	core_ptr->mimetype_format_index_last = -1;
	core_ptr->mimetype_program_index_first = -1;
	core_ptr->mimetype_program_index_last = -1;
	core_ptr->mimetype_unique_index_first = -1;
	core_ptr->mimetype_unique_index_last = -1;

	core_ptr->cfg_file = NULL;
	core_ptr->cfg_list = NULL;

	core_ptr->history_event = NULL;
	core_ptr->total_history_events = 0;


	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    /* Alternate configuration file? */
	    if(!strcmp(arg, "--rcfile") ||
               !strcmp(arg, "-rcfile") ||
               !strcmp(arg, "--config_file") ||
               !strcmp(arg, "-config_file") ||
               !strcmp(arg, "--f") ||
               !strcmp(arg, "-f")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    alternate_config_file = arg;
		}
		else
		{
		    fprintf(
			stderr,
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core_ptr, FALSE);
		    core_ptr = NULL;
		    if(err_rtn != NULL)
			*err_rtn = -2;
		    return(NULL);
		}
	    }
	    /* No splash? */
            else if(!strcmp(arg, "--no_splash") ||
                    !strcmp(arg, "-no_splash")
	    )
	    {

	    }
	    /* Startup with the file browser? */
	    else if(!strcasecmp(arg, "--file_browser") ||
                    !strcasecmp(arg, "--file-browser") ||
                    !strcasecmp(arg, "-file_browser") ||
                    !strcasecmp(arg, "-file-browser") ||
                    !strcasecmp(arg, "--browser") ||
                    !strcasecmp(arg, "-browser")
            )
            {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
            /* Startup with the image browser? */
            else if(!strcasecmp(arg, "--image_browser") ||
                    !strcasecmp(arg, "--image-browser") ||
                    !strcasecmp(arg, "-image_browser") ||
                    !strcasecmp(arg, "-image-browser") ||
                    !strcasecmp(arg, "--imbr") ||
                    !strcasecmp(arg, "-imbr")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the archiver? */
            else if(!strcasecmp(arg, "--archiver") ||
                    !strcasecmp(arg, "-archiver")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the recycle bin? */
            else if(!strcasecmp(arg, "--recycle_bin") ||
                    !strcasecmp(arg, "--recycle-bin") ||
                    !strcasecmp(arg, "-recycle_bin") ||
                    !strcasecmp(arg, "-recycle-bin") ||
                    !strcasecmp(arg, "--recbin") ||
                    !strcasecmp(arg, "-recbin")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the properties window? */
            else if(!strcasecmp(arg, "--properties") ||
                    !strcasecmp(arg, "-properties") ||
                    !strcasecmp(arg, "--propwin") ||
                    !strcasecmp(arg, "-propwin")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the options window? */
            else if(!strcasecmp(arg, "--options") ||
                    !strcasecmp(arg, "-options")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the customize window? */
            else if(!strcasecmp(arg, "--customize") ||
                    !strcasecmp(arg, "-customize")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the devices list? */
            else if(!strcasecmp(arg, "--devices") ||
                    !strcasecmp(arg, "-devices")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the mimetypes list? */
            else if(!strcasecmp(arg, "--mimetypes") ||
                    !strcasecmp(arg, "-mimetypes")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the run dialog? */
            else if(!strcasecmp(arg, "--run_dialog") ||
                    !strcasecmp(arg, "--run-dialog") ||
                    !strcasecmp(arg, "-run_dialog") ||
                    !strcasecmp(arg, "-run-dialog") ||
                    !strcasecmp(arg, "--run_dlg") ||
                    !strcasecmp(arg, "--run-dlg") ||
                    !strcasecmp(arg, "-run_dlg") ||
                    !strcasecmp(arg, "-run-dlg") ||
                    !strcasecmp(arg, "--rundlg") ||
                    !strcasecmp(arg, "-rundlg")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }
            /* Startup with the about dialog? */
            else if(!strcasecmp(arg, "--about_dialog") ||
                    !strcasecmp(arg, "--about-dialog") ||
                    !strcasecmp(arg, "-about_dialog") ||
                    !strcasecmp(arg, "-about-dialog") ||
                    !strcasecmp(arg, "--about_dlg") ||
                    !strcasecmp(arg, "--about-dlg") ||
                    !strcasecmp(arg, "-about_dlg") ||
                    !strcasecmp(arg, "-about-dlg") ||
                    !strcasecmp(arg, "--aboutdlg") ||
                    !strcasecmp(arg, "-aboutdlg")
            )
            {
                window_name = arg;
                while(*window_name == '-')
                    window_name++;
            }

            /* Geometry? */
            else if(!strcasecmp(arg, "--geometry") ||
                    !strcasecmp(arg, "-geometry")
	    )
	    {
                i++;
                if(i < argc)
                {
		    gint x, y, width, height;
		    GdkRectangle *rect = &core_ptr->geometry;

                    arg = argv[i];

		    if(gdk_parse_geometry(arg, &x, &y, &width, &height))
		    {
			core_ptr->geometry_set = TRUE;
			rect->x = x;
			rect->y = y;
			rect->width = width;
			rect->height = height;
		    }
		    else
		    {
                        fprintf(
                            stderr,
                            "%s: Cannot parse argument.\n",
                            arg
                        );
                        EDVDelete(core_ptr, FALSE);
                        core_ptr = NULL;
                        if(err_rtn != NULL)
                            *err_rtn = -2;
                        return(NULL);
                    }
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }		
	    }
            /* Font name? */
            else if(!strcasecmp(arg, "--font") ||
		    !strcasecmp(arg, "-font") ||
		    !strcasecmp(arg, "--fn") ||
		    !strcasecmp(arg, "-fn")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
		    g_free(core_ptr->font_name);
		    core_ptr->font_name = (arg != NULL) ?
			g_strdup(arg) : NULL;
		}
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
	    }
            /* Foreground color name? */
            else if(!strcasecmp(arg, "--foreground") ||
                    !strcasecmp(arg, "-foreground") ||
                    !strcasecmp(arg, "--fg") ||
                    !strcasecmp(arg, "-fg")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->fg_color_name);
                    core_ptr->fg_color_name = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Background color name? */
            else if(!strcasecmp(arg, "--background") ||
                    !strcasecmp(arg, "-background") ||
                    !strcasecmp(arg, "--bg") ||
                    !strcasecmp(arg, "-bg")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->bg_color_name);
                    core_ptr->bg_color_name = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Selected foreground color name? */
            else if(!strcasecmp(arg, "--sforeground") ||
                    !strcasecmp(arg, "-sforeground") ||
                    !strcasecmp(arg, "--sfg") ||
                    !strcasecmp(arg, "-sfg")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->sfg_color_name);
                    core_ptr->sfg_color_name = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Selected background color name? */
            else if(!strcasecmp(arg, "--sbackground") ||
                    !strcasecmp(arg, "-sbackground") ||
                    !strcasecmp(arg, "--sbg") ||
                    !strcasecmp(arg, "-sbg")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->sbg_color_name);
                    core_ptr->sbg_color_name = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Pointer cursor foreground color name? */
            else if(!strcasecmp(arg, "--cforeground") ||
                    !strcasecmp(arg, "-cforeground") ||
                    !strcasecmp(arg, "--cfg") ||
                    !strcasecmp(arg, "-cfg")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->cfg_color_name);
                    core_ptr->cfg_color_name = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Pointer cursor background color name? */
            else if(!strcasecmp(arg, "--cbackground") ||
                    !strcasecmp(arg, "-cbackground") ||
                    !strcasecmp(arg, "--cbg") ||
                    !strcasecmp(arg, "-cbg")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->cbg_color_name);
                    core_ptr->cbg_color_name = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Background pixmap path? */
            else if(!strcasecmp(arg, "--background-pixmap") ||
                    !strcasecmp(arg, "-background-pixmap") ||
                    !strcasecmp(arg, "--bg-pixmap") ||
                    !strcasecmp(arg, "-bg-pixmap")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->bg_pixmap_path);
                    core_ptr->bg_pixmap_path = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Selected background pixmap path? */
            else if(!strcasecmp(arg, "--sbackground-pixmap") ||
                    !strcasecmp(arg, "-sbackground-pixmap") ||
                    !strcasecmp(arg, "--sbg-pixmap") ||
                    !strcasecmp(arg, "-sbg-pixmap")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->sbg_pixmap_path);
                    core_ptr->sbg_pixmap_path = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }

            /* Name? */
            else if(!strcasecmp(arg, "--name") ||
                    !strcasecmp(arg, "-name")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->wm_name);
                    core_ptr->wm_name = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Class? */
            else if(!strcasecmp(arg, "--class") ||
                    !strcasecmp(arg, "-class")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->wm_class);
                    core_ptr->wm_class = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }
            /* Title? */
            else if(!strcasecmp(arg, "--title") ||
                    !strcasecmp(arg, "-title")
            )
            {
                i++;
                if(i < argc)
                {
                    arg = argv[i];
                    g_free(core_ptr->title);
                    core_ptr->title = (arg != NULL) ?
                        g_strdup(arg) : NULL;
                }
                else
                {
                    fprintf(
                        stderr,
                        "%s: Requires argument.\n",
                        arg
                    );
                    EDVDelete(core_ptr, FALSE);
                    core_ptr = NULL;
                    if(err_rtn != NULL)
                        *err_rtn = -2;
                    return(NULL);
                }
            }

	    /* Alternate startup path? */
	    else if(ISPATHABSOLUTE(arg))
	    {
		startup_dir = arg;
	    }
	}


	/* Record program file path from given arguments. */
	if(argc > 0)
	{
	    g_free(core_ptr->prog_file);
	    core_ptr->prog_file = g_strdup(argv[0]);
	}

	/* Get user and group ID lists. */
	core_ptr->uid = EDVUIDGetSystem(&core_ptr->total_uids);
        core_ptr->gid = EDVGIDGetSystem(&core_ptr->total_gids);

	/* Generate effective user id string, this only needs to
	 * be done once at start up since user names do not change.
	 */
	/* Get effective user name. */
	cstrptr = EDVUIDGetNameFromUID(
	    core_ptr->uid, core_ptr->total_uids,
	    core_ptr->effective_user_id, NULL
	);

	/* Generate user name string. */
	g_free(core_ptr->effective_user_id_str);
	core_ptr->effective_user_id_str = g_strdup_printf(
	    "%s",
	    (cstrptr != NULL) ? cstrptr : "anonymous"
	);

        /* Generate hostname string. */
        hostname = g_malloc0(MAX_HOSTNAME_LEN);
        if(gethostname(hostname, MAX_HOSTNAME_LEN) != 0)
	{
            /* Something went wrong with the call to gethostname(),
             * free the memory and nullify the pointer.
	     */
            g_free(hostname);
            hostname = NULL;
	}
	else
	{
	    /* Everything went fine, force the last character to be
	     * '\0' to ensure sanity.
	     */
	    hostname[MAX_HOSTNAME_LEN - 1] = '\0';
        }

        /* Generate user name with host name string. */
        g_free(core_ptr->effective_user_id_location_str);
        core_ptr->effective_user_id_location_str = g_strdup_printf(
            "%s@%s",
	    (cstrptr != NULL) ? cstrptr : "anonymous",
            (hostname != NULL) ? hostname : "unknown"
        );

	/* If the hostname is still allocated, free the memory and
	 * nullify the pointer.
	 */
	if(hostname != NULL)
	{
	    g_free(hostname);
	    hostname = NULL;
	}

	/* Set up configuration list to default values. */
	EDVDoCreateStandardConfiguration(core_ptr);

	/* Set configuration file path. */
	if(alternate_config_file != NULL)
	{
	    /* Set alternate configuration file path from command line. */
	    g_free(core_ptr->cfg_file);
	    core_ptr->cfg_file = g_strdup(alternate_config_file);
	}
	else
	{
	    /* Set standard configuration file in local data directory. */
	    cstrptr = EDVCFGItemListGetValueS(
		core_ptr->cfg_list, EDV_CFG_PARM_DIR_LOCAL
	    );
	    cstrptr2 = PrefixPaths(cstrptr, EDV_DEF_CONFIG_FILE);
	    if(cstrptr2 != NULL)
	    {
		g_free(core_ptr->cfg_file);
		core_ptr->cfg_file = g_strdup(cstrptr2);
	    }
	}
	/* Load configuration from file, overwriting any existing
	 * configuration values in the passed cfg_list.
	 */
	EDVCFGLoadFromFile(core_ptr->cfg_file, core_ptr->cfg_list);


	/* Check if version obtained from configuration file is older than
	 * the compile time version of this program (include release version
	 * number in the check).
	 */
	old_version_major = EDVCFGItemListGetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_VERSION_MAJOR
	);
        old_version_minor = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_VERSION_MINOR
        );
        old_version_release = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_VERSION_RELEASE
        );
	/* Is version from configuration different than the compile time
	 * version?
	 */
	cfg_version_different = FALSE;
	if(old_version_major != PROG_VERSION_MAJOR)
	    cfg_version_different = TRUE;
	else if(old_version_minor != PROG_VERSION_MINOR)
	    cfg_version_different = TRUE;
        else if(old_version_release != PROG_VERSION_RELEASE)
            cfg_version_different = TRUE;

        /* Need to explicitly set new version since version in configuration
	 * list that was just fetched may be old.
	 */
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_VERSION_MAJOR,
            PROG_VERSION_MAJOR, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_VERSION_MINOR,
            PROG_VERSION_MINOR, FALSE
        );
        EDVCFGItemListSetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_VERSION_RELEASE,
            PROG_VERSION_RELEASE, FALSE
        );


	/* Override startup directory from command line? */
	if(startup_dir != NULL)
	    EDVCFGItemListSetValueS(
		core_ptr->cfg_list, EDV_CFG_PARM_DIR_START_UP,
		startup_dir, FALSE
	    );

	/* Get startup window options. */
	startup_browser = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_BROWSER
        );
        startup_imbr = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_IMBR
        );
        startup_archiver = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_ARCHIVER
        );
        startup_recbin = EDVCFGItemListGetValueI(
            core_ptr->cfg_list, EDV_CFG_PARM_STARTUP_RECBIN
        );


        /* Check if the lock link exists, the process is actually
         * already running, and it is not this process.
	 *
	 * Note that EDVInterPSGetLock() will only return non-zero if
	 * the process indicated by the lock link is actually running.
         */
	p = EDVInterPSGetLock(core_ptr->cfg_list);
        if((p != 0) && (p != core_ptr->pid))
        {
	    /* Issue a command to the already running process. */
	    gchar *cmd, *cmdv[1];

	    /* If no window name was specified at startup, then
	     * use the one specified from the configuration.
	     */
	    if(window_name == NULL)
	    {
		if(startup_browser)
		    window_name = "file_browser";
		else if(startup_imbr)
		    window_name = "image_browser";
                else if(startup_archiver)
                    window_name = "archiver";
                else if(startup_recbin)
                    window_name = "recycle_bin";
		else
		    window_name = "file_browser";
	    }

	    /* Format a command, specifying to create a new window and
	     * send that command to the already running process.
	     */
	    cmdv[0] = cmd = g_strdup_printf(
		"new_window %s %s",
		window_name,
		(startup_dir != NULL) ? startup_dir : ""
	    );
	    EDVInterPSSendCommand(core_ptr->cfg_list, p, cmdv, 1);
	    g_free(cmd);

	    EDVDelete(core_ptr, FALSE);
            return(NULL);
        }

        /* (Re)create lock link and remove and queued interprocess
	 * commands.
	 */
        EDVInterPSMakeLock(core_ptr->cfg_list, core_ptr->pid, TRUE);
	EDVInterPSRemoveCommand(core_ptr->cfg_list);


        /* Get path of recycled object index file. */
        recycled_index_file = EDVCFGItemListGetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_RECYCLED_INDEX
        );
        /* Update number of recycled objects on the core structure. */
        if(recycled_index_file != NULL)
        {
	    struct stat stat_buf;

            if(stat(recycled_index_file, &stat_buf))
                core_ptr->last_recbin_items = 0;
            else
                core_ptr->last_recbin_items = (stat_buf.st_size > 0) ?
                    1 : 0;
        }
        else
        {
            core_ptr->last_recbin_items = 0;
        }


	/* Load default font if specified. */
	if(core_ptr->font_name != NULL)
	{
	    core_ptr->font = gdk_font_load(core_ptr->font_name);
	}


        /* Update global tooltips state. */
        GUISetGlobalTipsState(
            (EDVCFGItemListGetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_SHOW_TOOLTIPS
            )) ? TRUE : FALSE
        );



	/* Create standard cursors. */
	EDVDoCreateStandardCursors(core_ptr);




	/* Load devices from system to the devices list on the core
	 * strcture. This needs to be done first before loading devices
	 * from the devices file.
	 */
	EDVDevicesListLoadFromSystem(
	    &core_ptr->device, &core_ptr->total_devices,
	    NULL, core_ptr
	);
        /* Load devices from file, appending or updating the devices in
         * the list on the core structure.
         */
        cstrptr = EDVCFGItemListGetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_DEVICES
        );
        if(cstrptr != NULL)
        {
            gchar *tmp_path = g_strdup(cstrptr);

            EDVDevicesListLoadFromFile(
                tmp_path,
                &core_ptr->device, &core_ptr->total_devices,
                NULL, core_ptr
            );
            g_free(tmp_path);
        }
	/* Update mount states for all devices. */
	EDVDevicesListUpdateMountStates(
	    core_ptr->device, core_ptr->total_devices
	);
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


	/* Create standard MIME Types list. */
	EDVDoCreateStandardMimeTypes(core_ptr);

        /* Load local and global MIME Types from file, appending them to
	 * the MIME Types list on the core structure. Globals are loaded
	 * afterwards so that locals come first in the list and thus have
	 * precidence over globals.
         */
	/* Local MIME Types. */
        cstrptr = EDVCFGItemListGetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_MIME_TYPES
        );
        if(cstrptr != NULL)
        {
            gchar *tmp_path = g_strdup(cstrptr);

            EDVMimeTypeListLoadFromFile(
                tmp_path,
                &core_ptr->mimetype, &core_ptr->total_mimetypes,
		-1,		/* Append. */
                NULL,
                core_ptr,
		NULL,
		core_ptr,
		FALSE		/* Do not load as read only. */
            );
            g_free(tmp_path);
        }
        /* Gocal MIME Types. */
        cstrptr = EDVCFGItemListGetValueS(
            core_ptr->cfg_list, EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL
        );
        if(cstrptr != NULL)
        {
            gchar *tmp_path = g_strdup(cstrptr);

            EDVMimeTypeListLoadFromFile(
                tmp_path,
                &core_ptr->mimetype, &core_ptr->total_mimetypes,
                -1,             /* Append. */
                NULL,
                core_ptr,
                NULL,
                core_ptr,
                TRUE		/* Load globals as read only. */
            );
            g_free(tmp_path);
        }
	/* Update MIME Types class hint indexes on the core structure. */
	EDVDoUpdateMIMETypeHintIndexes(core_ptr);


	/* Create users and groups popup lists, note this occures much
	 * later after the lists have been loaded from the system.
	 */
	EDVDoCreateIDPULists(core_ptr);

	/* Create devices popup list and put current devices list items
	 * into it. When this is called for the first time it will see
	 * that the devices popup list widget has not been created and
	 * will create it.
	 */
	EDVDoUpdateDevicesPUList(core_ptr);

	/* Create `open with' popup list and put all MIME Types of class
	 * application into it. When this is called for the first time it 
	 * will see that the devices popup list widget has not been created
	 * and will create it.
         */
	EDVDoUpdateOpenWithPUList(core_ptr);


	/* If the configuration file version is different from the compile
	 * time version of this program, then, print warning at this point.
	 */
	if(cfg_version_different)
	{
	    gchar *buf = g_strdup_printf(
#ifdef PROG_LANGUAGE_ENGLISH
"%s has changed from version %i.%i.%i to version %s.\n\
\n\
The configuration values may have changed since the previous version,\n\
you should take a moment to review your options and customizations\n\
by going to Settings->Options... and Settings->Customize...",
#endif
#ifdef PROG_LANGUAGE_SPANISH
"%s ha cambiado de la versin %i.%i.%i a la versin %s.\n\
\n\
Los valores de la configuracin pueden haber cambiado desde que la\n\
versin previa, usted debe llevar un momento de revisar sus opciones\n\
y customizations yendo a Settings->Options... y Settings->Customize...",
#endif
#ifdef PROG_LANGUAGE_FRENCH
"%s a chang de la version %i.%i.%i  la version %s.\n\
\n\
La configuration peut avoir chang puisque le prcdent version,\n\
vous devrait prendre un moment rexaminer vos options et\n\
customizations en allant  Settings->Options... et\n\
Settings->Customize...",
#endif
		PROG_NAME,
		old_version_major, old_version_minor, old_version_release,
		PROG_VERSION
	    );

            CDialogSetTransientFor(NULL);
            CDialogGetResponse(
#ifdef PROG_LANGUAGE_ENGLISH
		"Version Change Notice",
#endif
#ifdef PROG_LANGUAGE_SPANISH
		"La Nota del Cambio de la Versin",
#endif
#ifdef PROG_LANGUAGE_FRENCH
		"La Notification de Changement de Version",
#endif
		buf,
		NULL,
                CDIALOG_ICON_INFO,
                CDIALOG_BTNFLAG_OK,
                CDIALOG_BTNFLAG_OK
            );
            CDialogSetTransientFor(NULL);

	    g_free(buf);
	}


	/* Check recycled objects size and warn user as needed. */
	EDVDoRecycleBinSizeCheck(core_ptr, NULL);


	/* Map recycle bin desktop icon? */
	if(EDVCFGItemListGetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON
	))
	    EDVDoMapRecBinDeskIcon(core_ptr);


	/* Begin creating initial window, check if no window was
	 * specified from the command line.
	 */
	if(window_name == NULL)
	{
	    gbool created_window = FALSE;

	    if(startup_browser)
	    {
		EDVDoNewBrowser(core_ptr);
		created_window = TRUE;
	    }
	    if(startup_imbr)
            {
                EDVDoNewImbr(core_ptr);
                created_window = TRUE;
            }
            if(startup_archiver)
            {
                EDVDoNewArchiverOpen(core_ptr, startup_dir);
                created_window = TRUE;
            }
            if(startup_recbin)
            {
                EDVDoMapRecBin(core_ptr);
                created_window = TRUE;
            }
	    /* If no window was created, then just create the file
	     * browser.
	     */
	    if(!created_window)
	    {
                EDVDoNewBrowser(core_ptr);
                created_window = TRUE;
	    }
	}
	else
	{
	    EDVDoWindowNexus(
		core_ptr, window_name, startup_dir, window_extra, NULL
	    );
	}


	/* Set main management timeout function. */
	core_ptr->manage_toid = gtk_timeout_add(
	    1000, 	/* 1 second interval. */
	    (GtkFunction)EDVManageTimeoutCB,
	    core_ptr
	);

	return(core_ptr);
}

/*
 *	Saves the configuration specified on the given core structure
 *	and then deallocates all resources on the given core structure
 *	including the core structure itself.
 */
void EDVDelete(edv_core_struct *core_ptr, gbool save_config)
{
	gint i;
	const gchar *cstrptr;


	if(core_ptr == NULL)
	    return;

	/* Save configuration only if the core structure's configuration
	 * list is defined and we have been specifically told to save.
	 */
	if((core_ptr->cfg_list != NULL) && save_config)
	{
	    /* Save MIME Types. */
	    cstrptr = EDVCFGItemListGetValueS(
		core_ptr->cfg_list, EDV_CFG_PARM_FILE_MIME_TYPES
	    );
	    if(cstrptr != NULL)
	    {
		gchar *path = g_strdup(cstrptr);
		EDVMimeTypeListSaveToFile(
		    path,
		    core_ptr->mimetype, core_ptr->total_mimetypes,
		    FALSE,	/* Do not write MIME Types marked read_only. */
		    NULL, core_ptr
		);
		g_free(path);
	    }

	    /* Save devices. */
	    cstrptr = EDVCFGItemListGetValueS(
		core_ptr->cfg_list, EDV_CFG_PARM_FILE_DEVICES
	    );
	    if(cstrptr != NULL)
	    {
		gchar *path = g_strdup(cstrptr);
		EDVDeviceListSaveToFile(
		    path,
		    core_ptr->device, core_ptr->total_devices,
		    NULL, core_ptr
		);
		g_free(path);
	    }

	    /* Save configuration. */
	    EDVCFGSaveToFile(core_ptr->cfg_file, core_ptr->cfg_list);
	}


	/* Begin deallocating resources. */

	/* Remove lock link if it reffers to this process. */
	if(EDVInterPSGetLock(core_ptr->cfg_list) == core_ptr->pid)
	    EDVInterPSRemoveLock(core_ptr->cfg_list);

	/* Remove timeouts callbacks. */
	if(core_ptr->manage_toid != (guint)-1)
	{
	    gtk_timeout_remove(core_ptr->manage_toid);
	    core_ptr->manage_toid = (guint)-1;
	}


        /* Delete all property windows. */
        for(i = 0; i < core_ptr->total_propwins; i++)
            EDVPropWinDelete(core_ptr->propwin[i]);
        g_free(core_ptr->propwin);
        core_ptr->propwin = NULL;
        core_ptr->total_propwins = 0;

	/* Delete all browsers. */
	for(i = 0; i < core_ptr->total_browsers; i++)
	    EDVBrowserDelete(core_ptr->browser[i]);
	g_free(core_ptr->browser);
	core_ptr->browser = NULL;
	core_ptr->total_browsers = 0;

        /* Delete all image browsers. */
        for(i = 0; i < core_ptr->total_imbrs; i++)
            EDVImbrDelete(core_ptr->imbr[i]);
        g_free(core_ptr->imbr);
        core_ptr->imbr = NULL;
        core_ptr->total_imbrs = 0;

	/* Delete recycle bin. */
	EDVRecBinDelete(core_ptr->recbin);
	core_ptr->recbin = NULL;

	/* Delete recycle bin desktop icon. */
	EDVRecBinDeskIconDelete(core_ptr->recbin_deskicon);
	core_ptr->recbin_deskicon = NULL;

	/* Find window. */
	EDVFindWinDelete(core_ptr->findwin);
	core_ptr->findwin = NULL;


	/* History list window. */
	EDVHistoryListWinDelete(core_ptr->history_listwin);
        core_ptr->history_listwin = NULL;

        /* Run dialog. */
        EDVRunDlgDelete(core_ptr->run_dlg);
        core_ptr->run_dlg = NULL;

	/* Delete devices list window. */
	EDVDevicesListWinDelete(core_ptr->device_listwin);
        core_ptr->device_listwin = NULL;

	/* Delete MIME Types list window. */
	EDVMimeTypesListWinDelete(core_ptr->mimetype_listwin);
	core_ptr->mimetype_listwin = NULL;

	/* Delete options window. */
	OptWinDelete(core_ptr->options_window);
	core_ptr->options_window = NULL;

	/* Delete customize window. */
        OptWinDelete(core_ptr->customize_window);
        core_ptr->customize_window = NULL;

	/* Delete about dialog. */
	AboutDialogDelete(core_ptr->about_dialog);
	core_ptr->about_dialog = NULL;



	/* Delete operation history events list. */
        for(i = 0; i < core_ptr->total_history_events; i++)
            EDVHistoryDelete(core_ptr->history_event[i]);
        g_free(core_ptr->history_event);
        core_ptr->history_event = NULL;
        core_ptr->total_history_events = 0;


        /* Delete Open With popup list widget. */
        PUListDelete(core_ptr->openwith_pulist);
        core_ptr->openwith_pulist = NULL;

	/* Delete all MIME Types. */
        for(i = 0; i < core_ptr->total_mimetypes; i++)
            EDVMimeTypeDelete(core_ptr->mimetype[i]);
        g_free(core_ptr->mimetype);
        core_ptr->mimetype = NULL;
        core_ptr->total_mimetypes = 0;


	/* Delete devices popup list widget. */
        PUListDelete(core_ptr->devices_pulist);
        core_ptr->devices_pulist = NULL;

        /* Delete all devices. */
        for(i = 0; i < core_ptr->total_devices; i++)
            EDVDeviceDelete(core_ptr->device[i]);
        g_free(core_ptr->device);
        core_ptr->device = NULL;
        core_ptr->total_devices = 0;

	/* Delete all cursors. */
        for(i = 0; i < core_ptr->total_cursors; i++)
            EDVCursorDelete(core_ptr->cursor[i]);
        g_free(core_ptr->cursor);
        core_ptr->cursor = NULL;
        core_ptr->total_cursors = 0;


        /* Delete entire configuration list. */
	EDVCFGItemListDeleteList(core_ptr->cfg_list);
        core_ptr->cfg_list = NULL;


	/* Delete users and groups popup list widgets. */
	PUListDelete(core_ptr->users_pulist);
	core_ptr->users_pulist = NULL;
        PUListDelete(core_ptr->groups_pulist);
	core_ptr->groups_pulist = NULL;

        /* Delete user id's and group id's. */
        for(i = 0; i < core_ptr->total_uids; i++)
            EDVUIDDelete(core_ptr->uid[i]);
        g_free(core_ptr->uid);
        core_ptr->uid = NULL;
        core_ptr->total_uids = 0;

        for(i = 0; i < core_ptr->total_gids; i++)
            EDVGIDDelete(core_ptr->gid[i]);
        g_free(core_ptr->gid);
        core_ptr->gid = NULL;
        core_ptr->total_gids = 0;


	/* Deallocate other memory on core structure. */
	core_ptr->geometry_set = FALSE;
	memset(&core_ptr->geometry, 0x00, sizeof(GdkRectangle));

	g_free(core_ptr->font_name);
	core_ptr->font_name = NULL;

	if(core_ptr->font != NULL)
	{
	    gdk_font_unref(core_ptr->font);
	    core_ptr->font = NULL;
	}

        g_free(core_ptr->fg_color_name);
        core_ptr->fg_color_name = NULL;
        g_free(core_ptr->bg_color_name);
        core_ptr->bg_color_name = NULL;

        g_free(core_ptr->sfg_color_name);
        core_ptr->sfg_color_name = NULL;
        g_free(core_ptr->sbg_color_name);
        core_ptr->sbg_color_name = NULL;

        g_free(core_ptr->cfg_color_name);
        core_ptr->cfg_color_name = NULL;
        g_free(core_ptr->cbg_color_name);
        core_ptr->cbg_color_name = NULL;

        g_free(core_ptr->bg_pixmap_path);
        core_ptr->bg_pixmap_path = NULL;
        g_free(core_ptr->sbg_pixmap_path);
        core_ptr->sbg_pixmap_path = NULL;

	g_free(core_ptr->wm_name);
	core_ptr->wm_name = NULL;
        g_free(core_ptr->wm_class);
        core_ptr->wm_class = NULL;
        g_free(core_ptr->title);
        core_ptr->title = NULL;


	g_free(core_ptr->cfg_file);
	core_ptr->cfg_file = NULL;

	StringFreeArray(
	    core_ptr->interprocess_command,
	    core_ptr->total_interprocess_commands
	);
        core_ptr->interprocess_command = NULL;
	core_ptr->total_interprocess_commands = 0;

	g_free(core_ptr->prog_file);
	core_ptr->prog_file = NULL;

	g_free(core_ptr->effective_user_id_str);
	core_ptr->effective_user_id_str = NULL;
	g_free(core_ptr->effective_user_id_location_str);
	core_ptr->effective_user_id_location_str = NULL;

	/* Deallocate structure itself. */
	g_free(core_ptr);
}


int main(int argc, char *argv[])
{
	gbool initialized_gtk = FALSE;
	gint err_rtn = 0;
	edv_core_struct *core_ptr;


	/* Reset globals. */
	edv_core = NULL;


	/* Handle initial arguments. */
	if(argc > 1)
	{
	    gint i;
	    const gchar *arg;

	    /* Iterate through all arguments. */
	    for(i = 1; i < argc; i++)
	    {
		arg = argv[i];
		if(arg == NULL)
		    continue;

		/* Help? */
		if(!strcmp(arg, "--help") ||
                   !strcmp(arg, "-help") ||
		   !strcmp(arg, "--h") ||
                   !strcmp(arg, "-h")
		)
		{
		    printf(PROG_HELP_MESG);
		    return(0);
		}
                /* Version? */
                else if(!strcmp(arg, "--version") ||
                        !strcmp(arg, "-version") ||
                        !strcmp(arg, "--v") ||
                        !strcmp(arg, "-v")
                )
                {
                    printf(
			"%s Version %s\n",
			PROG_NAME, PROG_VERSION
		    );
		    printf(PROG_COPYRIGHT);
                    return(0);
                }



	    }
	}


	/* Set up time zone. */
	tzset();

        /* Set up signal callbacks. */
#ifdef SIGINT
        signal(SIGINT, EDVSignalCB);
#endif
#ifdef SIGTERM
        signal(SIGTERM, EDVSignalCB);
#endif
#ifdef SIGKILL
        signal(SIGKILL, EDVSignalCB);
#endif
#ifdef SIGSEGV
        signal(SIGSEGV, EDVSignalCB);
#endif
#ifdef SIGPIPE
        signal(SIGPIPE, EDVSignalCB);
#endif
#ifdef SIGHUP
        signal(SIGHUP, EDVSignalCB);
#endif
#ifdef SIGUSR1
        signal(SIGUSR1, EDVSignalCB);
#endif

        /* Initialize GTK+ as needed. */
        if(!initialized_gtk)
        {
            if(!gtk_init_check(&argc, &argv))
            {
                fprintf(
                    stderr,
 "This program requires X.\n"
                );
                return(1);
            }
            initialized_gtk = TRUE;
        }

	/* Initialize GDK RGB buffers system. */
	gdk_rgb_init();

#ifdef HAVE_IMLIB
	/* Initialize Image Library. */
        imlib_handle = Imlib_init(GDK_DISPLAY());
#endif  /* HAVE_IMLIB */


	/* Initialize dialogs. */
	CDialogInit();
	FileBrowserInit();
	ClipboardBrowserInit();
	CSDInit();
	FSDInit();
	FPromptInit();
	PDialogInit();
	ProgressDialogInit();

	/* Allocate core structure and create all resources. */
	edv_core = core_ptr = EDVNew(argc, argv, &err_rtn);
	if(core_ptr == NULL)
	    return(err_rtn);

	/* Enter GTK+ main loop. */
	gtk_main();

	/* Save configuration and delete the core structure. */
	edv_core = NULL;
	EDVDelete(core_ptr, TRUE);
	core_ptr = NULL;

        /* Shutdown dialogs. */
        CDialogShutdown();
	FileBrowserShutdown();
	ClipboardBrowserShutdown();
        CSDShutdown();
        FSDShutdown();
        FPromptShutdown();
        PDialogShutdown();
        ProgressDialogShutdown();

	return(0);
}
