/*
                 Endeavour MIME Type list (and editing) window
 */

#ifndef MIMETYPESWIN_H
#define MIMETYPESWIN_H


#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvmimetypes.h"
#include "editclist.h"


/*
 *	MIME Type edit window icon structure:
 */
typedef struct {

	gpointer editwin;

	GtkWidget	*toplevel,	/* A GtkBox. */
			*button,	/* Icon GtkButton. */
			*gtk_pixmap,
			*left_btn, *right_btn, *state_label;

	GtkAdjustment *adj;

	GdkPixmap *pixmap[EDV_MIMETYPE_TOTAL_ICON_STATES];
	GdkBitmap *mask[EDV_MIMETYPE_TOTAL_ICON_STATES];

	gchar *path[EDV_MIMETYPE_TOTAL_ICON_STATES];

} edv_mimetype_editwin_icon_struct;

/*
 *      MIME Type edit window structure:
 */
typedef struct {

        gbool initialized;
        gbool map_state;
        gint busy_count;

        gpointer core_ptr, listwin;

        GtkAccelGroup *accelgrp;

        GtkWidget       *toplevel,
                        *main_vbox,
			*class_combo,
                        *type_entry,
			*value_label,
			*value_entry,
			*description_entry,
			*handler_combo,
			*ok_btn, *apply_btn, *cancel_btn;

	/* MIME Type index on the core structure's list or -1 for none. */
	gint mt_num;

	editclist_struct *editclist;

	/* Icon selecting structures. */
	edv_mimetype_editwin_icon_struct	*icon_small,
						*icon_medium,
						*icon_large;

} edv_mimetype_editwin_struct;


/*
 *	MIME Type list window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
        gint busy_count;

	gpointer core_ptr;

	GtkAccelGroup *accelgrp;

	GtkWidget	*toplevel,
			*main_vbox,
			*find_entry,
			*mimetypes_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*save_btn,
			*import_btn,
                        *export_btn,
			*display_parent,	/* GtkVBox. */
			*display_client,
			*close_btn;

	/* Right click menu. */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
                        *up_mi,
                        *down_mi,
			*save_mi,
			*import_mi,
			*export_mi;

	edv_mimetype_editwin_struct *editwin;

	/* Pixmap and mask pairs for class icons. */
	GdkPixmap *system_object_pixmap;
	GdkBitmap *system_object_mask;
        GdkPixmap *file_format_pixmap;
        GdkBitmap *file_format_mask;
        GdkPixmap *program_pixmap;
        GdkBitmap *program_mask;
        GdkPixmap *unique_object_pixmap;
        GdkBitmap *unique_object_mask;

} edv_mimetype_listwin_struct;


/* In mimetypesedit.c */
extern void EDVMimeTypesEditWinFetchValues(
        edv_mimetype_editwin_struct *ew, gint mt_num
);
extern void EDVMimeTypesEditWinMimeTypeRemovedCB(
        edv_mimetype_editwin_struct *ew, gint mt_num
);

extern edv_mimetype_editwin_struct *EDVMimeTypesEditWinNew(
        gpointer core_ptr, gpointer listwin
);
extern void EDVMimeTypesEditWinMap(
        edv_mimetype_editwin_struct *ew
);
extern void EDVMimeTypesEditWinUnmap(
        edv_mimetype_editwin_struct *ew
);
extern void EDVMimeTypesEditWinDelete(
        edv_mimetype_editwin_struct *ew
);


/* In mimetypeswin.c */
extern void EDVMimeTypesListWinSetRow(
        edv_mimetype_listwin_struct *lw, gint row, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypesListWinFetchValues(
	edv_mimetype_listwin_struct *lw
);

extern void EDVMimeTypesListWinMimeTypeAddedCB(
        edv_mimetype_listwin_struct *lw,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypesListWinMimeTypeModifiedCB(
        edv_mimetype_listwin_struct *lw,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVMimeTypesListWinMimeTypeRemovedCB(
        edv_mimetype_listwin_struct *lw,
	gint mt_num
);

extern edv_mimetype_listwin_struct *EDVMimeTypesListWinNew(
	gpointer core_ptr
);
extern void EDVMimeTypesListWinUpdateMenus(
        edv_mimetype_listwin_struct *lw
);
extern void EDVMimeTypesListWinSetBusy(
        edv_mimetype_listwin_struct *lw, gbool is_busy
);
extern void EDVMimeTypesListWinMap(
        edv_mimetype_listwin_struct *lw
);
extern void EDVMimeTypesListWinUnmap(
        edv_mimetype_listwin_struct *lw
);
extern void EDVMimeTypesListWinDelete(
	edv_mimetype_listwin_struct *lw
);





#endif	/* MIMETYPESWIN_H */
