/*
                    Endeavour Recycle Bin Callbacks
 */

#ifndef RECBINCB_H
#define RECBINCB_H

#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvmimetypes.h"
#include "recbin.h"


extern void EDVRecBinContentsItemDestroyCB(gpointer data);

extern gint EDVRecBinDeleteEventCB(
        GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void EDVRecBinDestroyCB(GtkObject *object, gpointer data);

extern gint EDVRecBinMapCB(
	GtkWidget *widget, GdkEventAny *event, gpointer data
);
extern gint EDVRecBinUnmapCB(
	GtkWidget *widget, GdkEventAny *event, gpointer data
);

extern gint EDVRecBinKeyEventCB(
         GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint EDVRecBinEnterNotifyEventCB(
         GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVRecBinLeaveNotifyEventCB(
         GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVRecBinButtonPressEventCB(
        GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void EDVRecBinHandleChildAttachedCB(
        GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void EDVRecBinHandleChildDetachedCB(
        GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void EDVRecBinResizeColumnCB(
        GtkCList *clist, gint column, gint width, gpointer data
);
extern void EDVRecBinClickColumnCB(
        GtkCList *clist, gint column, gpointer data
);
extern void EDVRecBinSelectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);
extern void EDVRecBinUnselectRowCB(
        GtkCList *clist, gint row, gint column, GdkEvent *event,
        gpointer data
);

extern void EDVRecBinWriteProtectChangedCB(
        edv_recbin_struct *recbin, gbool state
);
extern void EDVRecBinRecycledObjectAddedNotifyCB(
        edv_recbin_struct *recbin, guint index
);
extern void EDVRecBinRecycledObjectModifiedNotifyCB(
        edv_recbin_struct *recbin, guint index
);
extern void EDVRecBinRecycledObjectRemovedNotifyCB(
        edv_recbin_struct *recbin, guint index
);
extern void EDVRecBinReconfiguredNotifyCB(edv_recbin_struct *recbin);
extern void EDVRecBinMimeTypeAddedCB(
        edv_recbin_struct *recbin,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVRecBinMimeTypeModifiedCB(
        edv_recbin_struct *recbin,
        gint mt_num, edv_mimetype_struct *mt_ptr
);
extern void EDVRecBinMimeTypeRemovedCB(
        edv_recbin_struct *recbin, gint mt_num
);


#endif	/* RECBINCB_H */
