/*
                            Endeavour Object

	For disk objects.
 */

#ifndef EDVOBJ_H
#define EDVOBJ_H

#include <sys/types.h>
#include <sys/stat.h>
#include <glib.h>
#include "edvtypes.h"


/*
 *	Object:
 */
typedef struct {

	edv_object_type	type;		/* One of EDV_OBJECT_TYPE_* */

	gchar		*name;
	gchar		*full_path;

	gchar		*linked_to;	/* Link destination, for type
					 * EDV_OBJECT_TYPE_LINK
					 */

	gboolean	link_valid;	/* TRUE if link is valid (not dangling),
					 * only for type EDV_OBJECT_TYPE_LINK
					 */

	edv_permission_flags	permissions;	/* Any of EDV_PERMISSION_* */

	gulong		access_time,	/* In systime seconds */
			modify_time,
			change_time;

	gint		owner_id,
			group_id;

	gint		hard_links;	/* Number of hard links */

	gulong		size;		/* In bytes */

	gulong		device;		/* Device address */
	gulong		inode;		/* Address on device */

	gint		device_type;	/* Device major and minor numbers
					 * (used only if object type is
					 * one of EDV_OBJECT_TYPE_DEVICE_*
					 *
					 * Use EDVGetDeviceNumbers() to
					 * parse this value casted as a
					 * (dev_t)
					 */

	gulong		block_size;	/* Optimul block transfer size,
					 * in bytes 
					 */

	gulong		blocks;		/* Blocks allocated to this object */

} edv_object_struct;
#define EDV_OBJECT(p)	((edv_object_struct *)(p))


extern edv_object_type EDVObjectGetTypeFromStatMode(mode_t m);
extern mode_t EDVObjectGetTypeFromEDVType(edv_object_type type);

extern edv_permission_flags EDVObjectGetPermissionsFromStatMode(
	mode_t m
);
extern mode_t EDVObjectGetPermissionsFromEDVPermissions(
	edv_permission_flags permissions
);


extern edv_object_struct *EDVObjectNew(void);
extern edv_object_struct *EDVObjectCopy(const edv_object_struct *obj);
extern void EDVObjectSetPath(
	edv_object_struct *obj, const gchar *path
);
extern void EDVObjectSetPath2(
	edv_object_struct *obj,
	const gchar *parent, const gchar *name
);
extern void EDVObjectSetStat(
	edv_object_struct *obj, const struct stat *lstat_buf
);
extern void EDVObjectValidateLink(edv_object_struct *obj);
extern void EDVObjectDelete(edv_object_struct *obj);


#endif	/* EDVOBJ_H */
