/*
			    Endeavour Mount Bar
 */

#ifndef MOUNTBAR_H
#define MOUNTBAR_H

#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvdevices.h"


/*
 *	Mount bar structure:
 */
typedef struct {

	gboolean	initialized,
			map_state;

	gpointer	core_ptr;

	GdkGC		*gc;

	GtkWidget	*toplevel,
			*dev_da,
			*map_btn,	/* Map devices popup list button */
			*mount_btn,	/* Mount/unmount button */
			*eject_btn,
			*goto_btn,
			*refresh_stats_btn,
			*capacity_pbar,
			*stats_label;

	/* Last mount button state, -1 for undefined, 0 for mount,
	 * 1 for unmount
	 */
	gint		last_mount_btn_state;

	gchar		*dev_text;
	GdkPixmap	*dev_pixmap;
	GdkBitmap	*dev_mask;

	/* Selected device number or -1 for none */
	gint		selected_dev_num;

	void	(*mount_cb)(
		gpointer,		/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	void	(*eject_cb)(
		gpointer,		/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	void	(*goto_cb)(
		gpointer,		/* Mount Bar */
		gint,			/* Device Number */
		edv_device_struct *,	/* Device */
		gpointer		/* Data */
	);
	void (*status_message_cb)(
		gpointer,		/* Mount Bar */
		const gchar *,		/* Message */
		gpointer		/* Data */
	);
	gpointer	client_data;

} edv_mountbar_struct;
#define EDV_MOUNTBAR(p)		((edv_mountbar_struct *)(p))


extern edv_mountbar_struct *EDVMountBarNew(
	gpointer core_ptr, GtkWidget *parent,
	void (*mount_cb)(gpointer, gint, edv_device_struct *, gpointer),
	void (*eject_cb)(gpointer, gint, edv_device_struct *, gpointer),
	void (*goto_cb)(gpointer, gint, edv_device_struct *, gpointer),
	void (*status_message_cb)(gpointer, const gchar *, gpointer),
	gpointer client_data
);
extern void EDVMountBarUpdateMenus(edv_mountbar_struct *mb);
extern void EDVMountBarMap(edv_mountbar_struct *mb);
extern void EDVMountBarUnmap(edv_mountbar_struct *mb);
extern void EDVMountBarDelete(edv_mountbar_struct *mb);


#endif	/* MOUNTBAR_H */
