/*
	      Endeavour Operation History Events List
 */

#ifndef EDVHISTORY_H
#define EDVHISTORY_H

#include <glib.h>
#include "edvtypes.h"


/*
 *	History item structure:
 */
typedef struct {

	edv_history_type	type;	/* One of EDV_HISTORY_* */

	gulong		time_start,	/* Time the operation first started */
			time_end;	/* Time the operation ended */

	/* Result of operation, valid codes are:
	 *
	 *	0	Success
	 *	-1	General error
	 *	-2	Ambiguous, bad value, unable to interprite, etc
	 *	-3	Systems error
	 *	-4	Cancel, abort, or user response not available
	 *	-5	User responded with `No'
	 *	-6	Operation would cause re-entry
	 */
	gint		status;

	/* Full path to source and target objects in most cases
	 *
	 * If the object is a recycled object then one of these may be
	 * a string specifying an index number of the recycled object
	 *
	 * If the object is an archive object then one of these may be
	 * a relative (but complete) path to the archive object within
	 * the archive
 	 */
	gchar		*src_path,
			*tar_path;

	gchar		*comments;

} edv_history_struct;
#define EDV_HISTORY(p)	((edv_history_struct *)(p))


extern edv_history_struct *EDVHistoryNew(void);
extern edv_history_struct *EDVHistoryCopy(const edv_history_struct *h);
extern void EDVHistoryDelete(edv_history_struct *h);

extern void EDVHistorySetValues(
	edv_history_struct *h,
	gint type,
	gulong time_start,	/* In systime seconds */
	gulong time_end,	/* In systime seconds */
	gint status,
	const gchar *src_path,	/* Source */
	const gchar *tar_path,	/* Target */
	const gchar *comments
);

extern edv_history_struct *EDVHistoryListAppendNew(
	edv_history_struct ***list, gint *total,
	gint *n, gint max
);


#endif	/* EDVHISTORY_H */
