/*
 *	Prints a list of all recycled objects found in the recycle bin.
 *
 *	Use "recover" to recover a recycled object or "purge" to
 *	permanently purge a recycled object.
 */

#include <sys/stat.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	gchar **path;
	struct stat **stat_buf;
	guint *index;
	gint i, total = 0;

	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	/* Get a list of all recycled objects, here we obtain each
	 * recycled object's index, original full path, and statistics
	 *
	 * The returned path strings, statistics structures, and the
	 * pointer arrays must be deleted.
	 */
	EDVRecycledObjectStatAll(
	    ctx, &path, &index, &stat_buf, &total
	);
	for(i = 0; i < total; i++)
	{
	    g_print(
		"#%i\t%s\t%ld bytes\n",
		index[i], path[i], stat_buf[i]->st_size
	    );

	    g_free(path[i]);
	    g_free(stat_buf[i]);
	}
	g_free(path);
	g_free(index);
	g_free(stat_buf);

#if 0
	g_print(
	    "%i recycled object%s found\n",
	    i,
	    (i == 1) ? "" : "s"
	);
#endif

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
