/*
		   Endeavour Find Objects Window

	Used for finding objects by name or grep'ing for a string
	contained within.
 */

#ifndef FINDWIN_H
#define FINDWIN_H

#include <gtk/gtk.h>
#include "statusbar.h"
#include "edvtypes.h"


/*
 *	Find Window Operations:
 */
typedef enum {
	EDV_FINDWIN_FIND_OBJECT_NAME,
	EDV_FINDWIN_FIND_OBJECT_CONTENT
} edv_findwin_operation;

/*
 *	Find Window Roles:
 */
typedef enum {
	EDV_FINDWIN_ROLE_DISK_OBJECT,
	EDV_FINDWIN_ROLE_RECYCLED_OBJECT,
	EDV_FINDWIN_ROLE_ARCHIVE_OBJECT
} edv_findwin_role;


/*
 *	Maximum columns on the results clist:
 */
#define DEV_FINDWIN_RESULTS_LIST_COLUMNS_MAX	5

/*
 *	Find Window:
 */
typedef struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count;
	gpointer	core_ptr;

	gint		stop_count;

	gboolean	status_bar_map_state;

	GtkWidget	*main_vbox,

			*find_op_combo,
			*search_combo,
			*location_combo,

			*case_sensitive_check,
			*recursive_check,

			*search_btn, *stop_btn, *clear_btn, *close_btn,

			*results_clist,

			*open_btn, *open_with_btn, *goto_btn;

	/* Results clist right click menu */
	GtkWidget	*results_clist_menu,
			*results_clist_open_mi,
			*results_clist_open_with_mi,
			*results_clist_goto_mi;

	/* Status Bar */
	edv_statusbar_struct *status_bar;

	/* Reference browser index number (only one may be non-negative) */
	gint		browser_num,
			imbr_num,
			recbin_num,
			archiver_num;

	/* Find role code, one of EDV_FNIDWIN_ROLE_* */
	edv_findwin_role	role;

	/* Find operation code, one of EDV_FINDWIN_FIND_* */
	edv_findwin_operation	find_op;

	/* Last known write protect state, can be -1 to indicate
	 * undefined
	 */
	gint		last_write_protect_state;

} edv_findwin_struct;
#define EDV_FINDWIN(p)	((edv_findwin_struct *)(p))


extern gchar *EDVFindWinCurrentSearch(edv_findwin_struct *fw);
extern void EDVFindWinSetSearch(
	edv_findwin_struct *fw, const gchar *s,
	gboolean record_history
);

extern gchar *EDVFindWinCurrentLocation(edv_findwin_struct *fw);
extern void EDVFindWinSetLocation(
	edv_findwin_struct *fw, const gchar *path,
	gboolean record_history
);

extern edv_findwin_operation EDVFindWinCurrentOperation(
	edv_findwin_struct *fw
);

extern void EDVFindWinSetReferenceWindow(
	edv_findwin_struct *fw,
	gint browser_num,
	gint imbr_num,
	gint recbin_num,
	gint archive_num
);

extern void EDVFindWinListResetColumns(
	edv_findwin_struct *fw, edv_findwin_operation operation
);
extern void EDVFindWinListAppend(
	edv_findwin_struct *fw,
	const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt, gint line_index
);
extern void EDVFindWinListClear(edv_findwin_struct *fw);

extern void EDVFindWinSyncConfiguration(edv_findwin_struct *fw);

extern edv_findwin_struct *EDVFindWinNew(gpointer core_ptr);
extern void EDVFindWinUpdateMenus(edv_findwin_struct *fw);
extern void EDVFindWinSetBusy(edv_findwin_struct *fw, gboolean is_busy);
extern gboolean EDVFindWinIsMapped(edv_findwin_struct *fw);
extern void EDVFindWinMap(edv_findwin_struct *fw);
extern void EDVFindWinUnmap(edv_findwin_struct *fw);
extern void EDVFindWinDelete(edv_findwin_struct *fw);


#endif	/* FINDWIN_H */
