/*
	                   Endeavour Image Browser
 */

#ifndef IMBR_H
#define IMBR_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "edvtypes.h"
#include "toolbar.h"
#include "mountbar.h"
#include "findbar.h"
#include "tlist.h"
#include "imgview.h"
#include "statusbar.h"
#include "fopdlg.h"


typedef struct _edv_imbr_struct		edv_imbr_struct;
typedef struct _edv_imbr_opid_struct	edv_imbr_opid_struct;


/*
 *	Image Browser Operations:
 */
typedef enum {

	EDV_IMBR_OP_NONE			= 0,
	EDV_IMBR_OP_SEPARATOR			= 100,

	EDV_IMBR_OP_CLOSE			= 200,
	EDV_IMBR_OP_EXIT			= 201,

	EDV_IMBR_OP_SYNC_DISKS			= 300,
        EDV_IMBR_OP_HISTORY			= 301,
	EDV_IMBR_OP_RUN				= 302,
	EDV_IMBR_OP_RUN_TERMINAL		= 303,
	EDV_IMBR_OP_WRITE_PROTECT		= 304,

	EDV_IMBR_OP_NEW				= 400,
	EDV_IMBR_OP_NEW_FILE			= 401,
	EDV_IMBR_OP_NEW_DIRECTORY		= 402,
	EDV_IMBR_OP_NEW_LINK			= 403,
	EDV_IMBR_OP_NEW_FIFO			= 404,
	EDV_IMBR_OP_NEW_DEVICE_BLOCK		= 405,
	EDV_IMBR_OP_NEW_DEVICE_CHARACTER	= 406,
	EDV_IMBR_OP_NEW_SOCKET			= 407,

	EDV_IMBR_OP_OPEN			= 500,
	EDV_IMBR_OP_OPEN_WITH			= 501,

        EDV_IMBR_OP_COPY_PATH			= 600,
        EDV_IMBR_OP_COPY_URL			= 601,
        EDV_IMBR_OP_PASTE			= 610,

	EDV_IMBR_OP_MOVE			= 700,
	EDV_IMBR_OP_COPY			= 701,
	EDV_IMBR_OP_LINK			= 702,
	EDV_IMBR_OP_RENAME			= 703,
	EDV_IMBR_OP_CHMOD			= 704,
	EDV_IMBR_OP_CHOWN			= 705,
	EDV_IMBR_OP_DELETE			= 706,
	EDV_IMBR_OP_PROPERTIES			= 707,

        EDV_IMBR_OP_SELECT_ALL			= 800,
        EDV_IMBR_OP_UNSELECT_ALL		= 801,
        EDV_IMBR_OP_INVERT_SELECTION		= 802,
	EDV_IMBR_OP_FIND			= 850,

        EDV_IMBR_OP_DOWNLOAD			= 900,

	EDV_IMBR_OP_REFRESH			= 1000,
	EDV_IMBR_OP_REFRESH_ALL			= 1001,
        EDV_IMBR_OP_GOTO_PARENT			= 1100,
        EDV_IMBR_OP_GOTO_HOME			= 1101,
	EDV_IMBR_OP_STOP			= 1200,
	EDV_IMBR_OP_CONTINUE			= 1201,
	EDV_IMBR_OP_PRESENTATION_MODE		= 1280,

	EDV_IMBR_OP_SHOW_TOOL_BAR		= 1300,
	EDV_IMBR_OP_SHOW_LOCATION_BAR		= 1301,
	EDV_IMBR_OP_SHOW_MOUNT_BAR		= 1302,
	EDV_IMBR_OP_SHOW_FIND_BAR		= 1303,
	EDV_IMBR_OP_SHOW_STATUS_BAR		= 1304,

	EDV_IMBR_OP_SHOW_HIDDEN_OBJECTS		= 1401,
	EDV_IMBR_OP_SHOW_NOACCESS_OBJECTS	= 1402,
	EDV_IMBR_OP_SHOW_NONIMAGE_OBJECTS	= 1403,

        EDV_IMBR_OP_MOUNT			= 1600,	/* Mount/unmount */
        EDV_IMBR_OP_EJECT			= 1620,
        EDV_IMBR_OP_DEVICE_CHECK		= 1650,
        EDV_IMBR_OP_DEVICE_TOOLS		= 1651,
        EDV_IMBR_OP_DEVICE_FORMAT		= 1652,

	EDV_IMBR_OP_MIME_TYPES			= 1700,
	EDV_IMBR_OP_DEVICES			= 1701,

	EDV_IMBR_OP_NEW_BROWSER			= 1800,
	EDV_IMBR_OP_NEW_IMBR			= 1801,
	EDV_IMBR_OP_NEW_ARCHIVER		= 1802,
	EDV_IMBR_OP_RECYCLE_BIN			= 1900,

	EDV_IMBR_OP_OPTIONS			= 2000,
	EDV_IMBR_OP_CUSTOMIZE			= 2001,

	EDV_IMBR_OP_HELP_CONTENTS		= 3000,
	EDV_IMBR_OP_HELP_FILE_BROWSER	 	= 3010,
	EDV_IMBR_OP_HELP_IMAGE_BROWSER		= 3011,
	EDV_IMBR_OP_HELP_ARCHIVER		= 3012,
	EDV_IMBR_OP_HELP_RECYCLE_BIN		= 3030,
	EDV_IMBR_OP_HELP_KEYS_LIST		= 3050,
	EDV_IMBR_OP_HELP_MIME_TYPES		= 3051,
	EDV_IMBR_OP_HELP_DEVICES		= 3052,
	EDV_IMBR_OP_HELP_COMMON_OPERATIONS	= 3053,
        EDV_IMBR_OP_HELP_ABOUT			= 3100

} edv_imbr_op;


/*
 *	Image Browser Operation ID:
 */
struct _edv_imbr_opid_struct {

	edv_imbr_op	op;
	edv_opid_flags	flags;
	toolbar_item_type	tb_item_type;
	edv_imbr_struct	*imbr;

	/* Operation callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	/* Enter and leave notify callbacks */
	void	(*enter_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);
	void	(*leave_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	gchar		*button_name,	/* Name on a button */
			*menu_name,	/* Name on a menu item */
			*tooltip;	/* Tool tip or description (one line) */

	guint		accel_key,	/* Accelerator key */
			accel_mods;	/* Accelerator key modifiers */ 

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

};
#define EDV_IMBR_OPID(p)	((edv_imbr_opid_struct *)(p))

/*
 *	Image Browser:
 */
struct _edv_imbr_struct {

	GtkWidget	*toplevel;
	gboolean	processing;
	gint		busy_count,
			passive_busy_count,
			freeze_count;
	gpointer	core_ptr;

	GList		*opid_list;

	gint		stop_count;
	guint		loading_tocb;

	gboolean	tool_bar_map_state,
			location_bar_map_state,
			mount_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;

	GtkWidget	*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox */

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*mount_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,	/* GtkHBox parent for location bar */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,

			*main_paned;		/* GtkHPaned */

	/* Menu Bar Items */
	GtkWidget	*open_mi,
			*open_with_mi,
			*new_object_submi,
			*new_object_submenu,
			*new_file_mi,
			*new_directory_mi,
			*new_link_mi,
			*new_fifo_mi,
			*new_device_block_mi,
			*new_device_character_mi,
			*new_socket_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*move_mi,
			*copy_mi,
			*link_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*delete_mi,
			*copy_path_mi,
			*copy_url_mi,
			*paste_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*mount_mi,
			*eject_mi,
			*device_check_mi,
			*device_tools_mi,
			*device_format_mi,
			*devices_mi,

			*stop_mi,
			*continue_mi,
			*presentation_mode_mi,
			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_mount_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*show_hidden_objects_micheck,
			*show_noaccess_objects_micheck,
			*show_nonimage_objects_micheck,
			*mime_types_mi,

			*write_protect_mi,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_contents_mi,
			*help_image_browser_mi,
			*help_keys_list_mi,
			*help_mime_types_mi,
			*help_devices_mi,
			*help_common_operations_mi,
			*help_about_mi;

        /* Tool Bar */
        toolbar_struct	*tool_bar;

        /* Mount Bar */
        edv_mountbar_struct	*mount_bar;

        /* Find Bar */
        edv_findbar_struct	*find_bar;

	/* Thumbs List */
	tlist_struct	*tlist;

	/* Image Viewer */
	imgview_struct	*imgview;


	/* Right-click menu */
	GtkWidget	*tlist_menu,
			*tlist_open_mi,
			*tlist_open_with_mi,
			*tlist_mount_mi,
			*tlist_eject_mi,
			*tlist_mount_misep,
			*tlist_move_mi,
			*tlist_copy_mi,
			*tlist_link_mi,
			*tlist_rename_mi,
			*tlist_chmod_mi,
			*tlist_chown_mi,
			*tlist_delete_mi,
			*tlist_copy_path_mi,
			*tlist_copy_url_mi,
			*tlist_paste_mi,
			*tlist_properties_mi;

	/* Icons used in the thumbs list */
	GdkPixmap	*folder_parent_pixmap;
	GdkBitmap	*folder_parent_mask;
	GdkPixmap	*folder_noaccess_pixmap;
	GdkBitmap	*folder_noaccess_mask;
	GdkPixmap	*file_badimage_pixmap;
	GdkBitmap	*file_badimage_mask;

	/* Last selected thumb (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		tlist_selected_thumb;

	/* Selected device, reflects the device of the disk object of
	 * the selected thumb
	 *
	 * The device number corresponds with a device on the core's
	 * list of devices
	 */
	gint		selected_dev_num;


	/* Last known items in recycle bin, this is used as a quick
	 * access value to check if the recycle bin has contents or
	 * not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_recbin_items;

	/* Last known write protect state (can be -1 for unknown) */
	gint		last_write_protect_state;


	/* Status Bar */
	edv_statusbar_struct	*status_bar;


	/* File Operation Dialog */
	edv_fopdlg_struct	*fopdlg;

};
#define EDV_IMBR(p)	((edv_imbr_struct *)(p))


extern edv_imbr_opid_struct *EDVImbrMatchOPID(
	edv_imbr_struct *imbr, edv_imbr_op op
);

extern void EDVImbrSetTitle(edv_imbr_struct *imbr, const gchar *path);

extern gchar *EDVImbrCurrentLocation(edv_imbr_struct *imbr);
extern void EDVImbrSetLocation(
	edv_imbr_struct *imbr,
	const gchar *path, gboolean record_history
);
extern void EDVImbrUpdateLocationIcon(
	edv_imbr_struct *imbr, const gchar *path
);

extern void EDVImbrAccelkeysRegenerate(edv_imbr_struct *imbr);
extern void EDVImbrToolbarRegenerate(edv_imbr_struct *imbr);
extern void EDVImbrNewObjectMenuRegenerate(edv_imbr_struct *imbr);
extern void EDVImbrTListMenuRegenerate(edv_imbr_struct *imbr);

extern void EDVImbrSyncConfiguration(edv_imbr_struct *imbr);

extern void EDVImbrQueueLoadingProcess(edv_imbr_struct *imbr);

extern void EDVImbrSelectPath(
	edv_imbr_struct *imbr, const gchar *path
);

extern GList *EDVImbrOPIDListNew(
	edv_imbr_struct *imbr			/* Can be NULL */
);
extern void EDVImbrOPIDListDelete(GList *glist);

extern cfg_accelkey_list_struct *EDVImbrAccelkeysListNewDefault(void);

extern edv_imbr_struct *EDVImbrNew(gpointer core_ptr);
extern void EDVImbrSyncData(edv_imbr_struct *imbr);
extern void EDVImbrUpdateMenus(edv_imbr_struct *imbr);
extern void EDVImbrSetBusy(edv_imbr_struct *imbr, gboolean busy);
extern void EDVImbrSetPassiveBusy(edv_imbr_struct *imbr, gboolean busy);
extern gboolean EDVImbrIsMapped(edv_imbr_struct *imbr);
extern void EDVImbrMap(edv_imbr_struct *imbr);
extern void EDVImbrUnmap(edv_imbr_struct *imbr);
extern void EDVImbrDelete(edv_imbr_struct *imbr);


#endif	/* IMBR_H */
