/*
				Device Mounting
 */

#ifndef EDVMOUNT_H
#define EDVMOUNT_H

#include <glib.h>
#include "edvdevices.h"
#include "edvcontext.h"


/*
 *	Returns a string describing the last error encountered or NULL
 *	if there was no error.
 *
 *	The returned pointer must not be modified or deleted.
 */
extern const gchar *EDVMountGetError(void);

/*
 *	Mounts the specified device.
 *
 *	If notify is set to TRUE then a "object_mounted_notify" will
 *	be queued on the context (only on success).
 *
 *	Returns 0 on success and non-zero on error.
 */
extern gint EDVMount(
	edv_context_struct *ctx, edv_device_struct *dev_ptr,
	gboolean notify
);

/*
 *	Unmounts the specified device.
 *
 *	If notify is set to TRUE then a "object_unmounted_notify" will
 *	be queued on the context (only on success).
 *
 *	Returns 0 on success and non-zero on error. 
 */
extern gint EDVUnmount(
	edv_context_struct *ctx, edv_device_struct *dev_ptr,
	gboolean notify
);

/*
 *	Ejects the media from the specified device.
 *
 *	If the device is mounted then you must call EDVUnmount() to
 *	unmount the device before ejecting it.
 *
 *	Returns 0 on success and non-zero on error.
 */
extern gint EDVEject(
	edv_context_struct *ctx, edv_device_struct *dev_ptr
);


#endif	/* EDVMOUNT_H */
