/*
	    Object Copying, Moving, Linking, Renaming, Chowning, etc

	See edv_recbin_delete.h for object deleting.
 */

#ifndef EDV_OBJ_OP_H
#define EDV_OBJ_OP_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern const gchar *EDVObjectOPGetError(void);

extern gint EDVObjectOPCopy(
	edv_core_struct *core,
	const gchar *src_obj, const gchar *tar_obj,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPMove(
	edv_core_struct *core,
	const gchar *src_obj, const gchar *tar_obj,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPLink(
	edv_core_struct *core,
	const gchar *path,
	const gchar *dest_path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPRelink(
	edv_core_struct *core,
	const gchar *path,
	const gchar *new_dest_value,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPRename(
	edv_core_struct *core,
	const gchar *path,
	const gchar *new_name,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPChmod(
	edv_core_struct *core,
	const gchar *path,
	const edv_permission_flags permissions,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all, const gboolean recursive
);
extern gint EDVObjectOPChOwn(
	edv_core_struct *core,
	const gchar *path,
	const gint owner_id, const gint group_id,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all, const gboolean recursive
);
extern gint EDVObjectOPChTime(
	edv_core_struct *core,
	const gchar *path,
	const gulong atime, const gulong mtime,
	GtkWidget *toplevel,
        const gboolean show_progress, const gboolean interactive,
        gboolean *yes_to_all, const gboolean recursive
);


#endif	/* EDV_OBJ_OP_H */
