#include <glib.h>
#include "../../include/string.h"
#include "edv_context.h"
#include "edv_help.h"
#include "config.h"


void EDVHelpSubject(
	edv_context_struct *ctx, const gchar *subject
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Maps the help browser and displays the help file specified by
 *	the given subject.
 */
void EDVHelpSubject(
	edv_context_struct *ctx, const gchar *subject
)
{
	gchar *cmd;

	if(ctx == NULL)
	    return;

	if(STRISEMPTY(subject))
	    subject = "Contents";

	cmd = g_strdup_printf(
	    "help \"%s\"",
	    subject
	);
	EDVContextQueueCommand(ctx, cmd);
	g_free(cmd);
}

