#include <string.h>
#include <gtk/gtk.h>

#include "guiutils.h"
#include "pulist.h"
#include "csd.h"
#include "fsd.h"
#include "stacklist.h"
#include "keymap_list.h"

#include "cfg.h"
#include "edv_types.h"
#include "edv_generic_options_win.h"
#include "imbr.h"
#include "customize_win.h"
#include "endeavour2.h"
#include "edv_utils.h"
#include "edv_utils_gtk.h"
#include "edv_cfg_list.h"
#include "config.h"


typedef struct {
	edv_core_struct	*core;
	GtkWidget	*drawing_area,
			*show_frame_check,
			*show_label_check;
	GtkAdjustment	*width_adj,
			*height_adj,
			*border_adj;
} ThumbSampleData;
#define THUMB_SAMPLE_DATA(p)	((ThumbSampleData *)(p))
#define THUMB_SAMPLE_DATA_KEY	"thumb_sample_data"


/* Image Browser */
void EDVCustomizeImbrCreatePresentationPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);
static void EDVCustomizeImbrKeymapsDefaultsCB(
	keymap_list_struct *kmlist, keymap_key_struct *km,
	gpointer data
);
void EDVCustomizeImbrCreateKeymapsPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);
static void EDVCustomizeImbrThumbSampleDataDestroyCB(gpointer data);
static gint EDVCustomizeImbrThumbSampleEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void EDVCustomizeImbrThumbSampleUpdateCB(
	GtkWidget *widget, gpointer data
);
static void EDVCustomizeImbrThumbValueChangedCB(
	GtkAdjustment *adj, gpointer data
);
static void EDVCustomizeImbrThumbSampleDraw(ThumbSampleData *d);
static void EDVCustomizeImbrThumbSampleQueueDraw(ThumbSampleData *d);
void EDVCustomizeImbrCreateThumbsListPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);
void EDVCustomizeImbrCreateToolBarPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);
void EDVCustomizeImbrCreateAppearancePage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates the Image Browser Presentation Page.
 */
void EDVCustomizeImbrCreatePresentationPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint      border_major = 5,
			border_minor = 2;
	gint i, label_width;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3, *parent4, *parent5, *parent6;
        pulist_struct *pulist;           
        pulistbox_struct *pulistbox;
	edv_gen_opt_wref_struct *wref;


	/* GtkHBox for two columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* Left column GtkVBox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Show GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Exposicio'n"
#elif defined(PROG_LANGUAGE_FRENCH)
"Spectacle"
#elif defined(PROG_LANGUAGE_GERMAN)
"Schau"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vertoning"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exposicao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Show"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Navigator */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Controle La Barra"
#elif defined(PROG_LANGUAGE_FRENCH)
"Contro^ler La Barre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Steuerstab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare La Sbarra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controlert U De Bar"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Controle Barra"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Styr Bar"
#else
"Navigator"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
	    w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto mostrar inicialmente la Barra del Control al cambiar\
 to el Modo de la Presentacio'n"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ve'rifier ceci au de'but pour montrer le Mode de Pre'sentation a`\
 la Barre de Contro^le en changant to"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prufen sie dies anfanglich, den steuerstab beim schalten to der\
 Vorstellungsmodus zu zeigen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo inizialmente per mostrare la Sbarra di Controllo\
 quando to di commutare il Modo di Presentazione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controlert u dit eerst om de Controle Bar wanneer schakelen to de\
 Voorstelling Modus te tonen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto inicialmente mostrar a Barra de Controle quando\
 troca to o Modo de Apresentacao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette f?rste vise styringsBar ved kople av to\
 framstillingsModus"
#else
"Check this to initially show the Navigator at the startup of the\
 Presentation Mode"
#endif
	);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_SHOW_NAVIGATOR
	);

	/* Fonts GtkFrame */
	w = gtk_frame_new("Fonts");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Standard */
	w = FSDPromptNewSimple(
	    "Standard:",	/* Label */
	    80,			/* Label width */
	    200			/* Entry width */
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w); 
	w = FSDPromptGetEntry(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_EDITABLE, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_FONT
	);


	/* Colors GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Colores"
#elif defined(PROG_LANGUAGE_FRENCH)
"Couleurs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Farben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Colori"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kleuren"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Cores"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Farger"
#else
"Colors"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;       

	label_width = 80;

	/* Foreground */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_usize(w, label_width, -1);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent6 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Primera Plana"
#elif defined(PROG_LANGUAGE_FRENCH)
"Premier Plan"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vordergrund"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Primo Piano"
#elif defined(PROG_LANGUAGE_DUTCH)
"Voorgrond"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Cho De Frente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forgrunn"
#else
"Foreground"
#endif
	    ":"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_container_add(GTK_CONTAINER(parent6), w);
	gtk_widget_show(w);
	/* Color Button */
	w = CSDColorButtonNewSimple(NULL, -1);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_COLOR_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_COLOR_FG
	);
	/* Invert */
	w = gtk_toggle_button_new_with_label("Invert");
	gtk_widget_set_usize(w, 60, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
	    w,
"Check this to invert the foreground color, useful when colors\
 match the foreground color and make it indistinguishable"
	);
	gtk_widget_show(w);                                      
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_COLOR_FG_INVERT
	);

	/* Background */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);                                      
	parent5 = w;
	w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_usize(w, label_width, -1);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent6 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Fondo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrire-Plan"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hintergrund"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Sfondo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Achtergrond"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cho Posterior"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bakgrunn"
#else
"Background"
#endif
	    ":"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_container_add(GTK_CONTAINER(parent6), w);
	gtk_widget_show(w);
	/* Color Button */
	w = CSDColorButtonNewSimple(NULL, -1);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_COLOR_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_COLOR_BG
	);


	/* Automation GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Automatizacio'n"
#elif defined(PROG_LANGUAGE_FRENCH)
"Automation"
#elif defined(PROG_LANGUAGE_GERMAN)
"Automation"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Automazione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Automatisering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Automacao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Automatikk"
#else
"Automation"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	label_width = 130;

	/* Transision */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Label */
	w = gtk_label_new("Transision:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Transision Popup List Box */
        pulistbox = PUListBoxNew(parent4, 200, -1);
        pulist = PUListBoxGetPUList(pulistbox);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
	    PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);
        i = PUListAddItem(pulist, "None");
        i = PUListAddItem(pulist, "Fade To Black");
        i = PUListAddItem(pulist, "Fade To White");
        i = PUListAddItem(pulist, "Fade To Background");
        i = PUListAddItem(pulist, "Move Horizontal");
        i = PUListAddItem(pulist, "Move Vertical");
        i = PUListAddItem(pulist, "Move Diagonal");
        PUListBoxSetLinesVisible(pulistbox, MIN((i + 1), 10));
        PUListBoxMap(pulistbox);
        wref = EDVGenOptWinWRefAppend(
            optwin,
            EDV_GEN_OPT_WIDGET_POPUP_LIST_BOX, pulistbox,
            NULL,
            EDV_CFG_PARM_PRESENTATION_TRANSISION
        );

	/* Transision Interval GtkLabel */
	w = gtk_label_new("Interval:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Transision Interval GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    1.0f, 1.0f, (gfloat)((guint32)-1),
	    10.0f, 100.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
	    w,
"Set the transision interval (in milliseconds)"
	);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_SPIN_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_TRANSISION_INT
	);
	/* Units GtkLabel */
	w = gtk_label_new("milliseconds");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);



	/* Hide Pointer Delay */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_usize(w, label_width, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* GtkLabel */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Esconda La Demora De La Flecha"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cacher Le Retard De Pointeur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verstecken Sie Zeigerverspatung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Nascondere Il Ritardo Di Indicatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbergt U De Wijzer Vertraging"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Esconda Demora De Indicacao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemm viserUtsettelse"
#else
"Hide Pointer Delay"
#endif
	    ":"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	/* Hide Pointer Delay GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, 0.0f, (gfloat)((guint32)-1),
	    1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
	    w,
#if defined(PROG_LANGUAGE_SPANISH)
"Ponga la demora en la que la flecha se escondera despues que una\
 falta del movimiento de la flecha o pondra la demora a 0 nunca\
 esconder la flecha"
#elif defined(PROG_LANGUAGE_FRENCH)
"Regler le retard dans lequel le pointeur sera cache apres un manque\
 de mouvement de pointeur ou a regle le retard a 0 ne jamais cacher\
 le pointeur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Setzen sie die verspatung, in dem der zeiger versteckt werden wird,\
 nachdem ein mangel von zeigerbewegung oder die verspatung zu 0 nie\
 setzen, den Zeiger zu verstecken"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Regolare il ritardo in cui l'indicatore sara nascosto dopo che una\
 mancanza di movimento di indicatore o regolare il ritardo a 0 non\
 mai nascondere l'indicatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zett u de vertraging waarin de wijzer verborgen worden zal nadat een\
 tekort van wijzer beweging of de vertraging tot 0 nooit zett u om de\
 wijzer te verbergen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ponha a demora em que a indicacao sera escondida depois que uma\
 falta de movimento de indicac,a~o ou po~e a demora a 0 nunca esconder\
 a indicacao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sett utsettelsen som viseren gjemt etter et mangel av viserbevegelse\
 eller sett utsettelsen til 0 aldri i gjemme viseren"
#else
"Set the delay (in seconds) in which the pointer will be hidden\
 after a lack of pointer motion or set the delay to 0 to never\
 hide the pointer"
#endif
	);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_SPIN_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_HIDE_POINTER_DELAY
	);
	/* Units Label */
	w = gtk_label_new("seconds");
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Slideshow & Slideshow Delay */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_usize(w, label_width, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	parent5 = w;
	/* Slideshow GtkCheckButton */
	w = gtk_check_button_new_with_label("Slideshow");
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
	    w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto empezar exposicion de diapositivas en el inicio del\
 Modo de la Presentacion"
#elif defined(PROG_LANGUAGE_FRENCH)
"Verifier ceci pour commencer le diaporama au demarrage du Mode de\
 Presentation"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prufen sie dies, diavortrag am start vom Vorstellungsmodus anzufangen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per cominciare lo slideshow allavvio del Modo di\
 Presentazione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controlert u dit om slideshow aan de start van de Voorstelling Modus\
 te beginnen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto comecar slideshow no lanc,amento do Modo de\
 Apresentacao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette starte slideshow pa oppstartingen av framstillingsModus"
#else
"Check this to start the slideshow at the startup of the Presentation\
 Mode"
#endif
	);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_SLIDESHOW
	);
	/* Slideshow Delay GtkLabel */
	w = gtk_label_new("Delay:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Slideshow Delay GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
	    0.0f, 1.0f, 100000.0f,
	    1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
	    w,
#if defined(PROG_LANGUAGE_SPANISH)
"Ponga la demora a demostrar la proxima imagen en una exposicion de\
 diapositivas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Regler le retard dans affichant limage prochaine dans un diaporama"
#elif defined(PROG_LANGUAGE_GERMAN)
"Setzen sie die verspatung beim Darstellen das nachste bildnis in\
 einem diavortrag"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Regolare il ritardo in mostrando la prossima immagine in uno slideshow"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zett u de vertraging in het tonen van het volgende beeld in een\
 slideshow"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ponha a demora em exibir a proxima imagem num slideshow"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sett utsettelsen ved vise det neste avbildet i en slideshow"
#else
"Set the delay (in seconds) in displaying the next image during a\
 slideshow"
#endif
	);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_SPIN_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_PRESENTATION_SLIDESHOW_DELAY
	);
	/* Units GtkLabel */
	w = gtk_label_new("seconds");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);





}

/*
 *	Keymaps List defaults callback.
 */
static void EDVCustomizeImbrKeymapsDefaultsCB(
	keymap_list_struct *kmlist, keymap_key_struct *km,
	gpointer data
)
{
	gint op;
	GList *glist;
	cfg_accelkey_struct *ak;
	cfg_accelkey_list_struct *ak_list;
	edv_core_struct *core = EDV_CORE(data);
	if((kmlist == NULL) || (km == NULL) || (core == NULL))
	    return;

	op = (gint)km->data;
	ak_list = EDVImbrAccelkeysListNewDefault();
	if(ak_list == NULL)
	    return;

	for(glist = ak_list->list; glist != NULL; glist = g_list_next(glist))
	{
	    ak = CFG_ACCELKEY(glist->data);
	    if(ak == NULL)
		continue;

	    if(ak->opid == op)
	    {
		km->keyval = ak->key;
		km->state = ak->modifiers;
		break;
	    }
	}

	CFGAccelkeyListDelete(ak_list);
}

/*
 *	Creates the Image Browser Keymaps page.
 */
void EDVCustomizeImbrCreateKeymapsPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint      border_major = 5,
			border_minor = 2;
	GList *opid_list;
	GtkWidget *w, *parent2;
	const cfg_item_struct *cfg_list = core->cfg_list;       
	cfg_accelkey_list_struct *ak_list;        
	edv_gen_opt_wref_struct *wref;
	keymap_list_struct *kmlist;
	edv_imbr_opid_struct *opid;


	/* Accelerator Keys frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Acelerador Adapta"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Accelerateur Saisit"
#elif defined(PROG_LANGUAGE_GERMAN)
"Beschleuniger Gibt Ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiavi Di Acceleratore"
#elif defined(PROG_LANGUAGE_DUTCH)
"De Versneller Stemt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Teclas De Acelerador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Akselerator Fester"
#else
"Accelerator Keys"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create the Keymap List */
	kmlist = KeymapListNew(     
	    parent2,
	    GTK_ORIENTATION_HORIZONTAL
	);
	KeymapListSetEditable(kmlist, TRUE);
	KeymapListSetAutoCheckConflicts(kmlist, TRUE);
	KeymapListSetKeyDefaultRequestCB(             
	    kmlist,
	    EDVCustomizeImbrKeymapsDefaultsCB,
	    core
	);
	KeymapListMap(kmlist);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_KEYMAP_LIST, kmlist,
	    NULL,
	    EDV_CFG_PARM_IMBR_ACCELERATOR_KEYS
	);

	/* Add the Accelkeys to the Keymap List */
	KeymapListClear(kmlist);
	opid_list = EDVImbrOPIDListNew(NULL);
	ak_list = EDV_GET_ACCELKEY_LIST(
	    EDV_CFG_PARM_IMBR_ACCELERATOR_KEYS
	);
	if(ak_list != NULL)
	{
	    gint op;
	    GList *glist, *glist2, *ak_glist = ak_list->list;
	    cfg_accelkey_struct *ak;

	    /* Iterate through Operation IDs */
	    for(glist = opid_list;
		glist != NULL;
		glist = g_list_next(glist)
	    )
	    {
		opid = EDV_IMBR_OPID(glist->data);
		if(opid == NULL)
		    continue;

		if(opid->flags & EDV_OPID_NO_OP)
		    continue;

		/* Get the Operation Code */
		op = opid->op;

		/* Find an Accelkey for this Operation ID */
		for(glist2 = ak_glist;
		    glist2 != NULL;
		    glist2 = g_list_next(glist2)
		)
		{
		    ak = CFG_ACCELKEY(glist2->data);
		    if(ak == NULL)
			continue;

		    if(ak->opid == op)
		    {
			/* Add this Accelkey to the Keymap List */
			gchar *name = EDVCustomizeSimplifyOPIDName(
			    opid->menu_name
			);
			KeymapListAppend(
			    kmlist,
			    opid->button_icon_data,
			    name,
			    KeymapKeyNew(
				ak->key,
				ak->modifiers,
				(gpointer)op
			    )
			);
			g_free(name);
			break;
		    }
		}
	    }
	}
	EDVImbrOPIDListDelete(opid_list);



}

/*
 *	Image Browser Thumbs List thumb sample "destroy" signal
 *	callback.
 */
static void EDVCustomizeImbrThumbSampleDataDestroyCB(gpointer data)
{
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	g_free(d);
}

/*
 *	Image Browser Thumbs List Sample Thumb event signal callback.
 */
static gint EDVCustomizeImbrThumbSampleEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	gint status = FALSE;
	GdkEventConfigure *configure;
	GdkEventExpose *expose;
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if((widget == NULL) || (event == NULL) || (d == NULL))
	    return(status);

	switch((gint)event->type)
	{
	  case GDK_CONFIGURE:
	    configure = (GdkEventConfigure *)event;
	    status = TRUE;
	    break;

	  case GDK_EXPOSE:
	    expose = (GdkEventExpose *)event;
	    EDVCustomizeImbrThumbSampleDraw(d);
	    status = TRUE;
	    break;

	}

	return(status);
}

/*
 *	Thumb update callback.
 *
 *	Called whenever a widget that reflects thumb appearance is
 *	modified.
 */
static void EDVCustomizeImbrThumbSampleUpdateCB(
	GtkWidget *widget, gpointer data
)
{
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	EDVCustomizeImbrThumbSampleQueueDraw(d);
}

/*
 *	Thumb size GdkAdjustment "value_changed" signal callback.
 */
static void EDVCustomizeImbrThumbValueChangedCB(
	GtkAdjustment *adj, gpointer data
)
{
	ThumbSampleData *d = THUMB_SAMPLE_DATA(data);
	if(d == NULL)
	    return;

	EDVCustomizeImbrThumbSampleQueueDraw(d);
}

/*
 *	Draws the Thumb Sample.
 */
static void EDVCustomizeImbrThumbSampleDraw(ThumbSampleData *d)
{
	gboolean show_frame, show_label;
	gint	width, height,
		thumb_width, thumb_height,
		thumb_border, thumb_iborder = 2;
	GdkWindow *window;
	GdkDrawable *drawable;
	GtkStateType state;
	GtkStyle *style;
	GtkWidget *w = (d != NULL) ? d->drawing_area : NULL;
	if(w == NULL)
	    return;

	width = w->allocation.width;
	height = w->allocation.height;
	window = w->window;
	state = GTK_WIDGET_STATE(w);
	style = gtk_widget_get_style(w);
	if((window == NULL) || (width <= 0) || (height <= 0) ||
	   (style == NULL)
	)
	    return;

	drawable = window;

	/* Get size adjustments */
	thumb_width = GTK_ADJUSTMENT_GET_VALUE(d->width_adj);
	thumb_height = GTK_ADJUSTMENT_GET_VALUE(d->height_adj);
	thumb_border = GTK_ADJUSTMENT_GET_VALUE(d->border_adj);

	/* Get show options */
	show_frame = GTK_TOGGLE_BUTTON_GET_ACTIVE(d->show_frame_check);
	show_label = GTK_TOGGLE_BUTTON_GET_ACTIVE(d->show_label_check);


	/* Begin drawing */

	/* Clear background */
	gdk_draw_rectangle(
	    drawable, style->base_gc[state], TRUE,
	    0, 0, width, height
	);

	if((thumb_width > 0) && (thumb_height > 0))
	{
	    const gint	x = (width / 2) - (thumb_width / 2),
			y = (height / 2) - (thumb_height / 2);
	    GdkFont *font = style->font;

	    /* Draw thumb frame or outline */
	    if(show_frame)
	    {
		gtk_draw_box(
		    style, drawable, state, GTK_SHADOW_OUT,
		    x, y, thumb_width, thumb_height
		);
		if(thumb_border >= 2)
#if 0
		    gtk_draw_box(
			style, drawable, state, GTK_SHADOW_IN,
			x + thumb_border, y + thumb_border,
			MAX(thumb_width - (2 * thumb_border), 10),
			MAX(thumb_height - (2 * thumb_border), 10)
		    );
#else
		    gdk_draw_rectangle(
			drawable, style->fg_gc[state], FALSE,
			x + thumb_border, y + thumb_border,
			MAX(thumb_width - (2 * thumb_border), 10),
			MAX(thumb_height - (2 * thumb_border), 10)
		    );
#endif
	    }
	    else
	    {
		gdk_draw_rectangle(   
		    drawable, style->fg_gc[state], FALSE,
		    x, y, thumb_width, thumb_height
		);
		if(thumb_border >= 2)
		    gdk_draw_rectangle(
			drawable, style->fg_gc[state], FALSE,
			x + thumb_border, y + thumb_border,
			MAX(thumb_width - (2 * thumb_border), 10),
			MAX(thumb_height - (2 * thumb_border), 10)
		    );
	    }

	    /* Draw "image" */
	    if(font != NULL)
	    {
		const gint font_height = font->ascent + font->descent;
		GdkRectangle rect2;
		GdkTextBounds b;
		GdkGC *gc;
		const gchar *s = "Image";

		gdk_string_bounds(font, s, &b);

		if(show_label)
		{
		    const gint image_height = MAX(
			thumb_height - (2 * thumb_border) -
			(5 * thumb_iborder) - font_height,
			0
		    );
		    rect2.width = MIN(
			b.width,
			thumb_width - (2 * thumb_border) - (2 * thumb_iborder)
		    );
		    rect2.height = font_height;
		    rect2.x = x + MAX(
			(thumb_width / 2) - (rect2.width / 2),
			0
		    );
		    rect2.y = y + thumb_border + thumb_iborder
			+ (image_height / 2) - (rect2.height / 2);
		}
		else
		{
		    rect2.width = b.width;
		    rect2.height = font_height;
		    rect2.x = x + MAX(
			(thumb_width / 2) - (rect2.width / 2),
			0
		    );
		    rect2.y = y + MAX(
			(thumb_height / 2) - (rect2.height / 2),
			0
		    );
		}

		gc = style->text_gc[state];
		gdk_gc_set_clip_rectangle(gc, &rect2);
		gdk_draw_string(            
		    drawable, font, gc,
		    (rect2.x + (rect2.width / 2) - (b.width / 2)) -
			b.lbearing,
		    rect2.y + font->ascent,
		    s
		);
		gdk_gc_set_clip_rectangle(gc, NULL);
	    }

	    /* Draw label */
	    if(show_label && (font != NULL))
	    {
		const gint font_height = font->ascent + font->descent;
		GdkRectangle rect2;
		GdkTextBounds b;
		GdkGC *gc;
		const gchar *s = "Label";

		gdk_string_bounds(font, s, &b);

		rect2.width = MAX(
		    thumb_width - (2 * thumb_border) -
		    (2 * thumb_iborder),
		    5
		);
		rect2.height = font_height + (2 * thumb_iborder);
		rect2.x = x + MAX(
		    (thumb_width / 2) - (rect2.width / 2),
		    0
		);
		rect2.y = y + MAX(
		    thumb_height - thumb_border -
		    thumb_iborder - rect2.height,
		    thumb_height / 2
		);

		gdk_draw_rectangle(
		    drawable, style->base_gc[state], TRUE,
		    rect2.x, rect2.y, rect2.width, rect2.height
		);

		gc = style->text_gc[state];
		gdk_gc_set_clip_rectangle(gc, &rect2);
		gdk_draw_string(
		    drawable, font, gc,
		    (rect2.x + (rect2.width / 2) - (b.width / 2)) -
			b.lbearing,
		    (rect2.y + thumb_iborder) + font->ascent,
		    s
		);
		gdk_gc_set_clip_rectangle(gc, NULL);

		if(show_frame)
		    gtk_draw_shadow(
			style, drawable, state, GTK_SHADOW_IN,
			rect2.x, rect2.y, rect2.width, rect2.height
		    );
		else
		    gdk_draw_rectangle(
			drawable, style->fg_gc[state], FALSE,
			rect2.x, rect2.y, rect2.width, rect2.height
		    );

	    }
	}

	/* Send drawable to window if drawable is not the window */
	if(drawable != window)
	    gdk_draw_pixmap(
		window, style->fg_gc[state], drawable,
		0, 0, 0, 0, width, height
	    );
}

/*
 *	Queues a draw for the Thumb Sample.
 */
static void EDVCustomizeImbrThumbSampleQueueDraw(ThumbSampleData *d)
{
	GtkWidget *w = (d != NULL) ? d->drawing_area : NULL;
	if(w != NULL)
	    gtk_widget_queue_draw(w);
}

/*
 *	Creates the Image Browser Thumbs List page.
 */
void EDVCustomizeImbrCreateThumbsListPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GSList *gslist;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3, *parent4, *parent5;
	ThumbSampleData *d;
	edv_gen_opt_wref_struct *wref;


	/* Create Thumb Sample Data */
	d = THUMB_SAMPLE_DATA(
	    g_malloc0(sizeof(ThumbSampleData))
	);   
	d->core = core;


	/* Hbox for multiple columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* Left column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Thumb Tiling Orientation Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Embaldosar La Orientacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Orientation Carrelant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tiling Orientierung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Che La Pavimentando Orientazione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tiling Orintatie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Orientao De Tiling"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tiling Orientering"
#else
"Thumb Tiling Orientation"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Horizontal */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Radio Button */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Horizontal"
#elif defined(PROG_LANGUAGE_FRENCH)
"Horizontal"
#elif defined(PROG_LANGUAGE_GERMAN)
"Horizontale"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Orizzontale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Horizontale Lijn"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Horizontal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Horisontal"
#else
"Horizontal"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL
	);
	wref->radio_value = TRUE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Vertical */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Radio Button */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Vertical"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vertical"
#elif defined(PROG_LANGUAGE_GERMAN)
"Senkrecht"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Verticale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vertikaal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Vertical"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vertikal"
#else
"Vertical"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL
	);
	wref->radio_value = FALSE;


	/* Display Thumb Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Pulgar Del Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Afficher Le Pouce"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stellen Sie Daumen Dar"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Pollice Di Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon Duim"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Polegar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis Tommelfinger"
#else
"Display Thumb"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;        

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Frame */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	d->show_frame_check = w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Marco"
#elif defined(PROG_LANGUAGE_FRENCH)
"Cadre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Rahmen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Cornice"
#elif defined(PROG_LANGUAGE_DUTCH)
"Omlijsting"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Armao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ramm Inn"
#else
"Frame"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES
	);

	/* Label */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	d->show_label_check = w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Etiqueta"
#elif defined(PROG_LANGUAGE_FRENCH)
"Etiquette"
#elif defined(PROG_LANGUAGE_GERMAN)
"Etikett"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Etichetta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Etiket"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Etiqueta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Merke"
#else
"Label"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS
	);


	/* Misc Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Variado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Divers"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verschieden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Miscellaneo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verscheiden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Miscelnea"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forskjellig"
#else
"Miscellaneous"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;

	/* Do Not Enlarge Thumbs */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"No Amplie Las Imgenes Pequeas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ne Pas Agrandir De Petites Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vergrern Sie Kleine Bildnisse Nicht"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Non Ingrandire Le Immagini Piccole"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vergroot Niet Kleine Beelden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"No Aumente Imagens Pequenas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forstrr Ikke Sm Avbilder"
#else
"Do Not Enlarge Small Images"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"No amplie el pulgar si la imagen verdadera es ms pequea"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ne pas agrandir le pouce si l'image vritable est plus petite"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vergrern sie den daumen nicht, wenn das eigentliche bildnis kleiner\
 ist"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Non ingrandire il pollice se l'immagine reale  pi piccola"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vergroot niet de duim indien de eigenlijke beeld kleiner is"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"No aumente o polegar se a imagem real  menor"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forstrr ikke tommelfingeren om det aktuelle avbildet er liten"
#else
"Do not enlarge the thumb if the actual image is smaller"
#endif
	);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE
	);


	/* Right column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Thumb Geometry Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Hojee La Geometra"
#elif defined(PROG_LANGUAGE_FRENCH)
"Gomtrie De Pouce"
#elif defined(PROG_LANGUAGE_GERMAN)
"Daumen Geometrie"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Sciupare La Geometria"
#elif defined(PROG_LANGUAGE_DUTCH)
"Duim Geometry"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Geometria De Polegar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tommelfinger Geometri"
#else
"Thumb Geometry"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_widget_show(w);
	parent3 = w;


	/* Prompts GtkHBox */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;


	/* Size prompts GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* Width GtkLabel */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Width"
#elif defined(PROG_LANGUAGE_FRENCH)
"Width"
#elif defined(PROG_LANGUAGE_GERMAN)
"Width"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Width"
#elif defined(PROG_LANGUAGE_DUTCH)
"Width"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Width"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Width"
#else
"Width"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Width GtkSpinButton */
	d->width_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
	    20.0f, 20.0f, 320.0f, 1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	GUIEditableEndowPopupMenu(w, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_SPIN_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_WIDTH
	);
	/* Height GtkLabel */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Height"
#elif defined(PROG_LANGUAGE_FRENCH)
"Height"
#elif defined(PROG_LANGUAGE_GERMAN)
"Height"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Height"
#elif defined(PROG_LANGUAGE_DUTCH)
"Height"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Height"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Height"
#else
"Height"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Height GtkSpinButton */
	d->height_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
	    20.0f, 20.0f, 320.0f, 1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 60, -1);
	GUIEditableEndowPopupMenu(w, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_SPIN_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_HEIGHT
	);

	/* Border GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Border"
#elif defined(PROG_LANGUAGE_FRENCH)
"Border"
#elif defined(PROG_LANGUAGE_GERMAN)
"Border"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Border"
#elif defined(PROG_LANGUAGE_DUTCH)
"Border"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Border"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Border"
#else
"Border"
#endif
	    ":"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Border GtkSpinButton */
	d->border_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
	    2.0f, 0.0f, 48.0f, 1.0f, 5.0f, 0.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 50, -1);
	GUIEditableEndowPopupMenu(w, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_SPIN_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_THUMB_BORDER
	);


	/* Sample thumb GtkHBox */
	w = gtk_hbox_new(TRUE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_IN);
	gtk_widget_show(w);
	parent4 = w;

	/* Create sample thumb drawing area */
	d->drawing_area = w = gtk_drawing_area_new();
	gtk_object_set_data_full(
	    GTK_OBJECT(w), THUMB_SAMPLE_DATA_KEY,
	    d, EDVCustomizeImbrThumbSampleDataDestroyCB
	);
	gtk_widget_add_events(
	    w,
	    GDK_STRUCTURE_MASK | GDK_EXPOSURE_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "configure_event",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleEventCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "expose_event",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleEventCB), d
	);
	gtk_widget_set_usize(w, 320, 240);
	gtk_container_add(GTK_CONTAINER(parent4), w);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_DRAWING_AREA, w,
	    NULL, NULL
	);
	wref->ignore_changes = TRUE;

	gtk_signal_connect(
	    GTK_OBJECT(d->show_frame_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleUpdateCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->show_label_check), "toggled",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbSampleUpdateCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->width_adj), "value_changed",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->height_adj), "value_changed",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), d
	);
	gtk_signal_connect(
	    GTK_OBJECT(d->border_adj), "value_changed",
	    GTK_SIGNAL_FUNC(EDVCustomizeImbrThumbValueChangedCB), d
	);


}

/*
 *	Creates the Image Browser Tool Bar page.
 */
void EDVCustomizeImbrCreateToolBarPage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	gchar *name;
	GList *glist, *opid_list;
	GSList *gslist;
	GtkWidget *w, *parent2, *parent3;
	edv_gen_opt_wref_struct *wref;
	stack_list_struct *slist;
	edv_imbr_opid_struct *opid;


	/* Hbox for toolbar display and relief frames */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Display Buttons As Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue Abrocha Como"
#elif defined(PROG_LANGUAGE_FRENCH)
"L'exposition Boutonne Comme"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung Knpft Als Zu"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra Abbottona Come"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling Knoopt Als Dicht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Exiba Botes Como"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling Knapper Som"
#else
"Display Buttons As"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Text */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tekst"
#else
"Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_TEXT;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Images"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder"
#else
"Pictures"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Pictures & Text */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Los Retratos & Texto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Les Images & Le Texte"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bilder & Text"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Immagini & Il Testo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Afbeelding & Tekst"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Quadros & Texto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bilder & Tekst"
#else
"Pictures & Text"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY
	);
	wref->radio_value = TOOLBAR_DISPLAY_PICTURES_AND_TEXT;


	/* Buttons Relief Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Alivio De Botones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Soulagement De Boutons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Knpfe Erleichterung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Sollievo Di Bottoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Knopen Steun"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Alvio De Botes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Knapp Lettelse"
#else
"Buttons Relief"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Flush */
	gslist = NULL;
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"El Rubor"
#elif defined(PROG_LANGUAGE_FRENCH)
"Eclat"
#elif defined(PROG_LANGUAGE_GERMAN)
"Splen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Flusso"
#elif defined(PROG_LANGUAGE_DUTCH)
"Vloed"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Nivele"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Spyl"
#else
"Flush"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NONE;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Half */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Mitad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Moiti"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hlfte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Met"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helft"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Metade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Halvdel"
#else
"Half"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_HALF;
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

	/* Raised */
	w = gtk_radio_button_new_with_label(gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Levantado"
#elif defined(PROG_LANGUAGE_FRENCH)
"Hauss"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erhoben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Aumentato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opgetilde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Levantado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hevet"
#else
"Raised"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_RADIO_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF
	);
	wref->radio_value = TOOLBAR_RELIEF_NORMAL;



	/* Arrangement Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Arreglo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrangement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Anordnung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Disposizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schikking"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arranjo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arrangement"
#else
"Arrangement"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	/* Create Tool Bar Stack List */
	slist = StackListNew(
	    parent2,
#if defined(PROG_LANGUAGE_SPANISH)
"Disponible", "La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Disponible", "Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verfgbar", "Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Disponibile", "La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verkrijgbaar", "Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Disponvel", "A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilgjengelig", "Strm"
#else
"Available", "Current"
#endif
	);
	StackListShowDescription(slist, TRUE, TRUE);
	StackListSetMaintainSourceOrder(slist, TRUE);
	StackListMap(slist);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_STACK_LIST, slist,
	    NULL,
	    EDV_CFG_PARM_IMBR_TOOL_BAR
	);

	/* Create tool bar items from image browser operation ids */
	opid_list = EDVImbrOPIDListNew(NULL);
	for(glist = opid_list; glist != NULL; glist = g_list_next(glist))
	{
	    opid = EDV_IMBR_OPID(glist->data);
	    if(opid == NULL)
		continue;

	    name = EDVCustomizeSimplifyOPIDName(opid->menu_name);
	    StackListAppend(
		slist, name, opid->tooltip,
		opid->button_icon_data,
		NULL,				/* Client Data */
		(gint)opid->op,			/* ID */
		opid->flags & EDV_OPID_ALLOW_MULTIPLE,	/* Allow Multiple? */
		FALSE				/* Fixed On Target? */
	    );
	    g_free(name);
	}
	EDVImbrOPIDListDelete(opid_list);

	StackListUpdateMenus(slist);
}

/*
 *	Creates the Image Browser Appearance page.
 */
void EDVCustomizeImbrCreateAppearancePage(
	edv_core_struct *core, edv_gen_opt_win_struct *optwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
			border_minor = 2;
	GtkWidget *w, *parent2, *parent3, *parent4, *parent5;
	edv_gen_opt_wref_struct *wref;


	/* Hbox to separate two columns */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;


	/* First column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;

	/* Show In Title Bar Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Muestre En La Barra Del Ttulo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Montrer Dans La Barre De Titre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeigen Sie In Titel Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Mostrare Nella Sbarra Di Titolo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toon In Titel Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mostre Em Barra De Ttulo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Vis In Title Bar"
#else
"Show In Title Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show User Name */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"El Nombre Del Usuario"
#elif defined(PROG_LANGUAGE_FRENCH)
"Nom D'Utilisateur"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verbraucher Name"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Nome Di Operatore"
#elif defined(PROG_LANGUAGE_DUTCH)
"Gebruiker Naam"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nome De Operador"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bruker Name"
#else
"User Name"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TITLE_WITH_USER
	);

	/* Show Location */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering"
#else
"Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_TITLE_WITH_LOCATION
	);


	/* Display Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Tool Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Instrumento"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Outil"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werkzeug Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di attrezzo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Werktuig Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Ferramenta"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Redskap Bar"
#else
"Tool Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR
	);

	/* Show Location Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra De Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre D'Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ort Stab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Di Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Plaats Staaf"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra De Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Plassering Bar"
#else
"Location Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR
	);

	/* Show Mount Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra El Monte"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre Mont"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Untersatz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Sbarra Il Monte"
#elif defined(PROG_LANGUAGE_DUTCH)
"Staaf Berg"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Barra O Monte"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bar Fotstykke"
#else
"Mount Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR
	);

	/* Show Find Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Encuentre"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Trouver"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Finden"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Trova"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Vondst Uit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Acha"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Find"
#else
"Find Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_FIND_BAR
	);

	/* Show Status Bar */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Barra La Posicin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Barre La Statut"
#elif defined(PROG_LANGUAGE_GERMAN)
"Stab Sie Status"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Sbarra Lo Stato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Sluit Status"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barra Estado"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sperr Status"
#else
"Status Bar"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR
	);


	/* Second column vbox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;


	/* Filter Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Filtro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Filtre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Filter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Filtro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Filter"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Filtro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Filter"
#else
"Show"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Hidden Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Objetos Escondidos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Objets Cachs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Versteckte Objekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Oggetti Nascosti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbergenene Voorwerpen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Objetos Escondidos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Gjemte Objekt"
#else
"Hidden Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN
	);

	/* Show No Access Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Ningn Acceso Se Opone"
#elif defined(PROG_LANGUAGE_FRENCH)
"Aucuns Objets D'accs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Keine Zugriffsobjekte"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Nessuno Accesso Obbietta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geen Toegang Heeft Bezwaar"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Nenhum Acesso Ope-se"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ingen Tilgang Protesterer"
#else
"No Access Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS
	);

	/* Show Non-Image Objects */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Check Button */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"No Objetos De Imagen"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Non-Image S'Oppose"
#elif defined(PROG_LANGUAGE_GERMAN)
"Nicht-Bildnis Wendet Gegen Ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Non-Immagine Obbietta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Niete-beeld Heeft Bezwaar"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A No-Imagem Ope-se"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Ikke--avbilde Protesterer"
#else
"Non-Image Objects"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_TOGGLE_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE
	);


	/* Colors Frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Colores"
#elif defined(PROG_LANGUAGE_FRENCH)
"Couleurs"
#elif defined(PROG_LANGUAGE_GERMAN)
"Farben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Colori"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kleuren"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Cores"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Farger"
#else
"Colors"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;
	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Foreground */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_usize(w, 80, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Primera Plana"
#elif defined(PROG_LANGUAGE_FRENCH)
"Premier Plan"
#elif defined(PROG_LANGUAGE_GERMAN)
"Vordergrund"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Primo Piano"
#elif defined(PROG_LANGUAGE_DUTCH)
"Voorgrond"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Cho De Frente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forgrunn"
#else
"Foreground"
#endif
	    ":"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	/* Color Button */
	w = CSDColorButtonNewSimple(NULL, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_COLOR_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_COLOR_FG
	);

	/* Background */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_usize(w, 80, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Fondo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Arrire-Plan"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hintergrund"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo Sfondo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Achtergrond"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Cho Posterior"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bakgrunn"
#else
"Background"
#endif
	    ":"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	/* Color Button */
	w = CSDColorButtonNewSimple(NULL, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_COLOR_BUTTON, w,
	    NULL,
	    EDV_CFG_PARM_IMBR_COLOR_BG
	);

	/* Border */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_alignment_new(1.0f, 0.5f, 0.0f, 0.0f);
	gtk_widget_set_usize(w, 80, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Frontera"
#elif defined(PROG_LANGUAGE_FRENCH)
"Frontire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Rand"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Frontiera"
#elif defined(PROG_LANGUAGE_DUTCH)
"Rand"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Fronteira"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Grense"
#else
"Border"
#endif
	    ":"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	/* Color Button */
	w = CSDColorButtonNewSimple(NULL, -1);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	wref = EDVGenOptWinWRefAppend(
	    optwin,
	    EDV_GEN_OPT_WIDGET_COLOR_BUTTON, w,
	    NULL, EDV_CFG_PARM_IMBR_COLOR_BORDER
	);

}
