#ifndef EDV_ARCHIVE_STAT_H
#define EDV_ARCHIVE_STAT_H

#include <glib.h>
#include "edv_types.h"
#include "edv_archive_obj.h"


extern const gchar *EDVArchStatGetError(edv_core_struct *core);

extern edv_archive_object_struct *EDVArchStat(
	edv_core_struct *core,
	const gchar *arch_path,
	const gchar *path,
	const gchar *password
);
extern gint EDVArchStatListSequential(
	edv_core_struct *core,
	const gchar *arch_path,
	GList *paths_list,			/* List of gchar * paths */
	const gchar *filter,
	const gchar *password,
	gint (*obj_rtn_cb)(
		const gchar *arch_path,
		edv_archive_object_struct *obj,
		const gulong i, const gulong m,
		gpointer data
	),
	gpointer obj_rtn_data
);
extern GList *EDVArchStatList(
	edv_core_struct *core,
	const gchar *arch_path,
	GList *paths_list,			/* List of gchar * paths */
	const gchar *filter,
	const gchar *password,
	gint (*progress_cb)(
		const gchar *,
		const gulong, const gulong,
		gpointer
	),
	gpointer progress_data
);


#endif	/* EDV_ARCHIVE_STAT_H */
