/*
                                  Devices List
 */

#ifndef EDV_DEVICES_LIST_H
#define EDV_DEVICES_LIST_H

#include <glib.h>
#include "edv_types.h"
#include "edv_device.h"


/* Devices List Matching */
extern edv_device_struct *EDVDevicesListMatchMountPath(
        edv_device_struct **list, const gint total,
        gint *n,
        const gchar *mount_path
);
extern edv_device_struct *EDVDevicesListMatchDevicePath(
        edv_device_struct **list, const gint total,
        gint *n,
        const gchar *device_path
);
extern edv_device_struct *EDVDevicesListMatchObject(
        edv_device_struct **list, const gint total,
        gint *n,
        const gchar *path
);

/* Get Devices List From System */
extern void EDVDevicesListLoadFromSystem(
	edv_device_struct ***list, gint *total,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer client_data
);

/* Mount States */
extern void EDVDevicesListUpdateMountStatesFromSystem(
	edv_device_struct **list, const gint total
);
extern void EDVDevicesListUpdateMountStates(
        edv_device_struct **list, const gint total
);

/* Stats */
extern void EDVDevicesListUpdateStats(
        edv_device_struct **list, const gint total
);

/* Devices List Open & Save */
extern void EDVDevicesListFileOpen(
	const gchar *filename,
	edv_device_struct ***list, gint *total,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer client_data
);
extern void EDVDeviceListFileSave(
	const gchar *filename,
	edv_device_struct **list, const gint total,
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer client_data
);


#endif	/* EDV_DEVICES_LIST_H */
