/*
                        Endeavour Object Finding
 */

#ifndef EDV_FIND_H
#define EDV_FIND_H

#include <sys/stat.h>
#include <glib.h>


/* Archive Finding */
extern gint EDVFindArchiveObjectByName(
	edv_core_struct *core,
	const gchar *arch_path,
	const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, const struct stat *, gpointer),
	gpointer match_data
);

/* Recycled Object Finding */
extern gint EDVFindRecycledObjectByContent(
	const gchar *recycled_index_file,
	const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *, const struct stat *,
		const gchar *, gint,
		gpointer
	),
	gpointer match_data
);
extern gint EDVFindRecycledObjectByName(
	const gchar *recycled_index_file, const gchar *expression,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, const struct stat *, gpointer),
	gpointer match_data
);

/* Object Finding */
extern gint EDVFindObjectByContent(
	const gchar *start_dir,
	const gchar *expression,
	const gboolean recursive,
	const gboolean follow_links,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(
		const gchar *, const struct stat *,
		const gchar *, gint,
		gpointer
	),
	gpointer match_data
);
extern gint EDVFindObjectByName(
	const gchar *start_dir,
	const gchar *expression,
	const gboolean recursive,
	const gboolean follow_links,
	const gboolean case_sensitive,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	gpointer progress_data,
	void (*match_cb)(const gchar *, const struct stat *, gpointer),
	gpointer match_data
);


#endif	/* EDV_FIND_H */
