/*
                              Endeavour History
 */

#ifndef EDV_HISTORY_H
#define EDV_HISTORY_H

#include <glib.h>
#include "edv_types.h"


typedef struct _edv_history_struct	edv_history_struct;
#define EDV_HISTORY(p)			((edv_history_struct *)(p))


/*
 *	History Item:
 */
struct _edv_history_struct {

	edv_history_type	type;	/* One of EDV_HISTORY_* */

	gulong		time_start,	/* Time the operation first started */
			time_end;	/* Time the operation ended */

	/* Result of operation, valid codes are:
	 *
	 *	0	Success.
	 *	-1	General error.
	 *	-2	Invalid value.
	 *	-3	Systems error or memory allocation error.
	 *	-4	User abort.
	 *	-5	User responded with `No'
	 *	-6	Operation would cause re-entry.
	 */
	gint		status;

	/* Full path to source and target objects in most cases
	 *
	 * If the object is a recycled object then one of these may be
	 * a string specifying an index number of the recycled object
	 *
	 * If the object is an archive object then one of these may be
	 * a relative (but complete) path to the archive object within
	 * the archive
 	 */
	gchar		*src_path,
			*tar_path;

	gchar		*comments;

};


extern edv_history_struct *EDVHistoryNew(void);
extern edv_history_struct *EDVHistoryCopy(const edv_history_struct *h);
extern void EDVHistoryDelete(edv_history_struct *h);

extern void EDVHistorySetValues(
	edv_history_struct *h,
	const edv_history_type type,
	const gulong time_start,	/* In systime seconds */
	const gulong time_end,		/* In systime seconds */
	const gint status,
	const gchar *src_path,		/* Source */
	const gchar *tar_path,		/* Target */
	const gchar *comments
);


#endif	/* EDV_HISTORY_H */
