#include <glib.h>

#include "edv_types.h"
#include "edv_recycled_obj.h"


edv_recycled_object_struct *EDVRecycledObjectNew(void);
edv_recycled_object_struct *EDVRecycledObjectCopy(
	edv_recycled_object_struct *obj
);
void EDVRecycledObjectDelete(
	edv_recycled_object_struct *obj
);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new Recycled Object.
 */
edv_recycled_object_struct *EDVRecycledObjectNew(void)
{
	return(EDV_RECYCLED_OBJECT(g_malloc0(
	    sizeof(edv_recycled_object_struct)
	)));
}

/*
 *	Coppies the Recycled Object.
 */
edv_recycled_object_struct *EDVRecycledObjectCopy(
	edv_recycled_object_struct *obj
)
{
	edv_recycled_object_struct *new_obj;

	if(obj == NULL)
	    return(NULL);

	new_obj = EDVRecycledObjectNew();
	if(new_obj == NULL)
	    return(NULL);

	new_obj->name = STRDUP(obj->name);
	new_obj->original_path = STRDUP(obj->original_path);
	new_obj->index = obj->index;
	new_obj->deleted_time = obj->deleted_time;

	new_obj->type = obj->type;
	new_obj->link_target = STRDUP(obj->link_target);
	new_obj->permissions = obj->permissions;
	new_obj->access_time = obj->access_time;
	new_obj->modify_time = obj->modify_time;
	new_obj->change_time = obj->change_time;
	new_obj->owner_id = obj->owner_id;
	new_obj->group_id = obj->group_id;
	new_obj->size = obj->size;

	return(new_obj);
}

/*
 *	Deletes the Recycled Object.
 */
void EDVRecycledObjectDelete(edv_recycled_object_struct *obj)
{
	if(obj == NULL)
	    return;

	g_free(obj->name);
	g_free(obj->original_path);
	g_free(obj->link_target);

	g_free(obj);
}
