/*
		       Endeavour Data Types & Enumerations
 */

#ifndef EDV_TYPES_H
#define EDV_TYPES_H

#include <glib.h>


/*
 *	Size Format:
 */
typedef enum {
	EDV_SIZE_FORMAT_RAW,			/* 123456679 */
	EDV_SIZE_FORMAT_DELIMINATED,		/* 123,456,679 */
	EDV_SIZE_FORMAT_BLOCKS,			/* 1.2K, 923K, 1232K */
	EDV_SIZE_FORMAT_HUMAN_READABLE		/* 1.2K, 234M, 2G */
} edv_size_format;


/*
 *	Object Types:
 */
typedef enum {
	EDV_OBJECT_TYPE_UNKNOWN			= 0,
	EDV_OBJECT_TYPE_FILE			= 1,
	EDV_OBJECT_TYPE_DIRECTORY		= 2,
	EDV_OBJECT_TYPE_LINK			= 3,
	EDV_OBJECT_TYPE_DEVICE_BLOCK		= 4,
	EDV_OBJECT_TYPE_DEVICE_CHARACTER	= 5,
	EDV_OBJECT_TYPE_FIFO			= 6,
	EDV_OBJECT_TYPE_SOCKET			= 7,
	EDV_OBJECT_TYPE_ERROR			= 128
} edv_object_type;


/*
 *	Permission Flags:
 */
typedef enum {
	/* User */
	EDV_PERMISSION_UEXECUTE		= (1 << 0),
	EDV_PERMISSION_UREAD		= (1 << 1),
	EDV_PERMISSION_UWRITE		= (1 << 2),

	/* Group */
	EDV_PERMISSION_GEXECUTE		= (1 << 3),
	EDV_PERMISSION_GREAD		= (1 << 4),
	EDV_PERMISSION_GWRITE		= (1 << 5),

	/* Anonymous/Other */
	EDV_PERMISSION_AEXECUTE		= (1 << 6),
	EDV_PERMISSION_AREAD		= (1 << 7),
	EDV_PERMISSION_AWRITE		= (1 << 8),

	/* SetUD, SetGID, Sticky */
	EDV_PERMISSION_SETUID		= (1 << 9),
	EDV_PERMISSION_SETGID		= (1 << 10),
	EDV_PERMISSION_STICKY		= (1 << 11)
} edv_permission_flags;


/*
 *	Operation ID Flags:
 */
typedef enum {
	EDV_OPID_ALLOW_MULTIPLE		= (1 << 0),	/* Allow more than one
							 * instance per list */
	EDV_OPID_NO_OP			= (1 << 1)	/* Does not perform an
							 * operation (eg for
							 * separators) */
} edv_opid_flags;


/*
 *	Delete Methods:
 */
typedef enum {
	EDV_DELETE_METHOD_RECYCLE	= 0,
	EDV_DELETE_METHOD_PURGE		= 1
} edv_delete_method;


/*
 *	MIME Type Classes:
 */
typedef enum {
	EDV_MIME_TYPE_CLASS_SYSTEM	= 0,	/* System object type */
	EDV_MIME_TYPE_CLASS_FORMAT	= 1,	/* File format */
	EDV_MIME_TYPE_CLASS_PROGRAM	= 2,	/* Program object */
	EDV_MIME_TYPE_CLASS_UNIQUE	= 3	/* Unique object */
} edv_mime_type_class;


/*
 *	MIME Type Handlers:
 */
typedef enum {
	EDV_MIME_TYPE_HANDLER_COMMAND		= 0,	/* Use Command */
	EDV_MIME_TYPE_HANDLER_EDV_ARCHIVER	= 1,	/* Use Archiver */
	EDV_MIME_TYPE_HANDLER_EDV_IMAGE_BROWSER	= 2,	/* Use Image Browser */
	EDV_MIME_TYPE_HANDLER_EDV_RECYCLE_BIN	= 3	/* Use Recycle Bin */
} edv_mime_type_handler;


/*
 *	History Types:
 */
typedef enum {
	EDV_HISTORY_UNKNOWN			= 0,
	EDV_HISTORY_SYNC_DISKS			= 1,
	EDV_HISTORY_SYNC_RECBIN			= 2,

	EDV_HISTORY_DISK_OBJECT_CREATE		= 10,
	EDV_HISTORY_DISK_OBJECT_COPY		= 11,
	EDV_HISTORY_DISK_OBJECT_MOVE		= 12,	/* Or rename */
	EDV_HISTORY_DISK_OBJECT_LINK		= 13,
	EDV_HISTORY_DISK_OBJECT_CHOWN		= 14,
	EDV_HISTORY_DISK_OBJECT_CHMOD		= 15,
	EDV_HISTORY_DISK_OBJECT_CHTIME		= 16,
	EDV_HISTORY_DISK_OBJECT_DOWNLOAD	= 17,
	EDV_HISTORY_DISK_OBJECT_DELETE		= 18,

	EDV_HISTORY_RECYCLED_OBJECT_RECOVER	= 20,
	EDV_HISTORY_RECYCLED_OBJECT_PURGE	= 21,
	EDV_HISTORY_RECYCLED_OBJECT_PURGE_ALL	= 22,

	EDV_HISTORY_ARCHIVE_OBJECT_ADD		= 30,
	EDV_HISTORY_ARCHIVE_OBJECT_EXTRACT	= 31,
	EDV_HISTORY_ARCHIVE_OBJECT_DELETE	= 32,
	EDV_HISTORY_ARCHIVE_FIX			= 38
} edv_history_type;


/*
 *	Core Pending Operation Flags:
 */
typedef enum {
	EDV_CORE_PENDING_CLOSE_ALL_WINDOWS	= (1 << 0),
	EDV_CORE_PENDING_RESET			= (1 << 1)
} edv_core_pending_flags;


/*
 *	Core:
 *
 *	Forward declaration, see endeavour2.h for complete declaration.
 */
typedef struct _edv_core_struct         edv_core_struct;


#endif	/* EDV_TYPES_H */
