/*
 *	Appends a History Event
 */

#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
        /* Initialize the Endeavour2 Context */
	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	if(argc > 1)
	{
	    const gchar *type_str = argv[1];
	    edv_history_type type;
	    const gint status = (argc > 2) ? atoi(argv[2]) : 0;
	    const gchar *source = (argc > 3) ? argv[3] : NULL;
	    const gchar *target = (argc > 4) ? argv[4] : NULL;
	    const gchar *comments = (argc > 5) ? argv[5] : NULL;

	    if(isdigit(*type_str))
		type = (edv_history_type)atoi(type_str);
	    else if(!g_strcasecmp(type_str, "sync_disks"))
		type = EDV_HISTORY_SYNC_DISKS;
	    else if(!g_strcasecmp(type_str, "sync_recbin"))
                type = EDV_HISTORY_SYNC_RECBIN;
            else if(!g_strcasecmp(type_str, "disk_object_create"))
                type = EDV_HISTORY_DISK_OBJECT_CREATE;
            else if(!g_strcasecmp(type_str, "disk_object_copy"))
                type = EDV_HISTORY_DISK_OBJECT_COPY;
            else if(!g_strcasecmp(type_str, "disk_object_move"))
                type = EDV_HISTORY_DISK_OBJECT_MOVE;
            else if(!g_strcasecmp(type_str, "disk_object_link"))
                type = EDV_HISTORY_DISK_OBJECT_LINK;
            else if(!g_strcasecmp(type_str, "disk_object_chown"))
                type = EDV_HISTORY_DISK_OBJECT_CHOWN;
            else if(!g_strcasecmp(type_str, "disk_object_chmod"))
                type = EDV_HISTORY_DISK_OBJECT_CHMOD;
            else if(!g_strcasecmp(type_str, "disk_object_set_time"))
                type = EDV_HISTORY_DISK_OBJECT_CHTIME;
            else if(!g_strcasecmp(type_str, "disk_object_download"))
                type = EDV_HISTORY_DISK_OBJECT_DOWNLOAD;
            else if(!g_strcasecmp(type_str, "disk_object_delete"))
                type = EDV_HISTORY_DISK_OBJECT_DELETE;
            else if(!g_strcasecmp(type_str, "recycled_object_recover"))
                type = EDV_HISTORY_RECYCLED_OBJECT_RECOVER;
            else if(!g_strcasecmp(type_str, "recycled_object_purge"))
                type = EDV_HISTORY_RECYCLED_OBJECT_PURGE;
            else if(!g_strcasecmp(type_str, "recycled_object_purge_all"))
                type = EDV_HISTORY_RECYCLED_OBJECT_PURGE_ALL;
            else if(!g_strcasecmp(type_str, "archive_object_add"))
                type = EDV_HISTORY_ARCHIVE_OBJECT_ADD;
            else if(!g_strcasecmp(type_str, "archive_object_extract"))
                type = EDV_HISTORY_ARCHIVE_OBJECT_EXTRACT;
            else if(!g_strcasecmp(type_str, "archive_object_delete"))
                type = EDV_HISTORY_ARCHIVE_OBJECT_DELETE;
	    else
		type = EDV_HISTORY_UNKNOWN;

	    EDVHistoryAppend(
		ctx,
		type,
		time(NULL),
		time(NULL) + 1,
		status,
		source, target, comments
	    );
	}
	else
	{
	    g_print(
"Usage: %s <type> [status] [source] [target] [comments]\n",
		argv[0]
	    );
	}

        /* Flush any pending Endeavour2 operations */
	EDVContextSync(ctx);

        /* Shutdown the Endeavour2 context */
	EDVContextDelete(ctx);

	return(0);
}
