/*
				Zip Tool Window
 */

#ifndef ZIPTOOL_H
#define ZIPTOOL_H

#include <gtk/gtk.h>
#include "../pie_chart.h"
#include "../edv_types.h"
#include "../toolbar.h"
#include "../lib/endeavour2.h"
#include "ziptoolio.h"


/*
 *	Operations
 */
#define ZIP_TOOL_OPID_CLOSE			10
#define ZIP_TOOL_OPID_EXIT			11

#define ZIP_TOOL_OPID_MOUNT			30
#define ZIP_TOOL_OPID_UNMOUNT			31

#define ZIP_TOOL_OPID_SPIN_DOWN			35
#define ZIP_TOOL_OPID_EJECT			36

#define ZIP_TOOL_OPID_PASSWORD			40

#define ZIP_TOOL_OPID_BROWSE			50
#define ZIP_TOOL_OPID_REFRESH			51
#define ZIP_TOOL_OPID_FSCK			52


/*
 *	Zip Tool Window Operation ID:
 */
typedef struct {

	gint		id;
	gpointer	zt;		/* Pointer back to Zip Tool Window */

	gchar		*name;		/* Full name */
	gchar		*button_name;	/* Short name (used in buttons) */
 	guint8		**icon_data;	/* Shared */
	gchar		*tooltip;	/* Tool tip message */

	void (*func_cb)(GtkWidget *, gpointer);
	gint (*func_enter_cb)(GtkWidget *, GdkEventCrossing *, gpointer);
	gint (*func_leave_cb)(GtkWidget *, GdkEventCrossing *, gpointer);

} zip_tool_opid_struct;
#define ZIP_TOOL_OPID(p)	((zip_tool_opid_struct *)(p))

/*
 *	Zip Tools Window:
 */
typedef struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		freeze_count,
			busy_count;
	edv_context_struct	*ctx;

	GdkCursor	*busy_cur,
			*text_cur;

	GList		*opid;

	toolbar_struct	*tool_bar;

	GtkWidget	*main_vbox,
			*tool_bar_handle,
			*display_event_box,
			*display_parent,	/* GtkVBox */
			*display_child;		/* GtkHBox */

	/* Display area widgets */
	pie_chart_struct	*capacity_piechart;
	GtkWidget	*display_mount_path_btn,
			*display_mount_btn,
			*display_lock_btn;

	/* Status bar widgets */
	GtkWidget	*status_label;

	GtkWidget	*menu,			/* Right click menu */
			*mount_mi,
			*unmount_mi,
			*spin_down_mi,
			*eject_mi,
			*password_mi,
			*fsck_mi,
			*refresh_mi;

	/* IOMega Jaz or Zip drive device reference */
	edv_device_struct	*device;

	zip_tool_lock_state	lock_state;

} zip_tool_struct;
#define ZIP_TOOL(p)	((zip_tool_struct *)(p))


extern zip_tool_opid_struct *ZipToolOPIDListFind(GList *opid, gint id);
extern GList *ZipToolOPIDListNew(zip_tool_struct *zt);
extern void ZipToolOPIDListDelete(GList *opid);

extern void ZipToolSetDevice(
	zip_tool_struct *zt, edv_device_struct *dev_ptr
);
extern void ZipToolRefreshDevice(
	zip_tool_struct *zt, edv_device_struct *dev_ptr
);

extern zip_tool_struct *ZipToolNew(edv_context_struct *ctx);
extern void ZipToolUpdate(zip_tool_struct *zt);
extern void ZipToolSetBusy(zip_tool_struct *zt, gboolean is_busy);
extern void ZipToolStatusMessage(
	zip_tool_struct *zt, const gchar *mesg,
	gboolean allow_gtk_iteration

);
extern gboolean ZipToolIsMapped(zip_tool_struct *zt);
extern void ZipToolMap(zip_tool_struct *zt);
extern void ZipToolUnmap(zip_tool_struct *zt);
extern void ZipToolDelete(zip_tool_struct *zt);


#endif	/* ZIPTOOL_H */
