/*
	    Object Copying, Moving, Linking, Renaming, Chowning, etc

	See edv_recbin_delete.h for object deleting.
 */

#ifndef EDV_OBJ_OP_H
#define EDV_OBJ_OP_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern const gchar *EDVObjectOPGetError(edv_core_struct *core);

extern gint EDVObjectOPCopy(
	edv_core_struct *core,
	const gchar *src_path,
	const gchar *tar_path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPMove(
	edv_core_struct *core,
	const gchar *src_path,
	const gchar *tar_path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPLink(
	edv_core_struct *core,
	const gchar *path,
	const gchar *dest_path,
	gchar **new_path_rtn,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPRelink(
	edv_core_struct *core,
	const gchar *path,
	const gchar *new_dest_value,
	GList **modified_paths_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPRename(
	edv_core_struct *core,
	const gchar *path,
	const gchar *new_name,
	GList **modified_paths_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all
);
extern gint EDVObjectOPChMod(
	edv_core_struct *core,
	GList *paths_list,
	const edv_permission_flags permissions,
	GList **modified_paths_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean recursive,
	const gboolean archive
);
extern gint EDVObjectOPChOwn(
	edv_core_struct *core,
	GList *paths_list,
	const gint owner_id, const gint group_id,
	GList **modified_paths_list,
	GtkWidget *toplevel,
	const gboolean show_progress,
	const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean recursive,
	const gboolean archive
);
extern gint EDVObjectOPChTime(
	edv_core_struct *core,
	GList *paths_list,
	const gulong atime, const gulong mtime,
	GList **modified_paths_list,
	GtkWidget *toplevel,
        const gboolean show_progress,
	const gboolean interactive,
        gboolean *yes_to_all,
	const gboolean recursive,
	const gboolean archive
);


#endif	/* EDV_OBJ_OP_H */
