#ifndef SPLASH_H
#define SPLASH_H

#include <gtk/gtk.h>
#include "guiutils.h"


typedef struct _splash_struct		splash_struct;
#define SPLASH(p)			((splash_struct *)(p))


/*
 *	Splash Effects:
 */
typedef enum {
	SPLASH_EFFECTS_NONE,
	SPLASH_EFFECTS_FADE_WHITE,
	SPLASH_EFFECTS_FADE_BLACK,
	SPLASH_EFFECTS_FADE_BACKGROUND
} splash_effects;


/*
 *	Default Splash Map/Unmap Durations:
 */
#define SPLASH_DEF_MAP_DURATION_MS	750l
#define SPLASH_DEF_UNMAP_DURATION_MS	750l


/*
 *	Splash:
 */
struct _splash_struct {

	GtkWidget	*toplevel;
	gboolean	map_state;
	gint		freeze_count;
	GdkGC		*gc;
	guint		draw_idle_id;

	gchar		*xpm_file;
	const guint8	**xpm_data;

	guint8		*rgba;		/* Splash image */
	gint		rgba_width,
			rgba_height,
			rgba_bpl;

	guint8		*bg_rgba;	/* Background image */
	gint		bg_rgba_width,
			bg_rgba_height,
			bg_rgba_bpl;

	gfloat		value;		/* 0.0 to 1.0 or -1.0 */
	gchar		*message;
	GdkFont		*message_font;
	GdkColor	*message_fg_color,
			*message_bg_color;
	GdkTextBounds	message_bounds;
	GtkJustification	message_justify;
	GtkPositionType	message_position;
};


extern void SplashDraw(splash_struct *splash);
extern void SplashQueueDraw(splash_struct *splash);

extern splash_struct *SplashNew(void);
extern void SplashSetXPMFile(
	splash_struct *splash,
	const gchar *xpm_file
);
extern void SplashSetXPMData(
	splash_struct *splash,
	const guint8 **xpm_data
);
extern void SplashSetMessageColor(
        splash_struct *splash,
        GdkColor *fg_color,
        GdkColor *bg_color
);
extern void SplashSetMessageFont(
	splash_struct *splash,
	GdkFont *font
);
extern void SplashSetMessageJustification(
	splash_struct *splash,
	const GtkJustification justify
);
extern void SplashSetMessagePosition(
	splash_struct *splash,
	const GtkPositionType position
);
extern void SplashUpdateMessage(
	splash_struct *splash,
	const gfloat v,
	const gchar *msg
);
extern void SplashUpdate(splash_struct *splash);
extern void SplashMap(
	splash_struct *splash,
	const splash_effects effects,
	const gulong duration_ms,
	const GtkWindowPosition position
);
extern void SplashUnmap(
	splash_struct *splash,
	const splash_effects effects,
	const gulong duration_ms
);
extern void SplashDelete(splash_struct *splash);


#endif	/* SPLASH_H */
