#-------------------------------------------------------------------------------
#  
#  Defines shared items used by the 'enable.om' package.
#  
#  Written by: David C. Morrill
#  
#  Date: 02/19/2005
#  
#  (c) Copyright 2005 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from enthought.traits.ui.api import Handler

#-------------------------------------------------------------------------------
#  'OMHandler' class:  
#-------------------------------------------------------------------------------

class OMHandler ( Handler ):
    
    #---------------------------------------------------------------------------
    #  Handles setting a specified object trait's value:
    #---------------------------------------------------------------------------
        
    def setattr ( self, object, name, value ):
        """ Handles setting a specified object trait's value.
        """
        super( OMHandler, self ).setattr( object, name, value )
        object.update()
        
# Create a singleton instance of the handler:
om_handler = OMHandler()

